<?php
/**
 * Customer new account email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-new-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates\Emails
 * @version 6.0.0
 */
defined( 'ABSPATH' ) || exit;
do_action( 'woocommerce_email_header', $email_heading, $email ); ?>
<?php /* translators: %s: Customer username */ ?>
<p><?php printf( esc_html__( 'Hi %s', 'woocommerce' ), esc_html( $user_login ) ); ?></p>
<p>Welcome to Good Nutrition. We’re excited to have you join us on the journey to better health, better fitness, better mindfulness and a better life.</p>
<p>Your username: <?php printf( esc_html__( '%s' ,'woocommerce' ), esc_html( $user_login ) ); ?></p>
<p>To place an order, go to <a href="https://goodnutrition.in/shop/">https://goodnutrition.in/shop/</a></p>
<p>To access and edit your profile, view orders, change password and more, go to <a href="https://goodnutrition.in/my-account/">https://goodnutrition.in/my-account/</a></p>
<p>We look forward to partnering with your on your health journey.</p>
<p>Regards</p>
<p>Good Nutrition</p>
<p>Do better. Everyday.</p>
<?php
do_action( 'woocommerce_email_footer', $email );
?>
