<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */
defined( 'ABSPATH' ) || exit;
global $product;
do_action( 'woocommerce_before_single_product' );
if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
<?php
	do_action( 'woocommerce_before_single_product_summary' );
	?>
<div class="summary entry-summary product-summary">
	<h1><?php the_title(); ?></h1>
	<?php $flavour_text = get_field('product_flavour_text');
	if ( !empty($flavour_text) ) {?>
		<div class="product-flavour"><?php echo $flavour_text; ?></div>
	<?php }?>
	  <div class="deception">
		  <?php the_excerpt(); ?>
	  </div>
	<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
	$cat_slug = $catTerms[0]->slug;
	?>
	<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
	<div class="product-category">
		<!-- <span>Category</span> -->
		<div class="category-name" style="background-color:<?php echo $cat_color ?>"><?php echo $catTerms[0]->name;?></div>
	</div>
	<?php  $bestseller = get_field('bestseller_text_line'); if ( !empty($bestseller) ) {?>	<div class="product-seller"><?php echo $bestseller; ?></div> <?php }?>
	<?php if( have_rows('product_ican') ):?>
		<ul class="nutrition-list">
		<?php
		while ( have_rows('product_ican') ) : the_row();?>
			<?php $num_img = get_sub_field('product_ican');
			if ( !empty(($num_img)) ) {
			?>
				<li><?php echo wp_get_attachment_image( $num_img['id'], 'full'); ?></li>
			<?php }?>
		<?php endwhile;?>
		</ul>
	<?php endif;?>
	<div class="product-info">
		<div class="price-review dd">
				<div class="pro-price">
					<div class="product-price">
						<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';
								show_sale_percentage_loop();
					?>
					</div>
					<div class="taxes">(inclusive of all taxes)</div>
				</div>
			<?php
				$rating_count = $product->get_rating_count();
				$review_count = $product->get_review_count();
				$average      = $product->get_average_rating();
				if ( $rating_count >= 0 ) : ?>
					<div class="review">
					<a href="#scroll-reviews" tabindex="0"><div class="rating-count"><?php echo round($average, 1); ?></div>
					<div class="rating-star">
						<span class="star_rating"><span style="width: <?php echo ($average * 20);?>%"></span></span>
					</div>
					<!-- <span id="review-part" class="total-reviews" >reviews</span></a> -->
					<a id="review-part" class="total-reviews" tabindex="0"><?php echo $review_count;?> reviews</a>
					</div>
				<?php endif;
				?>
		</div>
	  <?php
	/**
	 * Hook: woocommerce_single_product_summary.
	 *
	 * @hooked woocommerce_template_single_title - 5
	 * @hooked woocommerce_template_single_rating - 10
	 * @hooked woocommerce_template_single_price - 10
	 * @hooked woocommerce_template_single_excerpt - 20
	 * @hooked woocommerce_template_single_add_to_cart - 30
	 * @hooked woocommerce_template_single_meta - 40
	 * @hooked woocommerce_template_single_sharing - 50
	 * @hooked WC_Structured_Data::generate_product_data() - 60
	 */
	do_action('woocommerce_single_product_summary');
	?>
</div>
<div class="product-policy">
	<ul>
		<li>
			<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/cod-available.svg" alt="cod-available"></figure>
			<span>Free COD Available</span>
		</li>
		<li>
			<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/free-shipping.svg" alt="free-shipping"></figure>
			<span>Free Shipping</span>
		</li>
		<li>
			<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/secure-payment.svg" alt="secure-payment"></figure>
			<span>Secure Payment</span>
		</li>
		<li>
			<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/easy-return.svg" alt="easy-return"></figure>
			<span>Easy Return</span>
		</li>
	</ul>
</div>
</div>
<?php do_action( 'woocommerce_after_single_product' ); ?>
</main>
</div>
</div>
</div>
<div class="product-combination">
<div class="container">
	<div class="product-box">
		<div class="lft">
			<div class="post-image">
			<img src="<?php echo get_the_post_thumbnail_url($loop->post->ID); ?>" class="img-responsive" style= "width:50px; height:50px;" alt=""/></div>
			<h5><?php the_title(); ?></h5>
		</div>
		<?php  $product->get_stock_quantity();?>
		<div class="product-price">
			<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';?>
	<?php
		echo apply_filters(
			'woocommerce_loop_add_to_cart_link',
			sprintf(
				'<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="button %s product_type_%s">%s</a>',
				esc_url( $product->add_to_cart_url() ),
				esc_attr( $product->get_id() ),
				esc_attr( $product->get_sku() ),
				$product->is_purchasable() ? 'add_to_cart_button' : '',
				esc_attr( $product->product_type ),
				esc_html( $product->add_to_cart_text() )
			),
			$product
		);?>
	</div>
	</div>
</div>
</div>
<section class="bannerimage">
<?php $image = get_field('banner_image');
	$imageurl = get_field('url');
	if(!empty($image)){ ?>
	<a href="<?php echo $imageurl; ?>" target="_blank"> <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" /></a>
	<?php }
?>
</section>
<section class="nutrition-unique">
<div class="small-container">
<h2 class="section-heading  fade-in-bottom"><?php echo  get_field('what_makes_good_nutrition'); ?></h2>
<?php if( have_rows('pro-details') ):?>
		<ul class=" fade-in-bottom mt-60">
			<?php while( have_rows('pro-details') ): the_row(); ?>
				<?php $pro_icon= get_sub_field('icon' ); ?>
				<?php $pro_description= get_sub_field('description' ); ?>
				<li>
<figure><?php echo wp_get_attachment_image( $pro_icon['id'], 'full'); ?></figure>
<?php echo $pro_description; ?></li>
			<?php endwhile; ?>
<?php endif; ?>
		</ul>
</div>
</section>
<div class="sml-shop-wrap sml-page-wrap sml-archive-wrapper">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="container">
			<div class="tab-section mt-65">
				<div id="horizontalTab">
				<ul class="resp-tabs-list">
					<li>Product details</li>
					<li>Ingredients</li>
					<li>Benefits</li>
					<li>How it works</li>
					<li>How to use</li>
				</ul>
				<div class="resp-tabs-container">
					<div>
						<p><?php the_content(); ?></p>
					</div>
					<div>
						<div class="product-description"><?php echo  get_field('ingredients'); ?></div>
						<ul class="ingredient-list">
							<?php if( have_rows('ingredient_details') ):?>
			<?php while( have_rows('ingredient_details') ): the_row(); ?>
				<?php $ingredienticon= get_sub_field('ingredient_icon' ); ?>
				<?php $ingredienttitle= get_sub_field('ingredient_title' ); ?>
				<?php $ingredientdescription= get_sub_field('ingredient_description' ); ?>
				<li>
					<div class="lft-box">
						<?php echo wp_get_attachment_image( $ingredienticon['id'], 'full'); ?>
					</div>
					<div class="rgt-box">
						<h4><?php echo $ingredienttitle;?></h4>
						<div><?php echo $ingredientdescription;?></div>
					</div>
				</li>
			<?php endwhile; ?>
							<?php endif; ?>
						</ul>
					</div>
					<div>
						<p><?php echo  get_field('benefits'); ?></p>
					</div>
					<div>
						<p><?php echo  get_field('how_it_works'); ?></p>
					</div>
					<div>
						<p><?php echo  get_field('how_to_use'); ?></p>
					</div>
				</div>
				</div>
			</div>
			<div class="tab-section mt-65" id="scroll-reviews">
				<div id="horizontalTab2">
					<ul class="resp-tabs-list flex-start">
						<li id="review_tab" class="r-view">Reviews</li>
						<li class="n-view">Nutritional info</li>
					</ul>
					<div class="resp-tabs-container">
						<div id="tab-reviews">
							<?php echo do_shortcode('[cusrev_reviews shop_reviews="true"]'); ?>
							<div class="comments"></div>
					</div>
					<div id="nut_id">
							<p><?php echo  get_field('nutritional_info'); ?></p>
					</div>
				</div>
			</div>
		</div>
		<div class="also-like recentview">
			<?php
			/**
			 * Hook: woocommerce_after_single_product_summary.
			 *
			 * @hooked woocommerce_output_product_data_tabs - 10
			 * @hooked woocommerce_upsell_display - 15
			 * @hooked woocommerce_output_related_products - 20
			 */
			//do_action( 'woocommerce_after_single_product_summary');
			?>
		</div>
</div>
		<section class="gray-bg mt-60 home-testimonial">
		<div class="small-container">
			<h2 class="section-heading  fade-in-bottom">Testimonials</h2>
			<div class="testimonial_slider  fade-in-bottom">
				<?php
						$arg = array(
						'post_type'         => 'testimonials',
						'posts_per_page'    => 10,
						'orderby'           => 'date',
						'order'             => 'DESC'
						);
						$testimonials = new WP_Query($arg);
					?>
					<?php while($testimonials->have_posts()) : $testimonials->the_post(); ?>
				<div>
					<div class="slide-box">
						<div class="img-box"><?php the_post_thumbnail( 'new-image-name' ); ?></div>
						<div class="cnt-box">
							<div class="cnt  testimonial-cnt">
							<p><?php echo  get_the_content(); ?></p>
							</div>
							<span class="name"><?php echo get_the_title(); ?></span>
							<span class="designation"><?php echo get_field("designation"); ?></span>
						</div>
					</div>
				</div><!---div End--->
				<?php endwhile; wp_reset_query(); ?>
			</div>
		</div>
	</section>
	<div class="container">
		<div class="wp-accordion">
			<h2 class="title"><span>FAQ's</span></h2>
				<?php echo do_shortcode('[wp-faq-schema title="" accordion=1]'); ?>
		</div>
			 <?php
				$arg = array(
				'post_type'=> 'video',
				'post_status' => 'publish',
				'posts_per_page'    => 10,
				'order'=>'desc',
				'tax_query' => array(
					array(
						'taxonomy' => 'video_cat',
						'field' => 'slug',
						'terms' => "$cat_slug"
						)
					)
				);
			$postgn = new WP_Query($arg);
			if($postgn->have_posts()):?>
				<section class="related-video">
					<h2 class="section-heading  fade-in-bottom">Related Video</h2>
					<div class="mt-60 related-product-slider">
						<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
						<div>
							<?php
								// shop page display badges
								$field = get_field_object('badges');
								$colors = $field['value'];
								if( $colors ): ?>
								<?php foreach( $colors as $color ): ?>
									<div class="bagesection"><?php echo $field['choices'][ $color ]; ?></div>
								<?php break;
								endforeach;
								endif;?>
							<div class="slide-box">
								<div class="post-image">
									<?php $video = get_field('video');?>
									<?php if(!empty( $video ) ): ?>
										<a href="<?php echo get_permalink(get_the_ID()); ?>">
											<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/play-btn.png" class="play-btn" alt="play-btn">
											<img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
										</a>
									<?php endif?>
								</div>
							<div class="cnt-box">
								<h3 class="post-title"><?php the_title(); ?></h3>
								<div class="post-content"><?php echo str_limit(strip_tags($post->post_content), 95);?></div>
								<a class="read-more" href="<?php the_permalink() ?>">Watch Now</a>
							</div>
						</div>
					</div>
					<?php  endwhile;
							wp_reset_postdata();?>
					</div>
			</section>
	<?php endif;
	$postgna =new WP_Query(array(
		'type' => 'post',
		'order'=>'desc',
		'posts_per_page' => 10,
		'tax_query' => array(
		 array(
			'taxonomy' => 'category',
			'field' => 'slug',
			'terms' => $cat_slug
			)
				)
			)
		);
			 if($postgna->have_posts()):?>
			<section class="product-related-blogs mt-60">
				<h2 class="section-heading  fade-in-bottom">Related Blogs</h2>
					<div class="mt-60 management_slider">
						<?php while($postgna->have_posts()) : $postgna->the_post(); ?>
						<div>
							<div class="slide-box">
								<div class="img-box">
									<?php the_post_thumbnail('full'); ?>
								</div>
								<div class="cnt-box">
									<h3><?php the_title(); ?></h3>
									<p><?php echo str_limit(strip_tags($post->post_content), 95);?></p>
									<a class="read-more" href="<?php the_permalink() ?>">Read More</a>
								</div>
							</div>
					 </div>
						<?php endwhile;
							wp_reset_postdata();
						?>
					</div>
			</section>
		<?php endif;?>
	</div>
<script type="text/javascript">
	$('a[href^="#"]').click(function(){
var the_id = $(this).attr("href");
    $('html, body').animate({
        scrollTop:$(the_id).offset().top
    }, 'slow');
return false;});
</script>
<script>
$(document).ready(function () {
	$('#horizontalTab').easyResponsiveTabs({
		type: 'default', //Types: default, vertical, accordion
		width: 'auto', //auto or any width like 600px
		fit: true,   // 100% fit in a container
		closed: 'accordion', // Start closed if in accordion view
		activate: function(event) { // Callback function if tab is switched
		var $tab = $(this);
		var $info = $('#tabInfo');
		var $name = $('span', $info);
		$name.text($tab.text());
		$info.show();
		}
	});
	$('#horizontalTab2').easyResponsiveTabs({
		type: 'default', //Types: default, vertical, accordion
		width: 'auto', //auto or any width like 600px
		fit: true,   // 100% fit in a container
		closed: 'accordion', // Start closed if in accordion view
		activate: function(event) { // Callback function if tab is switched
		var $tab = $(this);
		var $info = $('#tabInfo');
		var $name = $('span', $info);
		$name.text($tab.text());
		$info.show();
		}
	});
});
</script>
