<?php
/**
 * Template Name: Thank you page
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.7.0
 */
//defined( 'ABSPATH' ) || exit;
?>
<div class="woocommerce-order">
<div class="thankyou-page">
<div class="checkicon">
	<img src="<?php echo bloginfo('template_url');?>/assets/images/check-circle.png" alt="" title="">
</div>
<div class="cnt">
<h2>Thank You For Your Purchase!</h2>
<div class="order-text">Your Order number is: <?php echo $order->get_order_number();?></div>
<p>We'll email you an order confirmation with details and tracking into. </p>
<div class="contact-us">
    <span>Have a question? Contact us</span>
    <a href="tel:919902508833"> <i class="icon phone-icon"></i> +91- 9902508833</a>
    <a href="mailto:info@goodnutrition.in"><i class="email-icon"></i> info@goodnutrition.in</a>
</div>
</div>
<div class="woocommerce-order">
        <?php if ( $order ) :
          echo "Payment Method   : " .strtoupper($order->get_payment_method());
          echo "<h2>Order Summary</h2>";
            ?>
                <?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>
        <?php else : ?>
                <p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'woocommerce' ), null ); ?></p>
        <?php endif; ?>
<section class="woocommerce-customer-details ">
	<section class="woocommerce-columns woocommerce-columns--2 woocommerce-columns--addresses col2-set addresses address-deatils">
		<div class="woocommerce-column woocommerce-column--1 woocommerce-column--billing-address col-1">



	<h2 class="woocommerce-column__title"><?php esc_html_e( 'Billing address', 'woocommerce' ); ?></h2>

	<address>
		<?php echo wp_kses_post( $order->get_formatted_billing_address( esc_html__( 'N/A', 'woocommerce' ) ) ); ?>


			<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_billing_phone() ); ?></p>



			<p class="woocommerce-customer-details--email"><?php echo esc_html( $order->get_billing_email() ); ?></p>


		<?php
			/**
			 * Action hook fired after an address in the order customer details.
			 *
			 * @since 8.7.0
			 * @param string $address_type Type of address (billing or shipping).
			 * @param WC_Order $order Order object.
			 */
			do_action( 'woocommerce_order_details_after_customer_address', 'billing', $order );
		?>
	</address>



		</div><!-- /.col-1 -->

		<div class="woocommerce-column woocommerce-column--2 woocommerce-column--shipping-address col-2">
			<h2 class="woocommerce-column__title"><?php esc_html_e( 'Shipping address', 'woocommerce' ); ?></h2>
			<address>
				<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'woocommerce' ) ) ); ?>


					<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>


				<?php
					/**
					 * Action hook fired after an address in the order customer details.
					 *
					 * @since 8.7.0
					 * @param string $address_type Type of address (billing or shipping).
					 * @param WC_Order $order Order object.
					 */
					do_action( 'woocommerce_order_details_after_customer_address', 'shipping', $order );
				?>
			</address>
		</div><!-- /.col-2 -->

	</section><!-- /.col2-set -->



	<?php do_action( 'woocommerce_order_details_after_customer_details', $order ); ?>

</section>

<a class="btn btn-green" href="<?php echo get_home_url() . "/shop"; ?>">Continue Shopping</a>
</div>
</div>
