<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
do_action( 'woocommerce_before_checkout_form', $checkout );
// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}
?>
<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
<div class="cart-details">
<div class="cart-left-item">
	<div class="cart-detail-top">
			<?php if ( !is_user_logged_in() ) {	 ?>
				<div class="woocommerce-billing-fields left-billing-detailswoocommerce-billing-fields left-billing-details">
					<div class="customer-login-details">
						<div class="border-box customer-login">
							<div class="user-login">
								<span> Returning Customer?
									<a href="<?php echo site_url('my-account/');?>" class="popup text-link" data-modal="landingpage-subscription-popup">Login</a>
								</span>
								<span>New To User?
									<a class="newuser-popup text-link" href="<?php echo site_url('my-account/sign-up/');?>">Create your account?</a>
								</span>
							</div>
						</div>
					</div>
				</div>
		<?php } else {?>
			<div class="woocommerce-billing-fields left-billing-detailswoocommerce-billing-fields left-billing-details" style=""></div>
		<?php } ?>
		<div class="contact-us">
			<span>Have a question? call us</span> <a href="tel:919902508833"> <i class="icon phone-icon"></i> +91- 9902508833</a>
		</div>
	</div>
	<?php if ( $checkout->get_checkout_fields() ) : ?>
		<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
<div class="col2-set" id="customer_details">
			 <div class="border-box shipping-address">
 				<div class="title">
					<h2 ><span>1</span> Billing Address</h2>
					<?php if ( !is_user_logged_in() ) {	 ?>
					<div class="guest-checkout">
					<strong>Guest Checkout?</strong> Fill the billing / shipping address and place order
					</div>
					<?php } else {?>
					<div class="guest-checkout" style="display:none;">
					<strong>Guest Checkout?</strong> Fill the billing / shipping address and place order
					</div>
					<?php } ?>
				</div>
				<div class="col2-set " id="">
					<div class="col-123 mlr">
						<?php do_action( 'woocommerce_checkout_billing' ); ?>
					</div>
				</div>
</div>
<div class="border-box billing-address">
	<div class="title">
				<h2><span>2</span> Shipping Address</h2>
			<div id="ship-to-different-address" class="custom-checkbox">
			<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
				<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" <?php checked( apply_filters( 'woocommerce_ship_to_different_address_checked', 'shipping' === get_option( 'woocommerce_ship_to_destination' ) ? 0 : 0 ), 1 ); ?> type="checkbox" name="ship_to_different_address" value="0" /> <span><?php esc_html_e( 'Shipping address is not same as billing address?', 'woocommerce' ); ?></span>
			</label>
		</div>
				</div>
				<div class="col2-set" id="customer_details">
					<div class="col-123">
						<?php do_action( 'woocommerce_checkout_shipping' ); ?>
					</div>
					<?php //do_action( 'woocommerce_checkout_after_customer_details' ); ?>
				</div>
</div>
</div>
		<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
	<?php endif; ?>
	<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
<div class="border-box">
			<div class="paymentoption">
				<div class="title">
					<h2><span>3</span> Payment Method</h2>
				</div>
				<div class="">
					<div class="mlr secure">
						<i class="icons lock"></i>
						<span>100% Secured Payment.</span>
					</div>
					<div class="amaze_pay"></div>
					<?php //do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
					<?php //do_action( 'woocommerce_checkout_before_order_review' ); ?>
					<div id="order_review" class="woocommerce-checkout-review-order">
						<?php do_action( 'woocommerce_checkout_order_review' ); ?>
					</div>
				</div>
			</div>
	</div>
</div>
	<div class="cart-totla-right">
		<h2 id="order_review_heading"><?php esc_html_e( 'Order Summary', 'woocommerce' ); ?></h2>
		<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
<div class="total-items">
	<?php global $woocommerce;
	echo $woocommerce->cart->cart_contents_count; ?> Items in your cart
</div>
<div class="item-show" style="display:block">
	<div id="cclw_order_details_table">
	<div id="order_review_table">
	<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
     	<?php remove_action( 'woocommerce_checkout_order_review','woocommerce_checkout_payment',20 ); ?>
		<?php do_action( 'woocommerce_checkout_order_review' ); ?>
	</div>
</div>
	<?php
	do_action( 'woocommerce_review_order_before_cart_contents' );
	foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
		$_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
		if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
			?>
			<div class="cart-item">
				<span class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
					<span class="product-name">
						<?php //echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) ); ?>
					</span>
					<?php $item = $cart_item['data'];
					  if(!empty($item)){
                    	//$pimg = new WC_product($item->id);
                     	echo wp_get_attachment_image( get_post_thumbnail_id($item->id), array('80', '80'), "", array( ) );
                       // echo $pimg->get_image();
                     }?>
					<!-- <img src="<?php// echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg"> -->
				</span>
				<div class="cnt">
					<?php $catTerms = get_the_terms( $item->id, 'product_cat' );
																		?>
						<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
					<h4 style="background-color:<?php echo $cat_color ?>"><?php echo $catTerms[0]->name;?></h4>
					<div class="title"><?php echo $_product->get_name();?></div>
					<?php $flavour_text = get_field('product_flavour_text', $item->id);
					if ( !empty($flavour_text) ) {?>
						<h5><?php echo $flavour_text; ?></h5>
					<?php }?>
					<div class="quantity">
						<span>
							<?php echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( 'Quantity&minus;&nbsp;%s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							<?php echo wc_get_formatted_cart_item_data( $cart_item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</span>
						<span class="product-total">
							<?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</span>
					</div>
				</div>
			</div>
			<?php
		}
	}
	do_action( 'woocommerce_review_order_after_cart_contents' );
	?>
</div>
<?php do_action( 'woocommerce_after_cart_totals' ); ?>
<div>
	<?php do_action( 'woocommerce_before_order_notes', $checkout ); ?>
	<?php if ( apply_filters( 'woocommerce_enable_order_notes_field', 'yes' === get_option( 'woocommerce_enable_order_comments', 'yes' ) ) ) : ?>
		<div class="woocommerce-additional-fields__field-wrapper">
			<?php foreach ( $checkout->get_checkout_fields( 'order' ) as $key => $field ) : ?>
				<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
	<?php do_action( 'woocommerce_after_order_notes', $checkout ); ?>
		<div class="visa-cards">We Accept <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/visa-cards.png"></div>
	<div class="mlr secure">
	<i class="icons lock-green"></i>
	<span>100% Secured Payment. <br> All Transactions processed by Razorpay</span>
</div>
</div>
	</div>
</div>
</form>
<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
