<?php
/**
 * Cart totals
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-totals.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.3.6
 */
defined( 'ABSPATH' ) || exit;
?>
	<div class="cart_totals <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">
	<?php do_action( 'woocommerce_before_cart_totals' ); ?>
	<h2><?php esc_html_e( 'Order Summary', 'woocommerce' ); ?></h2>
	<table cellspacing="0" class="shop_table shop_table_responsive">
		<tr class="cart-subtotal">
			<th><?php esc_html_e( 'Item Subtotal', 'woocommerce' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Subtotal', 'woocommerce' ); ?>"><?php wc_cart_totals_subtotal_html(); ?></td>
		</tr>
		<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>" data-title="<?php wc_cart_totals_coupon_html( $coupon ); ?>">
				<th class="messageapplied green-text">Discount Applied <?php //wc_cart_totals_coupon_label( $coupon ); ?></th>
				<td data-title="<?php echo esc_attr( wc_cart_totals_coupon_label( $coupon, false ) ); ?>"> <?php wc_cart_totals_coupon_html( $coupon ); ?></td>
			</tr>
		<?php endforeach; ?>
		<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
			<?php do_action( 'woocommerce_cart_totals_before_shipping' ); ?>
			<?php wc_cart_totals_shipping_html(); ?>
			<?php do_action( 'woocommerce_cart_totals_after_shipping' ); ?>
		<?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>
			<tr class="shipping">
				<th><?php esc_html_e( 'Shipping', 'woocommerce' ); ?></th>
				<td data-title="<?php esc_attr_e( 'Shipping', 'woocommerce' ); ?>"><?php woocommerce_shipping_calculator(); ?></td>
			</tr>
		<?php endif; ?>
		<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
			<tr class="fee">
				<th><?php echo $fee->name ; ?></th>
			<td data-title="" class="cod-box"><span class="cod-title"><?php echo $fee->name ; ?></span>   <?php wc_cart_totals_fee_html( $fee ); ?></td>
			</tr>
		<?php endforeach; ?>
		<?php
		if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) {
			$taxable_address = WC()->customer->get_taxable_address();
			$estimated_text  = '';
			if ( WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping() ) {
				/* translators: %s location. */
				$estimated_text = sprintf( ' <small>' . esc_html__( '(estimated for %s)', 'woocommerce' ) . '</small>', WC()->countries->estimated_for_prefix( $taxable_address[0] ) . WC()->countries->countries[ $taxable_address[0] ] );
			}
			if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) {
				foreach ( WC()->cart->get_tax_totals() as $code => $tax ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
					?>
					<tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
						<th><?php echo esc_html( $tax->label ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></th>
						<td data-title="<?php echo esc_attr( $tax->label ); ?>"><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
					</tr>
					<?php
				}
			} else {
				?>
				<tr class="tax-total">
					<th><?php echo esc_html( WC()->countries->tax_or_vat() ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></th>
					<td data-title="<?php echo esc_attr( WC()->countries->tax_or_vat() ); ?>"><?php wc_cart_totals_taxes_total_html(); ?></td>
				</tr>
				<?php
			}
		}
		?>
		<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>
		<tr class="order-total">
			<th><?php esc_html_e( 'Order Total', 'woocommerce' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Total', 'woocommerce' ); ?>"><?php wc_cart_totals_order_total_html(); ?></td>
		</tr>
		<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>
	</table>
<!--	<div class="apply-cpoups"><?php //if ( wc_coupons_enabled() ) { ?>
		<div class="coupon">
			<label for="coupon_code"><?php //esc_html_e( 'Apply Gift Card/Coupon Code:', 'woocommerce' ); ?></label>
			<div class="coupon-field">
			<input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php //esc_attr_e( 'Enter coupon code', 'woocommerce' ); ?>" />
			<button type="submit" class="button" name="apply_coupon" value="<?php //esc_attr_e( 'Apply', 'woocommerce' ); ?>"><?php //esc_attr_e( 'Apply', 'woocommerce' ); ?></button>
		</div>
			<?php //do_action( 'woocommerce_cart_coupon' ); ?>
		</div>
			<?php// } ?>
	</div> -->
	<div class="apply-cpoups">
		<div class="coupon">
			<?php $cash_on_delivery = get_field('cash_on_delivery','option');
				$coupon_code_text = get_field('coupon_code_text','option');
				if(!empty($cash_on_delivery)){?>	<label for="coupon_code"><?php esc_html_e( 'Available Promotions', 'woocommerce' ); ?></label> <p class="cod"> <?php echo $cash_on_delivery; ?> </p> <?php }
				if(!empty($coupon_code_text)){?> <p class="cct"> <span class="applycoupon"><?php echo $coupon_code_text ;?></span></p> <?php }
				?>
			<div class="coupon-field">
				<form class="form-coupons" method="post">
				<p class="form-row form-row-first cartpage">
					<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Enter Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
				</p>
				<p class="form-row form-row-last cartpageapyl">
					<button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply', 'woocommerce' ); ?></button>
				</p>
			<div class="clear"></div>
			</form>
		</div>
		<div class="msg_coupon green-text"><?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<?php wc_cart_totals_coupon_label( $coupon ); ?> successfully applied
		<?php endforeach; ?></div>
	</div>
</div>
<?php do_action( 'woocommerce_after_cart_totals' ); ?>
<div class="wc-proceed-to-checkout">
	<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
	<div class="visa-cards">We Accept <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/visa-cards.png"></div>
</div>
<div class="mlr secure">
	<i class="icons lock-green"></i>
	<span>100% Secured Payment. <br> All Transactions processed by Razorpay</span>
</div>
</div>
</div>
