<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */
defined( 'ABSPATH' ) || exit;
get_header();
$category = get_queried_object( $taxonomy );
$cat_color=get_field('title_content_color',$category );
?>
<section class="banner-section">
	<div class="">
		<?php if(is_product_category()) : ?>
               <?php
                    $image = get_field('category_banner', $category);
                 ?>
               <?PHP if(!empty( $image ) ): ?>
                	<img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" width="100%" />
                <?php// echo wp_get_attachment_image( $image['id'], 'full'); ?>
                <?PHP else: ?>
             <img src="<?php bloginfo('template_directory'); ?>/assets/images/healthy-eating.jpg" alt="<?php echo esc_attr($image['alt']); ?>" width="100%"  />
                <?php endif; ?>
                <?php the_archive_title( '<h1 class="page-title">', '</h1>' ); ?>
    <?php endif; ?>
       </div>
</section>
<?php
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );
?>
<header class="woocommerce-products-header">
	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
	<?php endif; ?>
	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	//do_action( 'woocommerce_archive_description' );
	?>
</header>
<div class="all-product-list">
	<div class="filter-btn"><i class="icons filter"></i>Filter</div>
<?php
if ( woocommerce_product_loop() ) {
	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	do_action( 'woocommerce_before_shop_loop' );
	woocommerce_product_loop_start();
	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();
			/**
			 * Hook: woocommerce_shop_loop.
			 */
			do_action( 'woocommerce_shop_loop' );
			wc_get_template_part( 'content', 'product' );
		}
	}
?>
<script type="text/javascript">
	 jQuery(function($) {
	 $( document ).ajaxComplete(function() {
		$('.orderby, .select2').select2({
		    minimumResultsForSearch: -1,
		    dropdownPosition: 'below'
		});
		$('.filter-close, .bapf_button bapf_reset, .product-filter li').click(function(){
			$('.product-filter').removeClass('filter-slide');
			$('body').removeClass('overlap');
		});
	});
});
</script>
<?php
	woocommerce_product_loop_end();
	?>
	<?php
	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {





	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );
/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action( 'woocommerce_sidebar' );?>
</div>
<!-- Start Advertising Banner Display Code -->
<section class="banner-section">
	<div class="container">
		<?php if(is_product_category() ) {
                $advertisingBanner = get_field('advertising_banner', $category);
				$advertisingBannerUrl =  get_field('advertising_banner_url', $category);
                if(!empty( $advertisingBanner ) ): ?>
                	<a href="<?php echo $advertisingBannerUrl; ?>" target="_blank"><img src="<?php echo esc_url($advertisingBanner['url']); ?>" alt="<?php echo esc_attr($advertisingBanner['alt']); ?>" width="100%" /></a>
                <?php endif;
				} else {
					$post_id = get_option( 'woocommerce_shop_page_id' );
					$advertisingBanner = get_field('advertising_banner',$post_id);
					$advertisingBannerUrl =  get_field('advertising_banner_url',$post_id); ?>
					<a href="<?php echo $advertisingBannerUrl; ?>" target="_blank"><img src="<?php echo esc_url($advertisingBanner['url']); ?>" alt="<?php echo esc_attr($advertisingBanner['alt']); ?>" width="100%" /></a>
        <?php } ?>
    </div>
</section>
<!-- End Advertising Banner Display Code -->
<?php if(!is_shop()){
	$product_cat_object = get_queried_object();
	?>
<section class="supplements-detali">
	<div class="container">
         <?php $att= get_the_archive_title(); ?>
		<?php $str_arr = preg_split ("/\:/",$att);?>
    <?php
    if(in_array($product_cat_object->taxonomy,array('pa_shop-by-gender','pa_shop-by-goals'))){
    	echo '<h2 class="section-heading js-scroll fade-in-bottom">';
    }else{
    	echo '<h2 class="section-heading cat-heading js-scroll fade-in-bottom">';
    }?>
		<?php print "$str_arr[1]" ;?>
		<?php if(is_product_category()):?>
		<?php the_archive_title();
        if(in_array($product_cat_object->taxonomy,array('pa_shop-by-gender','pa_shop-by-goals'))){}else{
        	echo '<span style="background-color:'.$cat_color.'"></span>';
        }
		?>
		<?php endif; ?></h2>
		<?php do_action( 'woocommerce_archive_description' );?>
			<?php
			$counter=0;
			$detail_array = array();
			get_field('category_read_more_description', 'product_cat_' . $product_cat_object->term_id);
         if(in_array($product_cat_object->taxonomy,array('pa_shop-by-gender','pa_shop-by-goals'))){}else{
         ?>
			<ul class="js-scroll fade-in-bottom scrolled ">
			<?php while( has_sub_field('category_read_more_description', 'product_cat_' . $product_cat_object->term_id) ):
			$counter++;
			$detail_array[]= get_sub_field('detail');
			?>
			<li style="background-color:<?php echo get_sub_field('background-color'); ?>">
				<div class="box">
					<h4 style="color:<?php echo $cat_color; ?>"><?php echo get_sub_field('title');?></h4>
					<p><?php echo wp_trim_words(get_sub_field('description'),60);?></p>
					<div class="more-btn">
						<a class="read-more popup" data-modal="more_cont<?php echo $counter;?>" href="javascript:void(0)"?>Read More</a>
					</div>
				</div>
			</li>
			<?php
			endwhile;
		}?>
		</ul>
	</div>
</section>
<?php
$counter=0;
 foreach( $detail_array as $detail ):
 $counter++;
  ?>
	<div id="more_cont<?php echo $counter;?>" class="modal">
		<div class="modal-content">
			<span class="close">X</span>
			<div class="modal-body">
				<div class="modal-height"><?php echo $detail;?> </div>
			</div>
		</div>
	</div>
<?php endforeach;?>
<?php
if(in_array($product_cat_object->taxonomy,array('pa_shop-by-gender','pa_shop-by-goals'))){
$key = str_replace('pa','',$product_cat_object->taxonomy);
$arg = array(
	'posts_per_page'	=> 3,
	'post_type'		=> 'video',
	'post_status' => 'publish',
	'meta_key'		=> 'video_attribute'.$key.'',
	'meta_value'	=> $product_cat_object->name
);
}else{
	$arg = array(
	'post_type'=> 'video',
	'post_status' => 'publish',
	'posts_per_page'    => 3,
	'order'=>'desc',
		'tax_query' => array(
          array(
                'taxonomy' => 'video_cat',
                'field' => 'slug',
                'terms' => $category->slug
            )
           )
		);
}
$postgn = new WP_Query($arg);
if($postgn->have_posts()):?>
<section>
	<div class="container">
		<h2 class="section-heading js-scroll fade-in-bottom">Related videos</h2>
		<ul class="video-list js-scroll fade-in-bottom">
			<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
			<li>
				<div class="video-box">
					<?php $video = get_field('video');?>
					            <?php if(!empty( $video ) ): ?>
					        <a href="<?php echo get_permalink(get_the_ID()); ?>">
									<img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg">
								 </a>
			<?php endif?>
				</div>
				<h4><a style="color:<?php echo $cat_color;?>" href="<?php echo get_permalink(get_the_ID()); ?>"><?php the_title(); ?></a></h4>
				<p><?php $content = get_the_content();
				 echo wp_trim_words($content, 0, 75, '...');?></p>
				<div class="d-inline"><a href="<?php the_permalink() ?>" class="read-more">Watch Now</a></div>
			</li>
			<?php
				endwhile;
				wp_reset_postdata();
		?>
		</ul>
	</div>
</section>
<?php endif; ?>
<?php
if(in_array($product_cat_object->taxonomy,array('pa_shop-by-gender','pa_shop-by-goals'))){
$key = str_replace('pa','',$product_cat_object->taxonomy);
$postgn = new WP_Query(array(
	'posts_per_page'	=> 3,
	'post_type'		=> 'post',
	'post_status' => 'publish',
	'meta_key'		=> 'post_attribute'.$key.'',
	'meta_value'	=> $product_cat_object->name
));
}else{
	$postgn =new WP_Query(array(
	'type' => 'post',
	'order'=>'desc',
	'posts_per_page' => 3,
	'tax_query' => array(
			  array(
					'taxonomy' => 'category',
					'field' => 'slug',
					'terms' => $category->slug
				)
			)
		)
	);
}
	 if($postgn->have_posts()): ?>
<section>
	<div class="container">
		<h2 class="section-heading js-scroll fade-in-bottom">Related blog</h2>
		<ul class="video-list js-scroll fade-in-bottom">
			<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
			<li>
				<div class="video-box">
					<a href="<?php echo get_permalink(get_the_ID()); ?>"><?php the_post_thumbnail('full'); ?></a>
				</div>
				<h4><a style="color:<?php echo $cat_color;?>" href="<?php echo get_permalink(get_the_ID()); ?>"><?php the_title(); ?></a></h4>
				<p><?php $content = get_the_content(); echo wp_trim_words($content, 0, 75, '...');?></p>
				<div class="d-inline"><a class="read-more" href="<?php the_permalink() ?>">Read More</a></div>
			</li>
			<?php
				endwhile;
				wp_reset_postdata();
		?>
		</ul>
	</div>
</section>
<?php endif; ?>
<?php } ?>
<?php $product_cat_object = get_queried_object();
$att_faq=get_field('faqs_template', 'product_cat_' . $product_cat_object->term_id); ?>
<?php if( !empty($att_faq) ) :?>
<section class="faq-section">
	<div class="container">
		<h2 class="title"><span>FAQ's</span></h2>
		<div id="accordion" class="accordion-container js-scroll fade-in-bottom">
			<?php while( has_sub_field('faqs_template', 'product_cat_' . $product_cat_object->term_id) ): ?>
			<article class="content-entry">
				<h4 class="article-title"><?php echo get_sub_field('title');?></h4>
				<div class="accordion-content">
					<p><?php echo get_sub_field('contents');?></p>
				</div>
			</article>
			 <?php
			endwhile;?>
		</div>
	</div>
</section>
 <?php endif; ?>
<?php if(is_shop()){?>
 <section class="faq-section">
	<div class="container">
		<h2 class="title"><span>FAQ's</span></h2>
		<div id="accordion" class="accordion-container js-scroll fade-in-bottom">
			 <?php if( have_rows('faqs', 'option') ):
				while ( have_rows('faqs', 'option') ) : the_row();?>
			<article class="content-entry">
				<h4 class="article-title"><?php echo get_sub_field('title');?></h4>
				<div class="accordion-content">
					<p><?php echo get_sub_field('contents');?></p>
				</div>
			</article>
			 <?php
			endwhile;
			endif;
		   ?>
		</div>
	</div>
</section>
<?php } ?>
<?php
get_footer( 'shop' );
