<?php
/**
 * Template Name: Testimonial Page
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Medical_Way
 */
get_header();
?>
<!-- Open Upcoming Events -->
<section class="testimonial-page pb">
    <div class="container">
      <?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $args = array(
    'post_type' => 'testimonials',
    'posts_per_page' => '2',
     'order' => 'ASC',
    'paged' => $paged
    );
    $count_posts = wp_count_posts( 'testimonials' )->publish;
    $testi = new WP_Query( $args );?>
    <?php $total_pages = $testi->max_num_pages;  ?>
        <ul>
        <?php while($testi->have_posts()) : $testi->the_post(); ?>
        <li>
            <div class="lft">
                <div class="img-box">
                    <?php the_post_thumbnail( 'new-image-name' ); ?>
                </div>
            </div>
            <div class="rgt">
                <div class="depreciation"><?php echo the_content(); ?></div>
                <div class="name"><b>- <?php the_title() ?></b></div>
            </div>
        </li>
        <?php endwhile; wp_reset_query(); ?>
        </ul>
<nav class="navigation pagination" role="navigation" aria-label="Posts">
        <h2 class="screen-reader-text">Posts navigation</h2>
        <div class="nav-links">
            <?php $total_pages = $testi->max_num_pages;?>
     <?php if ($total_pages > 1){?>
        <?php $current_page = max(1, get_query_var('paged'));
          echo paginate_links(array(
         'base' => get_pagenum_link(1) . '%_%',
          'format' => '/page/%#%',
          'current' => $current_page,
          'total' => $total_pages,
          'prev_text'    => __(' Prev'),
        'next_text'    => __('Next '),
          ));?>
           <?php }   ?>
        </div>
    </nav>
      <!-- echo '<pre>' -->
     <?php // print_r($testi)?>
    </div>
</section>
<!--End  Upcoming Events -->
<?php
get_footer();
