<?php
/* Template Name: CMS Template */
get_header();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<div class="container inner-page mt-60">
			<h1 class="mb-60"><?php echo get_the_title(); ?></h1>
			<?php echo get_the_content(); ?>
				<?php if (have_posts()) : while (have_posts()) : the_post();
						// are there any rows within within our flexible content?
						if( have_rows('cms_section') ):
							// loop through all the rows of flexible content
							while ( have_rows('cms_section') ) : the_row();
								// Content
								if( get_row_layout() == 'content' ) {
									get_template_part('module/content', 'content');
								}
								// Image with content
								if( get_row_layout() == 'image_with_content' ) {
									get_template_part('module/content', 'image-with-content');
								}
								// One Column Content
								if( get_row_layout() == 'one_column_content' ) {
									get_template_part('module/content', 'one-column');
								}
								// Gallery
								if( get_row_layout() == 'gallery' ) {
									get_template_part('module/content', 'gallery');
								}
								// Image
								if( get_row_layout() == 'image_upload' ) {
									get_template_part('module/content', 'image');
								}
								// manufacturing partner
								if( get_row_layout() == 'manufacturing_partner' ) {
									get_template_part('module/content', 'manufacturing-partner');
								}
							endwhile; // close the loop of flexible content
						endif; // close flexible content conditional
					endwhile; endif; // close the WordPress loop
					 ?>
    </div>
</div>
</article>
<?php get_footer();?>
