<?php
/* Template Name: Inner page Template */
get_header();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<div class="container inner-page mt-60">
			<h1 class="mb-60"><?php echo get_the_title(); ?></h1>
			<div class="two-column-box">
				<div class="cnt-box">
					<h2>Good Nutrition</h2>
					<p>Human nutrition is probably one of the oldest fields of study; while it is
					simple in its outlook (comprising of just macro nutrients, micro nutrients,
					phytochemicals and water), the multiple combination of these building
					blocks is what makes it complex and extremely interesting. </p>
					<p>At Good Nutrition, we understand that balanced nutrition is
					foundational for living life to the full. This is why we develop
					science-based products that nourish your body.</p>
					<p>The Good Nutrition team is a group of professionals with extensive
					experience in the domains of food, health and nutritional supplements,
					came together to understand these complexities and try to simplify it
					for our customer. Our products are nutrient-dense, and are simple to
					prepare and easy to consume. We take care of the science behind the
					product and offer you choices that help you cover your nutritional
					journey in a safe, sustainable and healthy way.</p>
				</div>
				<div class="img-box">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
				</div>
			</div>
			<div class="two-column-box">
				<div class="img-box">
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
				</div>
				<div class="cnt-box">
					<h2>Conceptualization, Innovation and R&D</h2>
					<p>At the product conceptualisation stage itself, a key question the Good Nutrition team asks itself is – what combination of ingredients is necessary to deliver the best efficacy for the role the product will play in the nutritional cycle?</p>
					<p>Identification of unmet needs of a customer thus becomes the first step in the product creation process. The product is created with extensive research from the market and due diligence by the team on gathered data being representative of the target population. </p>
					<p>The next step is to design a combination of ingredients that can provide shape to the concept. Utmost care is taken to ensure that the ingredients are compatible and have synergy in the formulation. At Good Nutrition, we know that it is not just the potency of a single ingredient but a combined effect that gives maximum benefits to the consumer; you. </p>
					<p>Once we finalize the ingredients, the next step is to close in on the best delivery format that is not only efficacious but convenient for our customer to consume.</p>
				</div>
			</div>
			<div class="steps-img">
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/steps.png" alt="">
			</div>
			<div class="full-width-cnt">
				<p>We deploy a vendor qualification process to ensure this screening starts right at the source and what we get is nothing but the best quality ingredients. We verify these ingredients by putting them through the same physical, chemical and microbiological tests that were used to qualify them in the first place.</p>
				<p>We have partnered with one of the best manufacturers of nutrition supplements in India. Our manufacturing unit is located in the serene Himalayan foothills. The R&D lab is equipped with state-of-the-art analytical instruments such as HPLC, UV-visible Spectrophotometer, Flame Photometer, LAF, Dissolution Apparatus and pH Meter, an organoleptic evaluation lab etc. </p>
			</div>
			<div class="two-column-box">
				<div class="img-box">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
				</div>
				<div class="cnt-box">
					<h2>Conceptualization, Innovation and R&D</h2>
					<p>At the product conceptualisation stage itself, a key question the Good Nutrition team asks itself is – what combination of ingredients is necessary to deliver the best efficacy for the role the product will play in the nutritional cycle?</p>
					<p>Identification of unmet needs of a customer thus becomes the first step in the product creation process. The product is created with extensive research from the market and due diligence by the team on gathered data being representative of the target population. </p>
					<p>The next step is to design a combination of ingredients that can provide shape to the concept. Utmost care is taken to ensure that the ingredients are compatible and have synergy in the formulation. At Good Nutrition, we know that it is not just the potency of a single ingredient but a combined effect that gives maximum benefits to the consumer; you. </p>
					<p>Once we finalize the ingredients, the next step is to close in on the best delivery format that is not only efficacious but convenient for our customer to consume.</p>
				</div>
			</div>
			<div class="full-width-cnt">
				<h2>Procurement</h2>
				<p>Good Nutrition ensures we source only the best ingredients from reputed global and local sources. We hold our suppliers accountable for traceability of the ingredients and the state of art laboratories equipment with the latest equipment including
					<strong>atomic spectrophotometer, GLC, HPLC, etc</strong></p>
				<p>Each ingredient undergoes a series of physical, chemical, organoleptic and microbiological tests to ascertain its authenticity, safety, efficacy and potency. Only when the ingredient passes in all of our <strong>stringent qualification testing;</strong> it is approved to be used for formulation. </p>
				<p>Great quality ingredients lead to great nutritional value of our products. The Good Nutrition team puts our formulations through a nutrition profiling process which generates the nutritional information. After in-house checks, the samples are sent out to external laboratories to double-check and validate our testing. We reject any ingredient completely if it does not contribute to the final formulation</p>
				<p><strong>Stability testing</strong> is done for the final ready product, to ensure that our products provide you all the nutrition for their entire shelf-life</p>
			</div>
			<div class="carousel-box">
				<div class="carousel-slide">
					<div>
					   <div class="slide-box">
					   	<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
					   	<h3>Lorem ipsum dolor sit amet, consectetuer</h3>
					   </div>
					</div>
					<div>
					   <div class="slide-box">
					   	<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
					   	<h3>Lorem ipsum dolor sit amet, consectetuer</h3>
					   </div>
					</div>
					<div>
					   <div class="slide-box">
					   	<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
					   	<h3>Lorem ipsum dolor sit amet, consectetuer</h3>
					   </div>
					</div>
					<div>
					   <div class="slide-box">
					   	<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/pic2.jpg">
					   	<h3>Lorem ipsum dolor sit amet, consectetuer</h3>
					   </div>
					</div>
				</div>
			</div>
			<div class="full-width-cnt">
				<h2>Quality Assurance and Contro</h2>
				<p>Product quality and safety are two factors of paramount importance at Good Nutrition. We strictly adhere to our Quality Management System (QMS) which starts with defining a quality policy and covers customer satisfaction aspects of our production operations complimented through a continuous improvement program. </p>
				<p>Quality control is exercised through various tests which are conducted on incoming raw and packaging materials, in-process checks while in production and packaging and finished goods. These tests cover entire spectrum of physical, chemical, organoleptic and microbiological analysis, to ensure you get your product absolutely safe and efficacious.</p>
				<p>Quality Assurance comprises of checks and balances deployed in the manufacturing facility which ensures that the infrastructure, equipment and processing conditions are meeting our strict guidelines at all times. Quality Assurance also ensures that personnel handling your product are well equipped to handle the processes and control them within Good Nutrition control limits.</p>
				<p>All Quality systems at our manufacturing partner are based on ISO-22000:2005 and cGMP standards. Our state-of-the-art labs are equipped with AAS, GC, HPLC, UV-visible spectrophotometer, flame photometer, LAFs, BOD incubators, autoclaves, Buchi apparatus and other lab equipment.</p>
			</div>
		</div>
	</div><!-- .entry-content -->
	<footer class="entry-footer">
	<?php zigcy_lite_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php get_footer(); ?>
