<?php
/* Template Name: Bmr calculator */
get_header();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				zigcy_lite_posted_on();
				zigcy_lite_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->
	<?php zigcy_lite_post_thumbnail(); ?>
	<div class="entry-content content-area">
		<div class="container">
			<h1 class="section-heading capitalize"><?php echo get_the_title(); ?></h1>
			<div class="bmr-calculator">
				<?php
				the_content( sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'zigcy-lite' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				) );
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'zigcy-lite' ),
					'after'  => '</div>',
				) );
				?>
			</div>
			<div class="what-bmr">
				<div class="flex-row">
					<h2><?php echo get_field('bmr_heading'); ?></h2>
					<p><?php echo get_field('bmr_description'); ?></p>
				</div>
				<?php echo get_field('content_bmr'); ?>
			</div>
		</div>
	</div><!-- .entry-content -->
	<div class="product_single-slide product-list">
				<?php
					$args = array(
						'post_type' => 'product',
						'meta_key' => 'total_sales',
						'orderby' => 'meta_value_num',
						'posts_per_page' => 2,
						'product_cat' => 'weight-management'
				);
					    $loop = new WP_Query( $args );
					    while ( $loop->have_posts() ) : $loop->the_post();
					        global $product;
					    ?>
					        <div <?php wc_product_class( '', $product ); ?>>
							<div  class="slide-box ">
								<?php $imgp = woocommerce_get_product_thumbnail(); ?>
								<div class="product-img">
									<a href="<?php the_permalink(); ?>"><?php echo $imgp; ?></a>
									<!-- <img src="<?php echo bloginfo('template_url');?>/assets/images/product-pic1.png" alt="product image"> -->
									<?php show_sale_percentage_loop();
									?>
								</div>
								<div class="product-details">
									<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									<?php $flavour_text = get_field('product_flavour_text');
										if ( !empty($flavour_text) ) {?>
											<div class="product-flavour"><?php echo $flavour_text; ?></div>
										<?php }?>
									<p><?php the_excerpt(); ?></p>
                                  <!--<?php if( have_rows('product_ican') ):?>
									<div class="nutrition">
										<ul>
											<?php
											while ( have_rows('product_ican') ) : the_row();?>
												<?php $num_img = get_sub_field('product_ican');
												if ( !empty(($num_img)) ) {
												?>
											<li><?php echo wp_get_attachment_image( $num_img['id'], 'full'); ?></li>
											<?php }?>
											<?php endwhile;?>
										</ul>
									</div>
									<?php endif;?> -->
									<div class="category">
										<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
											$cat_slug = $catTerms[0]->slug;
											?>
											<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
										<!-- <span>Category</span> -->
										<span class="category-name"style="background-color:<?php echo $cat_color ?>">
											<?php echo $catTerms[0]->name;?></span>
									</div>
									<div class="price-review">
										<div class="pro-price">
											<div class="product-price">
												<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';
												show_sale_percentage_loop();
												?>
											</div>
											<div class="taxes">(inclusive of all taxes)</div>
										</div>
										<?php
												$rating_count = $product->get_rating_count();
												$review_count = $product->get_review_count();
												$average      = $product->get_average_rating();
												if ( $rating_count >= 0 ) : ?>
													<div class="review">
														<a href="#scroll-reviews" tabindex="0"><div class="rating-count"><?php echo round($average, 1); ?></div>
														<div class="rating-star">
															<span class="star_rating"><span style="width: <?php echo ($average * 20);?>%"></span></span>
														</div>
													</a>
														<!-- <span id="review-part" class="total-reviews" >reviews</span></a> -->
													</div>
												<?php endif;
												?>
									</div>
									<?php 	if( $product->is_type('variable')){?>
									<div class="btn-group">
										<div class="sml-add-to-cart-wrap">
											<a href="?add-to-cart=<?php echo esc_attr( $product->id ); ?>" data-quantity="1" class="button product_type_simple add_to_cart_button ajax_add_to_cart btn cart-btn" data-product_id="<?php echo esc_attr( $product->id ); ?>" data-product_sku="" aria-label="Add “<?php echo esc_attr( $product->name ); ?> to your cart" rel="nofollow">
											Add to cart</a>
										</div>
										<!-- <form class="cart single-product" method="post" enctype='multipart/form-data' action="<?php echo esc_url(home_url( '/' ));?>checkout">
											<button type="submit"  class="single_add_to_cart_button alt btn btn-green">Buy Now</button>
											<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />
										</form> -->
									</div>
									<?php }else {
										echo "<p class='stock out-of-stock'>Out of Stock</p>";
									}?>
								</div>
							</div>
						</div>
					  <?php  endwhile;
					    wp_reset_query();
					?>
	</div>
	<footer class="entry-footer">
		<?php zigcy_lite_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php get_footer(); ?>