<?php
/* Template Name: Bmi calculator */
 get_header();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				zigcy_lite_posted_on();
				zigcy_lite_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->
	<?php zigcy_lite_post_thumbnail(); ?>
	<div class="entry-content content-area">
		<div class="container">
			<h1 class="section-heading capitalize"><?php echo get_the_title(); ?></h1>
			<div class="bmi-calculator">
				<?php
				the_content( sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'zigcy-lite' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				) );
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'zigcy-lite' ),
					'after'  => '</div>',
				) );
				?>
			</div>
			<div class="product_slider only-two">
                    		<?php
					$args = array(
						'post_type' => 'product',
						'meta_key' => 'total_sales',
						'orderby' => 'meta_value_num',
						'posts_per_page' => 2,
						'product_cat' => 'weight-management'
				);
						    $loop = new WP_Query( $args );
						    while ( $loop->have_posts() ) : $loop->the_post();
						        global $product;
						    ?>
						        <div <?php wc_product_class( '', $product ); ?>>
								<div class="slide-box ">
									<?php $imgp = woocommerce_get_product_thumbnail(); ?>
									<div class="product-img">
										<a href="<?php the_permalink(); ?>"><?php echo $imgp; ?></a>
										<!-- <img src="<?php echo bloginfo('template_url');?>/assets/images/product-pic1.png" alt="product image"> -->
									</div>
									<div class="product-details">
										<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
										<?php $flavour_text = get_field('product_flavour_text');
											if ( !empty($flavour_text) ) {?>
												<div class="product-flavour"><?php echo $flavour_text; ?></div>
											<?php }?>
										<p><?php the_excerpt(); ?></p>
										<div class="category">
											<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
												$cat_slug = $catTerms[0]->slug;
												?>
												<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
											<!-- <span>Category</span> -->
											<span class="category-name"style="background-color:<?php echo $cat_color ?>">
												<?php echo $catTerms[0]->name;?></span>
										</div>
										<div class="price-review">
											<div class="pro-price">
												<div class="product-price">
													<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';
												show_sale_percentage_loop();
												?>
												</div>
												<div class="taxes">(inclusive of all taxes)</div>
											</div>
										</div>
										<?php 	if( $product->is_type('variable')){?>
										<div class="btn-group">
											<div class="sml-add-to-cart-wrap">
												<a href="?add-to-cart=<?php echo esc_attr( $product->id ); ?>" data-quantity="1" class="button product_type_simple add_to_cart_button ajax_add_to_cart btn cart-btn" data-product_id="<?php echo esc_attr( $product->id ); ?>" data-product_sku="" aria-label="Add “<?php echo esc_attr( $product->name ); ?> to your cart" rel="nofollow">
												Add to cart</a>
											</div>
											<form class="cart single-product" method="post" enctype='multipart/form-data' action="<?php echo esc_url(home_url( '/' ));?>checkout">
												<button type="submit"  class="single_add_to_cart_button alt btn btn-green">Buy Now</button>
												<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />
											</form>
										</div>
										<?php }else {
											echo "<p class='stock out-of-stock'>Out of Stock</p>";
										}?>
									</div>
									</div>
							</div>
						  <?php  endwhile;
						    wp_reset_query();
						?>
			</div><!-- .product_slider End--->
			<div class="bmi-tips">
				<?php
				$image = get_field('bmi_image');
                $content = get_field('bmi_content');
				 ?>
				<img src="<?php echo $image['url']; ?>">
				<?php echo $content; ?>
			</div>
		</div>
	</div><!-- .entry-content -->
	<footer class="entry-footer">
		<?php zigcy_lite_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
<script>
jQuery(document).ready(function ($J) {
$J(".clear_btn").click(function (e) {
	e.preventDefault();
	clearForm(get_id(this.id, "clear_btn"));
});
$J(".calculate_btn").click(function (e) {
	e.preventDefault();
});
$J('.units').change(function () {
	widget_id = get_id(this.name, 'units');
	if ($J('#' + widget_id + '-radioMetric').prop('checked')) {
		$J("#" + widget_id + "-imperial").hide();
		$J("#" + widget_id + "-metric").show();
	} else {
		$J("#" + widget_id + "-metric").hide();
		$J("#" + widget_id + "-imperial").show();
	}
	clearForm(widget_id);
});
// METRIC ONLY
$J(".weight").keydown(function (e) {
	if (!(isDecimalKey(e, this.value))) e.preventDefault();
});
$J(".weight").keyup(function () {
	calculateMetricBMI(get_id(this.id, "weight"));
});
$J(".height").keydown(function (e) {
	if (!(isDecimalKey(e, this.value))) e.preventDefault();
});
$J(".height").keyup(function () {
	calculateMetricBMI(get_id(this.id, "height"));
});
// <-- METRIC ONLY
// IMPERIAL ONLY
$J(".weight-lbs").keydown(function (e) {
	if (!(isDecimalKey(e, this.value))) e.preventDefault();
});
$J(".weight-lbs").keyup(function () {
	calculateImperialBMI(get_id(this.id, "weight-lbs"));
});
$J(".height-in").keydown(function (e) {
	if (!(isIntegerKey(e, this.value))) e.preventDefault();
});
$J(".height-in").keyup(function () {
	calculateImperialBMI(get_id(this.id, "height-in"));
});
$J(".height-ft").keydown(function (e) {
	if (!(isIntegerKey(e, this.value))) e.preventDefault();
});
$J(".height-ft").keyup(function () {
	calculateImperialBMI(get_id(this.id, "height-ft"));
});
// <-- IMPERIAL ONLY
function clearForm(widget_id) {
	$J('#' + widget_id + '-height-ft').val("");
	$J('#' + widget_id + '-height-in').val("");
	$J('#' + widget_id + '-weight-lbs').val("");
	$J('#' + widget_id + '-height').val("");
	$J('#' + widget_id + '-weight').val("");
	$J('#' + widget_id + '-BMI-Description').html("");
	$J('#' + widget_id + '-BMI-Description').hide();
}
function calculateMetricBMI(widget_id) {
	var weight_kg = parseFloat($J('#' + widget_id + '-weight').val()),
		height_m = parseFloat($J('#' + widget_id + '-height').val()) / 100,
		bmi,
		bmi_category;
	// if no data entered
	if (isNaN(weight_kg) || weight_kg == "" || isNaN(height_m) || height_m == "") {
		$J('#' + widget_id + '-BMI-Description').hide();
		return;
	}
	bmi = weight_kg / Math.pow(height_m, 2);
	bmi_category = new ccBMI.GetCategory(bmi);
	$J('#' + widget_id + '-BMI-value').html(round2TwoDecimals(bmi));
	$J('#' + widget_id + '-BMI-Description').html("<p>Your BMI is " + round2TwoDecimals(bmi) + "</p><p> (" + bmi_category.category + ")</p>");
	$J('#' + widget_id + '-BMI-Description').toggleClass('alert-success alert-info alert-warning alert-danger', false);
	$J('#' + widget_id + '-BMI-Description').toggleClass(bmi_category.style, true);
	$J('#' + widget_id + '-BMI-Description').show();
}
function calculateImperialBMI(widget_id){
	var weight_lbs = parseFloat($J('#' + widget_id + '-weight-lbs').val()),
		height_ft = parseFloat($J('#' + widget_id + '-height-ft').val()),
		height_in = parseFloat($J('#' + widget_id + '-height-in').val()),
		bmi,
		bmi_category;
	// if no data entered
	if (isNaN(weight_lbs) || weight_lbs == "" || isNaN(height_ft) || height_ft == "" || isNaN(height_in) || height_in == "") {
		$J('#' + widget_id + '-BMI-Description').hide();
		return;
	}
	height_in = height_in + height_ft * 12;
	bmi = (weight_lbs / Math.pow(height_in, 2)) * 703;
	bmi_category = new ccBMI.GetCategory(bmi);
	$J('#' + widget_id + '-BMI-value').html(round2TwoDecimals(bmi));
	$J('#' + widget_id + '-BMI-Description').html("<p>Your BMI is  " + round2TwoDecimals(bmi) + "</p><p> (" + bmi_category.category + ")</p>");
	$J('#' + widget_id + '-BMI-Description').toggleClass('alert-success alert-info alert-warning alert-danger', false);
	$J('#' + widget_id + '-BMI-Description').toggleClass(bmi_category.style, true);
	$J('#' + widget_id + '-BMI-Description').show();
//$J('#' + widget_id + '-BMI-Description').after('<div class="">test</div>');
}
});
	</script>
<?php get_footer(); ?>