<?php
/* Template Name: Video listing page */
get_header();
$term_data = $wp_query->get_queried_object();
$cur_term_id = $term_data->term_id ;
$metaterms = get_term_meta($cur_term_id);
?>
<article id="post-<?php $cur_term_id; ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<div class="container">
			<section class="diet-section mt-60">
				<h1 class="section-title">
			   		<?php echo $term_data->name; ?>
			   		<span></span>
			    </h1>
			    <div class="download-description"><?php echo $term_data->description; ?></div>
				<?php
				$args = array('post_type' => 'wpdmpro',
					'tax_query' => array(
					array(
						'taxonomy' => 'wpdmcategory',
						'field' => 'slug',
						'terms' => $term_data->slug,
						),
					),
				);
				$loop = new WP_Query($args);
				if($loop->have_posts()) { ?>
	            <ul class="mt-60 video-listing diet-plans">
				<?php while($loop->have_posts()) : $loop->the_post(); ?>
	            	<li>
						<div class="post-image img-animate">
							<?php
							$feat_image = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );?>
							<img src="<?php echo $feat_image ?>" />
						</div>
						<div class="cnt-box">
						<div class="post-title"><?php the_title(); ?></div>
							<div class="post-content"><?php echo str_limit(strip_tags($post->post_content), 95);?> </div>
							<?php if ( is_user_logged_in() ) { $download_url =  WPDM()->package->getDownloadURL(get_the_ID());?>
							<a class='btn btn-black wpdm-download-link download-on-click' rel='nofollow' href='#' data-downloadurl="<?php echo $download_url; ?>">Download</a>
							<?php }else{?>
								<a class='btn btn-gray wpdm-download-link download-on-click' rel='nofollow' href='<?php echo site_url("my-account/")?>'><span>Login to</span> Download
								</a>
								<?php } ?>
						</div>
                   </li>
				<?php
					endwhile;
			        wp_reset_postdata();
				?>
	            </ul>
	            <?php }
	            else{?>
					<div class="no-result">No Download Avaiable!!!</div>
				<?php	} ?>
            </section>
		</div>
	</div><!-- .entry-content -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php get_footer(); ?>
