<?php
/* Template Name: Video listing page */
get_header();
$term_data = $wp_query->get_queried_object();
$cur_term_id = $term_data->term_id ;
$metaterms = get_term_meta($cur_term_id);
$main_cat_color = $metaterms['title_content_color'][0];
?>
<article id="post-<?php $cur_term_id; ?>" <?php post_class(); ?>>
	<div class="entry-content minheight">
		<div class="video-category-menu">
			<div  class="container">
				<ul>
					<li><a href="<?php echo site_url('video/');?>">All Videos</a></li>
					<?php
					$cat_style = '';
					$terms = get_terms( array(
					'taxonomy' => 'video_cat',
					'hide_empty' => false,
					'orderby' => 'ID',
                    'order' => 'ASC',
					) ); // Get Terms
					// print_r($terms);
					foreach ($terms as $key => $value)
					{ $cat_color= get_field('title_content_color',$value);
					?>
					<li>
						<a class="catbg<?php echo $key; ?> <?php echo (($cur_term_id == $value->term_id)?'active':'');?>" href="<?php echo get_category_link($value->term_id); ?>" style="color:<?php echo $cat_color; ?>; border: 1px solid <?php echo $cat_color; ?>;">
							<?php echo $value->name; ?>
						</a>
						<?php
						if(($cur_term_id == $value->term_id))
							$cat_style .=  ' .video-category-menu ul li a.catbg'.$key.':hover,.video-category-menu ul li a.catbg'.$key.'.active{background: '.$cat_color.'!important; color: #fff !important;border: 1px solid '.$cat_color.' !important;}';
						else
							$cat_style .=  ' .video-category-menu ul li a.catbg'.$key.':hover {background: '.$cat_color.'!important; color: #fff !important;border: 1px solid '.$cat_color.' !important;}';
						?>
					</li>
					<?php }
					wp_reset_postdata(); ?>
				</ul>
			</div>
			<style><?php echo $cat_style;?></style>
		</div>
		<div class="container video-list-page">
			<section class="related-video mt-60">
				<h1 class="section-title">
			   		<?php echo $term_data->name; ?>
			   		<span style="background-color:<?php echo $main_cat_color; ?>"></span>
			    </h1>
				<?php
				$args = array('post_type' => 'video',
					'tax_query' => array(
					array(
						'taxonomy' => 'video_cat',
						'field' => 'slug',
						'terms' => $term_data->slug,
						),
					),
				);
				$loop = new WP_Query($args);
				if($loop->have_posts()) { ?>
	            <ul class="mt-60 video-listing">
				<?php while($loop->have_posts()) : $loop->the_post(); ?>
	            	<li>
						<div class="post-video">
							<?php  $video = get_field('video');?>
							 <?php if(!empty( $video ) ): ?>
					            <a href="<?php echo get_permalink(get_the_ID()); ?>">
					            	<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/play-btn.png" class="play-btn" alt="play btn">
									<img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
								</a>
					        <?php endif?>
						</div>
						<div class="cnt-box">
							<div class="post-review">
								<div class="post-view">
									<span>1.8k Likes</span> <span>13.3k views</span>
								</div>
								<div class="post-share">
									<a href="#">
										<i class="icons share"></i>
									</a>
								</div>
							</div>
							<a href="<?php echo get_permalink(get_the_ID()); ?>">
								<div class="post-title" style="color:<?php echo $main_cat_color; ?>"><?php the_title(); ?></div>
							</a>
							<div class="post-content"><?php echo str_limit(strip_tags($post->post_content),95);?> </div>
							<a class="read-more" href="<?php echo get_permalink(get_the_ID()); ?>">Watch Now</a>
						</div>
                   </li>
				<?php
					endwhile;
			        wp_reset_postdata();
				?>
	            </ul>
	            <?php }
	            else{?>
					<div class="no-result">No Video Avaiable!!!</div>
				<?php	} ?>
            </section>
		</div>
	</div><!-- .entry-content -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php get_footer(); ?>
