<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Zigcy Lite
 */
get_header('blog');
$single_sidebars = get_theme_mod('sml_single_post_layout_sidebars','right-sidebar-enabled');
$cat = get_the_category();
$cat_color = get_field('title_content_color',$cat[0]->taxonomy . '_' . $cat[0]->term_id);
?>
	<div class="container">
		<div class="sml-single-post-wrapper test <?php echo esc_attr($single_sidebars); ?>">
			<div id="primary" class="content-area">
				<main id="main" class="site-main">
					<?php
					while ( have_posts() ) :
						the_post();
						$category = get_the_category();
						$category_parent_id = $category[0]->category_parent;
						if ( $category_parent_id != 0 ) {
							$category_parent = get_term( $category_parent_id, 'category' );
							$cat_slug = $category_parent->slug;
						} else {
							$cat_slug = $category[0]->slug;
						}
						get_template_part( 'template-parts/content', 'single' );
						//the_post_navigation();
						// If comments are open or we have at least one comment, load up the comment template.
						// if ( comments_open() || get_comments_number() ) :
						// 	comments_template();
						// endif;
					endwhile; // End of the loop.
					?>
				<?php
				$postgn =new WP_Query(array(
					'type' => 'product',
					'order'=>'desc',
					'posts_per_page' => 10,
					'tax_query' => array(
							  array(
									'taxonomy' => 'product_cat',
									'field' => 'slug',
									'terms' => "$cat_slug"
								)
							)
						)
					);
				if($postgn->have_posts()):
				?>
				<section class="related-product">
					<ul class="product-listing related-product-slider">
						<?php
						while ( $postgn->have_posts() ) : $postgn->the_post();
						        global $product;
						?>
						<li>
							<div class="slide-box">
							<?php
								global $product;
								show_sale_percentage_loop();?>
							<div class="product-img">
								<?php $imgp = woocommerce_get_product_thumbnail(); ?>
								<a href="<?php the_permalink(); ?>"><?php echo $imgp; ?></a>
							</div>
							<div class="product-detail">
								<h2><?php the_title(); ?></h2>
								<?php $flavour_text = get_field('product_flavour_text');
								if ( !empty($flavour_text) ) {?>
									<h3><?php echo $flavour_text; ?></h3>
								<?php } ?>
								<?php if( have_rows('product_ican') ):?>
								<div class="nutrition">
									<?php while ( have_rows('product_ican') ) : the_row();
										$num_img = get_sub_field('product_ican');
										echo wp_get_attachment_image( $num_img['id'], 'full');
									endwhile;?>
								</div>
								<?php endif;?>
								<div class="product-price">
									<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';
									show_sale_percentage_loop();
									?>
								</div>
								<div class="taxes">(inclusive of all taxes)</div>
								<div class="loop-prd-btn btn-group">
									<div class="sml-add-to-cart-wrap">
										<a href="?add-to-cart=<?php echo esc_attr( $product->id ); ?>" data-quantity="1" class="button product_type_simple add_to_cart_button ajax_add_to_cart btn border-btn" data-product_id="<?php echo esc_attr( $product->id ); ?>" data-product_sku="" aria-label="Add “<?php echo esc_attr( $product->name ); ?> to your cart" rel="nofollow">
										Add to cartc</a>
									</div>
									<form class="cart single-product" method="post" enctype='multipart/form-data' action="<?php echo esc_url(home_url( '/' ));?>checkout?set-cart-qty_<?php echo $product->id;?>=1">
										<button type="submit"  class="single_add_to_cart_button alt btn btn-green">Buy Now</button>
										<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />
									</form>
								</div>
							</div>
							<div>
						</li>
						<?php  endwhile;
						    wp_reset_query();
						?>
					</ul>
				</section>
				<?php endif; ?>
				<?php if($postgn->have_posts()):?>
				<section class="related-blogs">
	               <div class="post-heading">
		               <h3>Related Blogs</h3>
		           </div>
	                <ul>
	                   <?php $exclude_post = $post->ID;
	                        $arg = array(
	                        'post_type'         => 'post',
	                        'post__not_in' => array($exclude_post),
	                        'post_status' => 'publish',
	                        'posts_per_page'    => 3,
	                        'order'=>'desc',
	                        'tax_query' => array(
								  array(
										'taxonomy' => 'category',
										'field' => 'slug',
										'terms' => "$cat_slug"
									)
								)
	                       );
	                        $postgn = new WP_Query($arg);
	                    ?>
	                    <?php while($postgn->have_posts()) : $postgn->the_post(); ?>
	                   	<li>
							<div class="post-image">
								<?php the_post_thumbnail('medium'); ?>
							</div>
							<div class="cnt-box">
								<div class="post-title"><a style="color:<?php echo $cat_color; ?>" href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
								<div class="post-content"><?php echo substr(strip_tags($post->post_content), 0, 210);?></div>
								<a class="read-more" href="<?php the_permalink() ?>">Read More</a>
							</div>
							<?php
							endwhile;
							wp_reset_postdata();
							?>
	                   </li>
	                </ul>
	            </section>
	            		 <?php
								$arg = array(
								'post_type'=> 'video',
								'post_status' => 'publish',
								'posts_per_page'    => 3,
								'order'=>'desc',
								   'tax_query' => array(
              array(
                    'taxonomy' => 'video_cat',
                    'field' => 'slug',
                    'terms' => "$cat_slug"
                )
               )
								);
					$postgn = new WP_Query($arg);
					if($postgn->have_posts()):
					?>  <section class="related-video">
	            	<div class="post-heading">
		            	<h3>Related Video</h3>
		            	<a href="<?php echo site_url('video/');?>" class="go-videos"><span>GO TO VIDEOS</span></a>
		            </div>
		            <ul>
		            	<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
		            	<li>
							<div class="post-image">
								<?php $video = get_field('video');?>
					            <?php if(!empty( $video ) ): ?>
					          <a href="<?php echo get_permalink(get_the_ID()); ?>">
									<img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
								 </a>
					        <?php endif;?>
							</div>
							<div class="cnt-box">
								<div class="post-review">
									<div class="post-view">
										<span>1.8k Likes</span> <span>13.3k views</span>
									</div>
									<div class="post-share">
										<a href="#">
											<i class="icons share"></i>
										</a>
									</div>
								</div>
								<div class="post-title"><a style="color:<?php echo $cat_color; ?>" href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
								<div class="post-content"><?php echo substr(strip_tags($post->post_content), 0, 75);?></div>
								<a class="read-more" href="<?php the_permalink() ?>">Watch Now</a>
							</div>
	                   </li>
	                   <?php
								endwhile;
								wp_reset_postdata();
							endif;
						?>
		            </ul>
	            </section>
	          <?php endif; ?>
		</main><!-- #main -->
	</div><!-- #primary -->
	<?php
	 	// sidebar options
	    $page_sidebar_explode  =  (explode("-",$single_sidebars));
	    $page_sidebar          = $page_sidebar_explode[0];
	    if( $page_sidebar == 'both'){
	        get_sidebar('left');
	        get_sidebar('right');
	    }elseif( $page_sidebar != 'no'){
	        get_sidebar( $page_sidebar );
	    } ?>
	</div>
</div>
<?php
//get_sidebar();
get_footer();
