<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Zigcy Lite
 */
get_header();
?>
<?php $post_id= get_the_ID(); ?>
<?php $chapname = get_the_terms($post_id, 'video_cat');?>
	<article id="post-<?php echo $post_id; ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<div class="back-btn" style="background-color:">
			<div class="container">
				<a href="<?php echo site_url("video/");?>"><span>Go Back</span></a>
			</div>
		</div>
		<div class="container">
			<div class="video-detail mt-60">
				<div class="lft-box">
					<div class="l-video-box">
						<div class="heading">
							<div class="lft">
								<h3><?php the_title(); ?></h3>
								<div class="post-review">
									<div class="post-view">
										<span>1.8k Likes</span> <span>13.3k views</span>
									</div>
								</div>
							</div>
							<div class="rgt">
								<div class="post-share">
									<a href="#"><i class="icons share-b"></i></a>
								</div>
							</div>
						</div>
						<div class="video-box">
							<?php $video = get_field('video');?>
					            <?php if(!empty( $video ) ): ?>
					            <iframe width="100%" height="100%" src="<?php echo "https://www.youtube.com/embed/".$video;?>" allowfullscreen></iframe>
					        <?php endif?>
						</div>
						<?php the_content(); ?>
					 </div>
						<?php $postgn =new WP_Query(array(
					  'type' => 'post',
					  'order'=>'desc',
					  'posts_per_page' => 3,
					  'tax_query' => array(
					            array(
					                  'taxonomy' => 'category',
					                  'field' => 'slug',
					                  'terms' => $chapname[0]->slug
					              )
					          )
					      )
					  );?>
					<div class="related-blogs">
						<div class="post-heading">
			               <h3>Related Blogs</h3>
			               <a href="<?php echo site_url('blog')?>" class="go-videos"><span>GO TO Blogs</span></a>
			           </div>
						<ul>
			           <?php while($postgn->have_posts()) : $postgn->the_post(); ?>
			           	<li>
			           		<div class="post-image">
			           			<?php the_post_thumbnail('medium'); ?>
			           		</div>
			           		<div class="cnt-box">
			           			<div class="post-title"><a href="<?php echo get_permalink(get_the_ID()); ?>"><?php the_title(); ?></a></div>
		           				<div class="post-content"><?php echo substr(strip_tags($post->post_content), 0, 98);?></div>
		           				<a class="read-more" href="<?php the_permalink() ?>">Read More</a>
			           		</div>
			           	</li>
			           	<?php
								endwhile;
								wp_reset_postdata();
								?>
			        </ul>
					</div>
				</div>
				<div class="rgt-box">
					<h2>Related videos</h2>
					<?php
								$arg = array(
								'post_type'=> 'video',
								'post_status' => 'publish',
								'posts_per_page'    => 2,
								'order'=>'desc',
								   'tax_query' => array(
              array(
                    'taxonomy' => 'video_cat',
                    'field' => 'slug',
                    'terms' => $chapname[0]->slug
                )
            )
								);
								$postgn = new WP_Query($arg);?>
					<ul>
						<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
						<li>
							<div class="video-box"><?php $video = get_field('video');?>
					            <?php if(!empty( $video ) ): ?>
					      <a href="<?php echo get_permalink(get_the_ID()); ?>">
					        <img src="<?php echo site_url() .'/wp-content/themes/zigcy-lite/assets/images/play-btn.png' ; ?>" class="play-btn" alt="play btn">
									<img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
								</a>
					        <?php endif?></div>
							<div class="post-review">
								<div class="post-view">
									<span>1.8k Likes</span> <span>13.3k views</span>
								</div>
								<div class="post-share">
									<a href="#">
										<i class="icons share"></i>
									</a>
								</div>
							</div>
							<a href="<?php echo get_permalink(get_the_ID()); ?>">
								<h3><?php the_title(); ?></h3>
							</a>
							<p><?php echo substr(strip_tags($post->post_content), 0, 75);?></p>
							<a href="<?php the_permalink() ?>" class="read-more">Watch Now</a>
						</li>
							<?php
								endwhile;
								wp_reset_postdata();
						?>
					</ul>
				</div>
			</div>
		</div>
	</div><!-- .entry-content -->
<?php
//get_sidebar();
get_footer();
