<?php
/**
* Left Sidebar for the theme
*
* @package Zigcy Lite
*/
if ( ! is_active_sidebar( 'sidebar-2' ) ) {
	return;
}
?>
<div class="sidebar-left product-filter mt-60">
	<aside id="left-sidebar" class="widget-area">
    	<a href="javascript:void(0)" class="filter-close">X</a>
		<div class="filter-by">
		  <?php if(is_product_category()) {
			echo '<span>Filter by</span>';
		}else{
			echo '<span>Filter by</span>';
		}
		?>
			<div class="clear-all"><?php echo do_shortcode('[br_filter_single filter_id=538]'); ?></div>
		</div>
		<?php if(!is_shop()){?>
		<div class="shop-category">
			<h3>Shop By Category</h3>
			<ul>
			<?php
			$category = get_queried_object();
			$terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'posts_per_page'=> 6,
				'hide_empty' => false,
				) );
				foreach ($terms as $key => $value)
				{
					$style	= '';
					if(isset($category->term_id) && !empty($category->term_id))
					{
						if($value->term_id == $category->term_id)
							$style	= 'class="active"';
					}
								//
				?>
				<li><a href="<?php echo get_category_link($value->term_id); ?>" <?php echo $style;?>><i></i><?php echo $value->name; ?></a></li>
			 <?php } ?>
			</ul>
		</div>
		<div class="shop-category">
			<h3>Shop By Goal</h3>
			<ul>
			<?php
			$attribute = get_queried_object();
			$terms = get_terms( array(
				'taxonomy' => 'pa_shop-by-goals',
				'posts_per_page'=> 10,
				'hide_empty' => true,
				) );
			foreach ($terms as $key => $value)
				{
					$style	= '';
					if(isset($attribute->term_id) && !empty($attribute->term_id))
					{
						if($value->term_id == $attribute->term_id)
							$style	= 'class="active"';
					}
			?>
			<li><a href="<?php echo get_term_link($value->term_id); ?>" <?php echo $style;?>><i></i><?php echo $value->name; ?></a></li>
			 <?php } ?>
			</ul>
		</div>
		<div class="shop-category">
			<h3>Shop By Gender</h3>
			<ul>
			<?php
			$attribute = get_queried_object();
			$terms = get_terms( array(
				'taxonomy' => 'pa_shop-by-gender',
				'posts_per_page'=> 10,
				'hide_empty' => true,
				) );
			foreach ($terms as $key => $value)
				{
					$style	= '';
					if(isset($attribute->term_id) && !empty($attribute->term_id))
					{
						if($value->term_id == $attribute->term_id)
							$style	= 'class="active"';
					}
			?>
			<li><a href="<?php echo get_term_link($value->term_id); ?>" <?php echo $style;?>><i></i><?php echo $value->name; ?></a></li>
			 <?php } ?>
			</ul>
		</div>
		<div class="shop-category">
		<?php
		dynamic_sidebar( 'sidebar-3' ); echo '</div>' ; }?>
        <?php  if(is_shop()){
			 dynamic_sidebar( 'sidebar-2' );
			}
        ?>
    </aside><!-- #left-sidebar -->
</div><!-- sidebar-left -->
