<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Zigcy Lite
 */
get_header('blog');
$sml_archive_post_sidebar = get_theme_mod('zigcy_lite_archive_post_layout_sidebars','');
?>
<?php if (function_exists('category_image_src')) {
	$category_image = category_image_src( array( 'size' => 'full' ) , false );
} else {
	$category_image = '';
}?>
<div class="container">
	<div class="blog-menu-section">
		<div class="blog-menu">
			<?php echo wp_nav_menu( array( 'menu'=>93,'menu_class'=>'blog-menu','container'=>'container','theme_location' => 'menu-3') ); ?>
		</div>
	</div>
</div>
	<div class="container">
		<div class="sml-archive-wrapper ASA<?php echo esc_attr($sml_archive_post_sidebar); ?>">
			<div id="primary" class="content-area">
				<main id="main" class="site-main">
				<?php
				if ( have_posts() ) :
					if ( is_home() && ! is_front_page() ) :
						?>
						<header>
							<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
						</header>
						<div class="featured-post">
							<div id="post-<?php the_ID(); ?>" class="single-post">
								<?php $contet_class = (has_post_thumbnail() ) ? 'content-with-image' : 'content-no-image'; ?>
								<div class="content-wrap blog <?php echo $contet_class; ?>">
									<div class="post-image">
										<?php /*$banner_image = get_field('banner_inner_image');
										if(!empty($banner_image)){
											//echo wp_get_attachment_image($banner_image['id'], array('600', '400'), "", array( "class" => "" ) );
										}
										else { ?>
										<img src="<?php bloginfo('template_directory'); ?>/assets/images/maria.png" alt="<?php the_title(); ?>" />
										<?php } */?>
										 <?php the_post_thumbnail('single-blog-thumbnail'); ?>
									</div>
									<div class="cnt-box">
										<?php
										the_title( '<h2 class="post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
										?>
										<div class="post-date"><span class="by-author"> By <?php the_author()?></span> <span class="date"><?php the_time('j F y') ?></span>
										</div>
										<div class="post-content">
											<?php str_replace('[…]','',the_excerpt()); ?>
										</div><!-- .entry-content -->
										<a class="read-more" href="<?php the_permalink() ?>">read more</a>
									</div>
								</div>
							</div><!-- #post-## -->
							<div class="latest-blog">
								<?php
								$arg = array(
								'post_type'         => 'post',
								'post_status' => 'publish',
								'posts_per_page'    => 2,
								'offset'         => 1,
								'order'=>'DESC'
								);
								$postgn = new WP_Query($arg);?>
								<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
									<div class="latest-blog-list">
										<div class="post-image">
										<?php /*$banner_image = get_field('banner_inner_image');
												if(!empty($banner_image)){
												echo wp_get_attachment_image($banner_image['id'],array('384', '255'), "", array( "class" => "" ) );
                           						}*/?>
                           						 <?php the_post_thumbnail('medium'); ?>
										</div>
										<div class="cnt-box">
											<h2 class="post-title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
											<div class="post-date">
												<span class="by-author"> By <?php the_author()?></span> <span class="date"><?php the_time('j F y') ?></span>
											</div>
											<div class="post-content"><?php echo substr(strip_tags($post->post_content), 0, 98);?></div>
											<a class="read-more" href="<?php the_permalink() ?>">Read More</a>
										</div>
									</div>
								<?php
								endwhile;
								wp_reset_postdata();
								?>
							</div>
						</div><!-- .featured-post End -->
		            <?php
		                $terms = get_categories(
						    array(
						        'parent' => 0,
						         'orderby' => 'term_order',
						    )
						);
						//print_r($terms);
						foreach ($terms as $key => $value)
					{
						$metaterms = get_term_meta($value->term_id);?>
						<section class="weight-category">
                       <?php $cat_color=get_field('title_content_color', $value); ?>
						   <h2 class="section-title js-scroll fade-in-bottom">
						   	<?php echo $value->name; ?><span style="background-color:<?php echo $cat_color ?>"></span>
						   </h2>
                         <ul class="post-listing">
			            <?php
						$postgn =new WP_Query(array(
						    'category_name' =>$value->name ,
						    'order'=>'desc',
						    'posts_per_page' => 6
						) );
			              //  print_r($arg);
			            ?>
			            <?php while($postgn->have_posts()) : $postgn->the_post(); ?>
			           <li>
			                <div class="post-image">
			                    <?php the_post_thumbnail('medium'); ?>
			                </div>
			                <div class="cnt-box">
			                   <a style="color:<?php echo $cat_color; ?>" href="<?php the_permalink() ?>"><h3><?php the_title(); ?></h3></a>
			                    <div class="post-date">
			                    	<span class="by-author"> By <?php the_author()?></span>
			                    	<span class="date"><?php the_time('j F y') ?></span>
								</div>
			                    <div class="post-content"><?php echo substr(strip_tags($post->post_content), 0, 98);?></div>
			                    <a class="read-more" href="<?php the_permalink() ?>">Read More</a>
			                </div>
			            <?php
			            endwhile;
			            wp_reset_postdata();
			        ?>
			        </li>
			    </ul>
                <div class="align-center">
                	<a class="btn btn-black view-all" href="<?php echo get_category_link($value->term_id); ?>"><span>View All</span></a>
                </div>
		     <?php } ?>
			</section>
						<?php
					endif;
					/* Start the Loop */
					while ( have_posts() ) :
						the_post();
						/*
						 * Include the Post-Type-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
						 */
						//get_template_part( 'template-parts/content', 'archive' );
					endwhile;
					//zigcy_lite_numeric_posts_nav();
				else :
				//	get_template_part( 'template-parts/content', 'none' );
				endif;
				?>
				</main><!-- #main -->
			</div><!-- #primary -->
		<?php
        // sidebar options
        $archive_sidebar_explode  =  (explode("-",$sml_archive_post_sidebar));
        $archive_sidebar          = $archive_sidebar_explode[0];
        if( $archive_sidebar == 'both'){
            //get_sidebar('left');
            //get_sidebar('right');
        }elseif( $archive_sidebar != 'no'){
            //get_sidebar( $archive_sidebar );
        }
        ?>
		</div>
	</div>

<?php

get_footer();
