<?php
/**
 * Zigcy Lite functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Zigcy Lite
 */
/** important constants **/
define( 'zigcy_lite_THEME_URI', get_template_directory_uri() );
define( 'zigcy_lite_THEME_DIR', get_template_directory() );
if ( ! function_exists( 'zigcy_lite_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function zigcy_lite_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Zigcy Lite, use a find and replace
		 * to change 'zigcy-lite' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'zigcy-lite', get_template_directory() . '/languages' );
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );
		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'newclass' );
		add_image_size( 'sm-blog-img', 390, 290, true );
		add_image_size( 'newclass', 1877, 700, true);
		add_theme_support( 'woocommerce/includes' );
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'zigcy-lite' ),
			'blog-menu' => esc_html__( 'Blog Menu', 'zigcy-lite' ),
			// 'menu-2' => esc_html__( 'Currency Menu', 'zigcy-lite' ),
			'menu-3' => esc_html__( 'Language Menu', 'zigcy-lite' ),
		) );
		// register_nav_menus(
		// 	array(
		// 		'primary' => esc_html__( 'Primary menu', 'zigcy-lite' ),
		// 		'footer'  => __( 'Secondary menu', 'zigcy-lite' ),
		// 	)
		// );
	// This theme uses wp_nav_menu() sr.
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );
		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );
		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'zigcy_lite_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );
		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'zigcy_lite_setup' );
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function zigcy_lite_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'zigcy_lite_content_width', 640 );
}
add_action( 'after_setup_theme', 'zigcy_lite_content_width', 0 );
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function zigcy_lite_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Right Sidebar', 'zigcy-lite' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'zigcy-lite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Left Sidebar', 'zigcy-lite' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Add widgets here.', 'zigcy-lite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Left price Sidebar', 'zigcy-lite' ),
		'id'            => 'sidebar-3',
		'description'   => esc_html__( 'Add widgets here.', 'zigcy-lite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Right Sidebar My Account', 'zigcy-lite' ),
		'id'            => 'my-account',
		'description'   => esc_html__( 'Add widgets My Account.', 'zigcy-lite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	$footer_widget_regions = apply_filters( 'zigcy_lite_footer_widget_regions', 3 );
	for ( $i = 1; $i <= intval( $footer_widget_regions ); $i++ ) {
		register_sidebar( array(
			/* translators: %d: Value*/
			'name' 				=> sprintf( __( 'Footer Widget Area %d', 'zigcy-lite' ), $i ),
			'id' 				=> sprintf( 'footer-%d', $i ),
			/* translators: %d: Value*/
			'description' 		=> sprintf( __( ' Add Widgetized Footer Region %d.', 'zigcy-lite' ), $i ),
			'before_widget' 	=> '<div id="%1$s" class="widget %2$s">',
			'after_widget' 		=> '</div>',
			'before_title' 		=> '<h2 class="widget-title">',
			'after_title' 		=> '</h2>',
		));
	}
}
add_action( 'widgets_init', 'zigcy_lite_widgets_init' );
/**
 * Enqueue scripts and styles.
 */
function zigcy_lite_scripts() {
	//$query_args = array('family' => 'Poppins:100,200,300,400,500,600,700,800|Roboto:400,300,500,700');
  	//wp_enqueue_style('google-fonts', add_query_arg($query_args, "//fonts.googleapis.com/css"));
	wp_enqueue_style( 'zigcy-lite-style', get_stylesheet_uri() );
	//wp_enqueue_style( 'zigcy-lite-keyboard', get_template_directory_uri() . '/assets/css/keyboard.css' );
	wp_enqueue_style( 'fonts-css', get_template_directory_uri() . '/assets/css/fonts.css' );
	wp_enqueue_style( 'slick-gn', get_template_directory_uri() . '/assets/css/slick-gn.css');
	if(!is_front_page()){
		wp_enqueue_style( 'easy-responsive-tabs', get_template_directory_uri() . '/assets/css/easy-responsive-tabs.css');
	}


	wp_enqueue_style( 'responsive-gn', get_template_directory_uri() . '/assets/css/responsive-gn.css');
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/externals/font-awesome/css/font-awesome.min.css' );
	wp_enqueue_style( 'linearicons',zigcy_lite_THEME_URI . '/assets/externals/linearicons/style.css');
	wp_enqueue_style( 'materialize', get_template_directory_uri() . '/assets/css/materialize.min.css');
	wp_enqueue_script( 'SmoothScroll',zigcy_lite_THEME_URI.'/assets/externals/SmoothScroll/SmoothScroll.js',array(),'20151215', true );

	//wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css' );
	//wp_enqueue_style( 'owl-theme-default', get_template_directory_uri() . '/assets/css/owl.theme.default.min.css' );
 	wp_enqueue_style( 'slick', get_template_directory_uri() . '/assets/css/slick.css', array(), '20151215' );
 	wp_enqueue_style( 'zigcy-lite-mCustomScrollbar', zigcy_lite_THEME_URI. '/assets/scrollbar/jquery.mCustomScrollbar.css' );
    wp_enqueue_style( 'zigcy-lite-responsive', zigcy_lite_THEME_URI. '/assets/css/responsive.css' );
    wp_enqueue_script( 'jarallax', get_template_directory_uri() . '/assets/js/jarallax.js', array( 'jquery' ), '1.1.3', true );
	//wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array('jquery'), '20151215', true );
    wp_enqueue_script( 'slick', get_template_directory_uri() . '/assets/js/slick.min.js',array('jquery'), '20151215' );
    wp_enqueue_script( 'select2', get_template_directory_uri() . '/assets/js/select2.min.js',array('jquery'), '20151215' );
    wp_enqueue_script( 'jquery.mCustomScrollbar', get_template_directory_uri() . '/assets/scrollbar/jquery.mCustomScrollbar.min.js',array('jquery'), '20151215' );
	wp_enqueue_script( 'zigcy-lite-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), '20151215', true );
	//wp_enqueue_script( 'zigcy-lite-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js', array(), '20151215', true );
	//wp_enqueue_script( 'zigcy-lite-yith', get_template_directory_uri() . '/assets/js/yith-wcwl-custom.js', array(), '20151215', true );
	if(!is_front_page()){
	wp_enqueue_script( 'materialize',zigcy_lite_THEME_URI.'/assets/js/materialize.min.js',array(), '20151215', true );
	wp_enqueue_script( 'easy-responsive-js',zigcy_lite_THEME_URI.'/assets/js/easy-responsive-tabs.js',array(), '20151215', true );
	}

	wp_enqueue_script( 'zigcy-lite-scripts',zigcy_lite_THEME_URI.'/assets/js/custom.js',array(), time(), true );
	wp_register_script( 'vcma-ajax', zigcy_lite_THEME_URI . '/assets/js/sml-ajax.js', array( 'jquery' ), '20151215', true );
    wp_localize_script( 'vcma-ajax', 'ajax_object',array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
    wp_enqueue_script( 'vcma-ajax' );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'zigcy_lite_scripts' );
/**
* Enque admin scripts and styles
*/
function zigcy_lite_admin_scripts() {
    wp_enqueue_style( 'zigcy-lite-customizer-styles',zigcy_lite_THEME_URI. '/inc/customizer/assets/css/customizer-style.css');
    wp_register_script( 'zigcy-lite-customizer-scripts', zigcy_lite_THEME_URI. '/inc/customizer/assets/js/customizer-script.js',array('jquery','customize-controls','jquery-ui-sortable'), '20151215', false );
    wp_enqueue_style('zigcy-lite-spectrum-css',zigcy_lite_THEME_URI.'/inc/customizer/assets/spectrum/spectrum.css');
	wp_enqueue_script('zigcy-lite-spectrum-js', zigcy_lite_THEME_URI . '/inc/customizer/assets/spectrum/spectrum.js',array('jquery'));
	$zigcy_lite = array();
    $zigcy_lite['ajax_url'] = admin_url('admin-ajax.php');
    wp_localize_script( 'zigcy-lite-customizer-scripts', 'ZigcyLiteLoc', $zigcy_lite );
	wp_enqueue_script( 'zigcy-lite-customizer-scripts' );
}
add_action( 'customize_controls_enqueue_scripts', 'zigcy_lite_admin_scripts');
/**
* Load init files for theme
*/
require zigcy_lite_THEME_DIR . '/inc/init.php';
if ( function_exists( 'acf_add_options_page' ) ) {
	acf_add_options_page( 'Global Settings' );
}

add_image_size( 'single-blog-thumbnail', 600, 400 );


/**registration form***/
function woocommerce_registration_errors_validation($reg_errors, $sanitized_user_login, $user_email) {
	global $woocommerce;
	extract( $_POST );
	if ( strcmp( $password, $password2 ) !== 0 ) {
		return new WP_Error( 'registration-error', __( 'Passwords do not match.', 'woocommerce' ) );
	}
	return $reg_errors;
}
add_filter('woocommerce_registration_errors', 'woocommerce_registration_errors_validation', 10, 3);
function woocommerce_register_form_password_repeat() {
	?>
	<div class="form-row form-row-wide">
		<label for="reg_password2"><?php _e( 'Confirm password', 'woocommerce' ); ?> <span class="required">*</span></label>
		<span class="password-input">
           <input type="password" class="input-text" name="password2" id="reg_password2" value="<?php if ( ! empty( $_POST['password2'] ) ) echo esc_attr( $_POST['password2'] ); ?>" placeholder="Enter your password"/>
        </span>
	</div>
	<?php
}
add_action( 'woocommerce_register_form', 'woocommerce_register_form_password_repeat' );
//sr Set coupon code as custom data in cart session
add_action('wp_loaded', 'add_coupon_code_to_cart_session');
function add_coupon_code_to_cart_session() {
    // Exit if no code in URL or if the coupon code is already set cart session
    if( empty( $_GET["code"] ) || WC()->session->get( 'custom_discount' ) ) return;
    if( ! WC()->session->get( 'custom_discount' ) ) {
        $coupon_code = esc_attr($_GET["code"]);
        WC()->session->set( 'custom_discount', $coupon_code );
        // If there is an existing non empty cart active session we apply the coupon
        if( ! WC()->cart->is_empty() ){
            WC()->cart->add_discount( $coupon_code );
        }
    }
}
// Add coupon code when a product is added to cart once
add_action('woocommerce_add_to_cart', 'add_coupon_code_to_cart', 10, 6 );
function add_coupon_code_to_cart( $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data ){
    $coupon_code = WC()->session->get( 'custom_discount' );
    $applied_coupons = WC()->session->get('applied_coupons');
    if( empty($coupon_code) || in_array( $coupon_code, $applied_coupons ) ) return;
    WC()->cart->add_discount( $coupon_code );
}
// Remove coupon code when user empty his cart
add_action('woocommerce_cart_item_removed', 'check_coupon_code_cart_items_removed', 10, 6 );
function check_coupon_code_cart_items_removed( $cart_item_key, $cart ){
    $coupon_code = WC()->session->get( 'custom_discount' );
    if( $cart->has_discount( $coupon_code ) && $cart->is_empty() );
        $cart->remove_coupon( $coupon_code );
}
/*Custom Post type start*/
function cw_post_type_testimonial() {
$supports = array(
'title', // post title
'editor', // post content
'author', // post author
'thumbnail', // featured images
'excerpt', // post excerpt
'custom-fields', // custom fields
//'comments', // post comments
'revisions', // post revisions
'post-formats', // post formats
'page-attributes'
);
$labels = array(
'name' => _x('Testimonial', 'plural'),
'singular_name' => _x('Testimonial', 'singular'),
'menu_name' => _x('Testimonials', 'admin menu'),
'name_admin_bar' => _x('Testimonial', 'admin bar'),
'add_new' => _x('Add New', 'add new Testimonial'),
'add_new_item' => __('Add New'),
'new_item' => __('New Testimonial'),
'edit_item' => __('Edit Testimonial'),
'view_item' => __('View Testimonial'),
'all_items' => __('All Testimonial'),
'search_items' => __('Search Testimonial'),
'not_found' => __('No Testimonial found.'),
);
$args = array(
'supports' => $supports,
'labels' => $labels,
'public' => true,
//'query_var' => true,
'rewrite' => array('slug' => 'testimonials'),
//'has_archive' => true,
'hierarchical' => false,
'menu_position' => 4,
 'menu_icon' => 'dashicons-format-status',
);
register_post_type('testimonials', $args);
}
add_action('init', 'cw_post_type_testimonial');
/*Custom Post type In media start*/
function cw_post_type_media() {
$supports = array(
'title', // post title
'editor', // post content
'author', // post author
'thumbnail', // featured images
'excerpt', // post excerpt
'custom-fields', // custom fields
//'comments', // post comments
'revisions', // post revisions
'post-formats', // post formats
'page-attributes'
);
$labels = array(
'name' => _x('media', 'plural'),
'singular_name' => _x('media', 'singular'),
'menu_name' => _x('In Media', 'admin menu'),
'name_admin_bar' => _x('media', 'admin bar'),
'add_new' => _x('Add New', 'add new media'),
'add_new_item' => __('Add New'),
'new_item' => __('New media'),
'edit_item' => __('Edit media'),
'view_item' => __('View media'),
'all_items' => __('All media'),
'search_items' => __('Search media'),
'not_found' => __('No media found.'),
);
$args = array(
'supports' => $supports,
'labels' => $labels,
'public' => true,
//'query_var' => true,
'rewrite' => array('slug' => 'medias'),
//'has_archive' => true,
'hierarchical' => false,
'menu_position' => 4,
 'menu_icon' => 'dashicons-admin-site-alt3',
);
register_post_type('medias', $args);
}
add_action('init', 'cw_post_type_media');
function custom_video() {
  $labels = array(
    'name'               => _x( 'Videos', 'post type general name' ),
    'singular_name'      => _x( 'Video', 'post type singular name' ),
    'add_new'            => _x( 'Add New', 'Video' ),
    'add_new_item'       => __( 'Add New Video' ),
    'edit_item'          => __( 'Edit Video' ),
    'new_item'           => __( 'New Video' ),
    'all_items'          => __( 'All Videos' ),
    'view_item'          => __( 'View Video' ),
    'search_items'       => __( 'Search Videos' ),
    'not_found'          => __( 'No Video found' ),
    'not_found_in_trash' => __( 'No Video found in the Trash' ),
    'parent_item_colon'  => '',
    'menu_name'          => 'Videos'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Video',
    'public'        => true,
    'menu_position' => 5,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
    'has_archive'   => true,
	'taxonomies'  => array( 'video-catgeory' ),
  );
  register_post_type( 'video', $args );
}
add_action( 'init', 'custom_video' );
	/*
	for more information on taxonomies, go here:
	http://codex.wordpress.org/Function_Reference/register_taxonomy
	*/
	// now let's add custom categories (these act like categories)
	register_taxonomy(
			'video_cat',
			array('video'), /* if you change the name of register_post_type( 'videos', then you have to change this */
			array(
					'hierarchical'          => true,
					'label'                 => __( 'Video Categories' ),
					'labels'                => array(
						'name'                  => __( 'Video categories'),
						'singular_name'         => __( 'Category'),
						'menu_name'             => _x( 'Categories', 'Admin menu name'),
						'search_items'          => __( 'Search categories'),
						'all_items'             => __( 'All categories'),
						'parent_item'           => __( 'Parent category'),
						'parent_item_colon'     => __( 'Parent category:'),
						'edit_item'             => __( 'Edit category'),
						'update_item'           => __( 'Update category'),
						'add_new_item'          => __( 'Add new category'),
						'new_item_name'         => __( 'New category name'),
						'not_found'             => __( 'No categories found'),
					),
					'show_in_rest'          => true,
					'show_ui'               => true,
					'query_var'             => true,
					'rewrite'               => array(
						'slug'         => 'video-category',
						'with_front'   => true,
						'hierarchical' => true,
					),
				)
		);
 function custom_mtypes( $m ){
    $m['svg'] = 'image/svg+xml';
    $m['svgz'] = 'image/svg+xml';
    return $m;
}
add_filter( 'upload_mimes', 'custom_mtypes' );
//add_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 98);
//remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
// add_action( 'init', 'move_related_products_before_tabs' );
// function move_related_products_before_tabs( ) {
//
//     add_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 90 );
// }
add_filter( 'woocommerce_product_tabs', 'woo_new_product_tab' );
function woo_new_product_tab( $tabs ) {
// Adds the new tab
    $tabs['desc_tab'] = array(
        'title'     => __( 'Additional Information', 'woocommerce' ),
        'priority'  => 1,
        'callback'  => 'woo_new_product_tab_content'
    );
}
function woo_new_product_tab_content() {
  // The new tab content
  echo '<p>Lorem Ipsum</p>';
}
add_action( 'woocommerce_single_product_summary', 'custom_rating_single_product_summary', 4 );
function custom_rating_single_product_summary() {
    global $product;
    if ( $product->get_rating_count() > 0 ) {
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
        add_action( 'woocommerce_single_product_summary', 'replace_product_rating', 1 );
    }
}
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action('woocommerce_single_product_summary','woocommerce_template_single_title',5);
remove_action('woocommerce_single_product_summary','woocommerce_template_single_excerpt',20);
remove_action('woocommerce_single_product_summary','woocommerce_template_single_meta',40);
remove_action('woocommerce_single_product_summary','woocommerce_template_single_sharing',50);
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_filter( 'woocommerce_get_price_html', 'price_array', 100, 2 );
function price_array($price){
    $price = str_replace('</bdi>', '/-</bdi>', $price);
    return $price;
}
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 3 );
add_action( 'woocommerce_after_shop_loop_item_title', 'product_template_loop_data', 4 );
function product_template_loop_data()
{
	global $product;
	//print_r($product);
	$product_id	= $product->get_id();
	ob_start();
	$flavour_text = get_field('product_flavour_text',$product_id);
    if ( !empty($flavour_text) ) {?>
			<div class="product-flavour"><?php echo $flavour_text; ?></div>
			<?php } ?>
			<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
				$cat_slug = $catTerms[0]->slug;
				?>
				<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
	<div class="deception">
  		<?php the_excerpt(); ?>
  	</div>
  	<div class="product-category">
				<div class="category-name" style="background-color:<?php echo $cat_color ?>"><?php echo $catTerms[0]->name;?></div>
			</div>
	<?php
	$content =  ob_get_clean();
    echo $content;
}
function str_limit($longString,$maxLength=20){
	if(!empty($longString)){
	$str = preg_split("/.{0,{$maxLength}}\K(?:\s+|$)/", $longString, 0, PREG_SPLIT_NO_EMPTY);
	return $str[0];
	}
	else
		return ;
}
function blank_scripts() {
    wp_localize_script( 'requireJS', 'js_config', array(
        'ajax_url'	=> admin_url( 'admin-ajax.php' ),
        'ajax_nonce'	=> wp_create_nonce( 'ajax-nonce' ),
    ));
}
add_action( 'wp_enqueue_scripts', 'blank_scripts' );
function email_subscribe_container() {
    echo '<div id="email-subscribe-container"><form id="newsletter_signup">
<input class="newsletter-email" type="email" name="ne" size="30" placeholder="Email" required />
<input type="hidden" name="na" value="S">
<input type="hidden" name="nhr" value="' . get_bloginfo( 'url' ) . '/">
<input class="newsletter-submit" type="submit" value="Subscribe" />
</form>
</div>';
}
function jnz_tnp_ajax_subscribe() {
    check_ajax_referer( 'ajax-nonce', 'nonce' );
    $data = urldecode( $_POST['data'] );
    if ( !empty( $data ) ) :
        $data_array = explode( "&", $data );
        $fields = [];
        foreach ( $data_array as $array ) :
            $array = explode( "=", $array );
            $fields[ $array[0] ] = $array[1];
        endforeach;
    endif;
    if ( !empty( $fields ) ) :
         if ( filter_var( $fields['ne'], FILTER_VALIDATE_EMAIL ) ) :
            global $wpdb;
             //check if the email is already in the database
             $exists = $wpdb->get_var(
                 $wpdb->prepare(
                     "SELECT email FROM " . $wpdb->prefix . "newsletter
                    WHERE email = %s",
                     $fields['ne']
                 )
             );
             if ( ! $exists ) {
                 //NewsletterSubscription::instance()->subscribe();
                 $output = array(
                     'status'    => 'success',
                     'msg'       => __( 'Thank you for your Email. Please check your inbox to confirm your subscription.', 'theme_text_domain' )
                 );
             } else {
                 //email is already in the database
                 $output = array(
                     'status'    => 'error',
                     'msg'       => __( 'Your Email is already in our system. Please check your inbox, to confirm your subscription.', 'theme_text_domain' )
                 );
             }
         else :
             $output = array(
                 'status'    => 'error',
                 'msg'       => __( 'The Email address is invalid.', 'theme_text_domain' )
             );
         endif;
    else :
        $output = array(
            'status'    => 'error',
            'msg'       => __( 'An Error occurred. Please try again later.', 'theme_text_domain' )
        );
    endif;
    wp_send_json( $output );
}
add_action( 'wp_ajax_nopriv_ajax_subscribe', 'jnz_tnp_ajax_subscribe' );
add_action( 'wp_ajax_ajax_subscribe', 'jnz_tnp_ajax_subscribe' );
// add inline script to disable elementor smooth scroll
add_action( 'wp_enqueue_scripts', function() {
   wp_add_inline_script( 'elementor-frontend', "jQuery(window).on('elementor/frontend/init',function(){if(typeof elementorFrontend==='undefined'){return}elementorFrontend.on('components:init',function(){elementorFrontend.utils.anchors.setSettings('selectors.targets','.dummy-selector')})});" );
} );
remove_action( 'woocommerce_checkout_order_review', 'woocommerce_order_review', 10 );
add_action( 'woocommerce_checkout_after_order_review', 'woocommerce_order_review', 10 );
function my_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/assets/images/logo.svg);
            width: 180px; height: 85px; background-size: 100%; background-color: transparent; padding: 10px; background-position: center;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );
add_filter( 'login_headerurl', 'custom_loginlogo_url' );
function custom_loginlogo_url($url) {
    return home_url();
}
function tn_disable_visual_editor( $can ) {
//global $post;
//if ( 650 == $post->ID )
//return false;
return $can;
}
add_filter( 'user_can_richedit', 'tn_disable_visual_editor' );
add_filter('excerpt_more', function($more) {
	return '';
});
add_action( 'wp_footer', function () { ?>
    <!--Start of Tawk.to Script-->
<!--<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/630de0c654f06e12d891b7e1/1gbn3c2v3';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script> -->
<!--End of Tawk.to Script-->
<?php } );
add_filter('wp_is_mobile','my_wp_is_mobile');
function my_wp_is_mobile() {
    static $is_mobile;
    if ( isset($is_mobile) )
        return $is_mobile;
    if ( empty($_SERVER['HTTP_USER_AGENT']) ) {
        $is_mobile = false;
    } elseif (
        strpos($_SERVER['HTTP_USER_AGENT'], 'Android') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Silk/') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Kindle') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'BlackBerry') !== false
        || strpos($_SERVER['HTTP_USER_AGENT'], 'Opera Mini') !== false ) {
            $is_mobile = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'Mobile') !== false && strpos($_SERVER['HTTP_USER_AGENT'], 'iPad') == false) {
            $is_mobile = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'iPad') !== false) {
        $is_mobile = false;
    } else {
        $is_mobile = false;
    }
    return $is_mobile;
}
add_filter( 'woocommerce_order_button_text', 'change_button_text' );
function change_button_text( $button_text ) {
	return 'Proceed To Pay'; // new text is here
}
/*Custom Post type start*/
function cw_post_type_epic_guides() {
$supports = array(
'title', // post title
'editor', // post content
'author', // post author
'thumbnail', // featured images
'excerpt', // post excerpt
'custom-fields', // custom fields
//'comments', // post comments
'revisions', // post revisions
'post-formats', // post formats
'page-attributes'
);
$labels = array(
'name' => _x('Guides', 'plural'),
'singular_name' => _x('Guides', 'singular'),
'menu_name' => _x('Guides', 'admin menu'),
'name_admin_bar' => _x('Guides', 'admin bar'),
'add_new' => _x('Add New', 'add new Guides'),
'add_new_item' => __('Add New'),
'new_item' => __('New Guides'),
'edit_item' => __('Edit Guides'),
'view_item' => __('View Guides'),
'all_items' => __('All Guides'),
'search_items' => __('Search Guides'),
'not_found' => __('No Guides found.'),
);
$args = array(
'supports' => $supports,
'labels' => $labels,
'public' => true,
//'query_var' => true,
'rewrite' => array('slug' => 'health-guides'),
//'has_archive' => true,
//'hierarchical' => false,
'menu_position' => 4,
 'menu_icon' => 'dashicons-format-status',
);
register_post_type('guides', $args);
}
add_action('init', 'cw_post_type_epic_guides');
/***Cart page cross sell below total table* */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display' );
add_filter( 'woocommerce_cross_sells_columns', 'bbloomer_change_cross_sells_columns' );
function bbloomer_change_cross_sells_columns( $columns ) {
	echo "<div class='also-like recentview'> <div class='up-sells upsells products'>";
return 4;
echo "</div> </div>";
}
add_filter('woocommerce_cross_sells_total', 'cross_sells_limit');
function cross_sells_limit() {
    return 4;
}
add_filter( 'woocommerce_product_add_to_cart_text', 'customizing_add_to_cart_button_text', 10, 2 );
add_filter( 'woocommerce_product_single_add_to_cart_text', 'customizing_add_to_cart_button_text', 10, 2 );
function customizing_add_to_cart_button_text( $button_text, $product )
{
    $is_in_cart = false;
    foreach ( WC()->cart->get_cart() as $cart_item )
       if ( $cart_item['product_id'] == $product->get_id() ) {
           $is_in_cart = true;
           break;
       }
    if( $is_in_cart )
        $button_text = __( 'View Cart', 'woocommerce' );
    return $button_text;
}
//* Add gallery thumbs to woocommerce shop page
//add_action('woocommerce_shop_loop_item_title','wps_add_extra_product_thumbs', 5);
 function custom_theme_setup() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'custom_theme_setup' );
/**car page quanity update **/
add_action( 'wp_footer', 'cart_update_qty_script' );
function cart_update_qty_script() {
  if (is_cart()) :
   ?>
    <script>
        jQuery('div.woocommerce').on('change', '.qty', function(){
           jQuery("[name='update_cart']").removeAttr('disabled');
           jQuery("[name='update_cart']").trigger("click");
        });
   </script>
<?php
endif;?>
<?php
}
 // For implementation instructions see: https://aceplugins.com/how-to-add-a-code-snippet/
/**
 * Add quantity field on the shop page.
 */
/**
 * Add quantity field on the shop page.
 */
function ace_shop_page_add_quantity_field() {
	/** @var WC_Product $product */
	$product = wc_get_product( get_the_ID() );?>
	<?php
	if ( ! $product->is_sold_individually() && 'variable' != $product->get_type() && $product->is_purchasable() ) {?>
	<div class="number new"><span class="minus" value="<?php echo esc_attr( $product->get_id() ); ?>">-</span>
	<?php woocommerce_quantity_input( array( 'min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity() ) );
	?>
	<span  class="plus" value="<?php echo esc_attr( $product->get_id() ); ?>">+</span></div><?php
	}
}
add_action( 'woocommerce_after_shop_loop_item', 'ace_shop_page_add_quantity_field', 12 );
/**
 * Add required JavaScript.
 */
function ace_shop_page_quantity_add_to_cart_handler() {
	wc_enqueue_js( '
		$(".woocommerce .products").on("click", ".quantity input", function() {
			return false;
		});
		$(".woocommerce .products").on("change input", ".quantity .qty", function() {
			var add_to_cart_button = $(this).parents(".product").find(".add_to_cart_button");
			// For AJAX add-to-cart actions
			add_to_cart_button.attr("data-quantity", $(this).val());
			// For non-AJAX add-to-cart actions
			add_to_cart_button.attr("href", "?add-to-cart=" + add_to_cart_button.attr("data-product_id") + "&quantity=" + $(this).val());
		});
		// Trigger on Enter press
		$(".woocommerce .products").on("keypress", ".quantity .qty", function(e) {
			if ((e.which||e.keyCode) === 13) {
				$( this ).parents(".product").find(".add_to_cart_button").trigger("click");
			}
		});
	' );
	//if ( ! is_product() && ! is_cart() ) return;
   wc_enqueue_js( "
      $(document).on( 'click', 'span.plus, span.minus', function() {
         var qty = $( this ).parent( '.quantity' ).find( '.qty' ).trigger('click');
         var val = parseFloat(qty.val());
         var max = parseFloat(qty.attr( 'max' ));
         var min = parseFloat(qty.attr( 'min' ));
         var step = parseFloat(qty.attr( 'step' ));
         if ( $( this ).is( '.plus' ) ) {
            if ( max && ( max <= val ) ) {
               qty.val( max ).change();
            } else {
               qty.val( val + step ).change();
            }
         } else {
            if ( min && ( min >= val ) ) {
               qty.val( min ).change();
            } else if ( val > 1 ) {
               qty.val( val - step ).change();
            }
         }
      });
   " );
}
add_action( 'init', 'ace_shop_page_quantity_add_to_cart_handler' );
//Change the 'Billing details' checkout label to 'Contact Information'
function wc_billing_field_strings( $translated_text, $text, $domain ) {
	if(is_checkout()){
	switch ( $translated_text ) {
		case 'Address Book' :
		$translated_text = __( 'Select Address', 'woocommerce' );
		break;
	}
}
	return $translated_text;
}
add_filter( 'gettext', 'wc_billing_field_strings', 20, 3 );
add_filter( 'woocommerce_account_menu_items', 'misha_rename_downloads' );
function misha_rename_downloads( $menu_links ){
	// $menu_links[ 'TAB ID HERE' ] = 'NEW TAB NAME HERE';
	$menu_links[ 'edit-address' ] = 'Your Addresses';
	// unset( $menu_links[ 'downloads' ] ); // Disable Downloads
	return $menu_links;
}
add_action( 'wp_footer', 'ajax_button_text_js_script' );
function ajax_button_text_js_script() {
	if (is_cart()) :
    $text = __('View Cart', 'woocommerce');
    ?>
    <script>
        jQuery(function($) {
            var text = '<?php echo $text; ?>',      $this;
            $(document.body).on('click', '.ajax_add_to_cart', function(event){
                $this = $(this); // Get button jQuery Object and set it in a variable
            });
            $(document.body).on('added_to_cart', function(event,b,data){
                var buttonText = '<span class="add_to_cart_text greenbutton product-is-added">'+text+'</span><i class="cart-icon pe-7s-cart"></i>';
                // Change inner button html (with text) and Change "data-tip" attribute value
                $this.html(buttonText).attr('data-tip',text);
            });
        });
    </script>
    <?php
	endif;
}
add_filter( 'woocommerce_checkout_fields', 'bbloomer_shipping_phone_checkout' );
function bbloomer_shipping_phone_checkout( $fields ) {
   $fields['shipping']['shipping_phone'] = array(
      'label' => 'Phone',
      'type' => 'tel',
      'required' => false,
      'class' => array( 'form-row-wide' ),
      'validate' => array( 'phone' ),
      'autocomplete' => 'tel',
      'priority' => 25,
   );
   return $fields;
}
add_action( 'woocommerce_admin_order_data_after_shipping_address', 'bbloomer_shipping_phone_checkout_display' );
function bbloomer_shipping_phone_checkout_display( $order ){
    echo '<p><b>Shipping Phone:</b> ' . get_post_meta( $order->get_id(), '_shipping_phone', true ) . '</p>';
}
//short code to get the woocommerce recently viewed products
 function custom_track_product_view() {
    if ( ! is_singular( 'product' ) ) {
        return;
    }
   global $post;
    if ( empty( $_COOKIE['woocommerce_recently_viewed'] ) )
        $viewed_products = array();
    else
        $viewed_products = (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] );
    if ( ! in_array( $post->ID, $viewed_products ) ) {
        $viewed_products[] = $post->ID;
    }
    if ( sizeof( $viewed_products ) > 15 ) {
        array_shift( $viewed_products );
    }
   // Store for session only
    wc_setcookie( 'woocommerce_recently_viewed', implode( '|', $viewed_products ) );
}
add_action( 'template_redirect', 'custom_track_product_view', 20 );
 function rc_woocommerce_recently_viewed_products( $atts, $content = null ) {
    // Get shortcode parameters
    extract(shortcode_atts(array(
        "per_page" => '4'
    ), $atts));
    // Get WooCommerce Global
    global $woocommerce , $post;
    // Get recently viewed product cookies data
    $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
    $viewed_products = array_filter( array_map( 'absint', $viewed_products ) );
    // If no data, quit
    if ( empty( $viewed_products ) )
        return __( '', '' );
    // Create the object
    ob_start();
    // Get products per page
    if( !isset( $per_page ) ? $number = 4 : $number = $per_page )
    // Create query arguments array
    $query_args = array(
                    'posts_per_page' => $number,
                    'no_found_rows'  => 1,
                    'post_status'    => 'publish',
                    'post_type'      => 'product',
                    'post__in'       => $viewed_products,
                    'orderby'        => 'rand'
                    );
    // Add meta_query to query args
    $query_args['meta_query'] = array();
    // Check products stock status
    $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
    // Create a new query
    $r = new WP_Query($query_args);
    // ----
    // if (empty($r)) {
    //   return __( 'You have not viewed any product yet!', 'rc_wc_rvp' );
    // }?>
	<div class="woocommerce">
		<div class="ced" data-rows="">
			<h2>Recently viewed products</h2>
				<ul class="products columns-2">
					<?php while ( $r->have_posts() ) : $r->the_post();
					$url= wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
					global $product;?>
					<li <?php wc_product_class( '', $product ); ?>>
						<?php 	do_action( 'woocommerce_before_shop_loop_item' );
						echo '<div class="imagesetion"> <div class="loop-prd-img">';
							// shop page display badges
								$field = get_field_object('badges');
								$colors = $field['value'];
								if( $colors ): ?>
									<?php foreach( $colors as $color ): ?>
										<div class="bagesection"><?php echo $field['choices'][ $color ]; ?></div>
									<?php break;
									endforeach;
								endif;
								$attachment_ids = $product->get_gallery_attachment_ids();
								do_action( 'woocommerce_before_shop_loop_item_title' );
							echo '</div>';
						if(!empty($attachment_ids )){
							echo '<div class="product-thumbs">';
							foreach( array_slice( $attachment_ids, 0,3 ) as $attachment_id ) {
								$thumbnail_url = wp_get_attachment_image_src( $attachment_id, array(400,400) )[0];
								echo '<img class="thumb" src="' . $thumbnail_url . '">';
									break;
							}
							echo '</div> ';
						}
						echo '</div>'; ?>
						<h2 class="woocommerce-loop-product__title"><?php the_title() ?></h2>
						<?php //$product_id	= $product->get_id();
						ob_start();
						$flavour_text = get_field('product_flavour_text',$product_id);
						if ( !empty($flavour_text) ) {?>
								<div class="product-flavour"><?php echo $flavour_text; ?></div>
								<?php } ?>
								<div class="deception">
										<?php the_excerpt(); ?>
									</div>
								<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
									$cat_slug = $catTerms[0]->slug;
									?>
									<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
									<div class="product-category">
										<div class="category-name" style="background-color:<?php echo $cat_color ?>"><?php echo $catTerms[0]->name;?></div>
									</div>
									<div class="price-review">
										<div class="pro-price">
											<div class="product-price">
												<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';
											$product_id = get_the_ID(); // Get the current product ID
											show_sale_percentage_loop();
												?>
											</div>
											</div>
											<?php
												$rating_count = $product->get_rating_count();
												$review_count = $product->get_review_count();
												$average      = $product->get_average_rating();
												if ( $rating_count >= 0 ) : ?>
													<div class="review">
														<a tabindex="0"><div class="rating-count"><?php echo round($average, 1); ?></div>
														<div class="rating-star">
															<span class="star_rating"><span style="width: <?php echo ($average * 20);?>%"></span></span>
														</div>
														<a id="review-part" class="total-reviews" tabindex="0"><?php echo $review_count;?> reviews</a>
													</div>
												<?php endif; ?>
									</div>
									<div class="loop-prd-btn btn-group">
										<div class="sml-add-to-cart-wrap">
										<a href="?add-to-cart=<?php echo esc_attr( $product->id ); ?>" data-quantity="1" class="button dd product_type_simple add_to_cart_button ajax_add_to_cart btn border-btn" data-product_id="<?php echo esc_attr( $product->id ); ?>" data-product_sku="" aria-label="Add “<?php echo esc_attr( $product->name ); ?> to your cart" rel="nofollow">
										Add to cart</a>
									</div>
									<?php $product = wc_get_product( get_the_ID() );
												if ( ! $product->is_sold_individually() && 'variable' != $product->get_type() && $product->is_purchasable() ) {?>
													<div class="number new"><span class="minus" value="<?php echo esc_attr( $product->get_id() ); ?>">-</span>
													<?php woocommerce_quantity_input( array( 'min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity() ) );?>
													<span  class="plus" value="<?php echo esc_attr( $product->get_id() ); ?>">+</span></div><?php
												}?>
						</div>
					</li>
			<?php endwhile; ?>
		</ul>
	</div>
</div>
<?php wp_reset_postdata();
    return ob_get_clean() ;
    // Get clean object
    $content .= ob_get_clean();
    // Return whole content
    return $content;
}
// Register the shortcode
add_shortcode("woocommerce_recently_viewed_products", "rc_woocommerce_recently_viewed_products");
  /**
 * Get the total in words for a WooCommerce order.
 *
 * @param int $order_id The ID of the order.
 * @return string The total in words.
 */
function numberTowords($num)
{
$ones = array(
0 =>"ZERO",
1 => "ONE",
2 => "TWO",
3 => "THREE",
4 => "FOUR",
5 => "FIVE",
6 => "SIX",
7 => "SEVEN",
8 => "EIGHT",
9 => "NINE",
10 => "TEN",
11 => "ELEVEN",
12 => "TWELVE",
13 => "THIRTEEN",
14 => "FOURTEEN",
15 => "FIFTEEN",
16 => "SIXTEEN",
17 => "SEVENTEEN",
18 => "EIGHTEEN",
19 => "NINETEEN",
"014" => "FOURTEEN"
);
$tens = array(
0 => "ZERO",
1 => "TEN",
2 => "TWENTY",
3 => "THIRTY",
4 => "FORTY",
5 => "FIFTY",
6 => "SIXTY",
7 => "SEVENTY",
8 => "EIGHTY",
9 => "NINETY"
);
$hundreds = array(
"HUNDRED",
"THOUSAND",
"MILLION",
"BILLION",
"TRILLION",
"QUARDRILLION"
); /*limit t quadrillion */
$num = number_format($num,2,".",",");
$num_arr = explode(".",$num);
$wholenum = $num_arr[0];
$decnum = $num_arr[1];
$whole_arr = array_reverse(explode(",",$wholenum));
krsort($whole_arr,1);
$rettxt = "";
foreach($whole_arr as $key => $i){
while(substr($i,0,1)=="0")
		$i=substr($i,1,5);
if($i < 20){
/* echo "getting:".$i; */
$rettxt .= $ones[$i];
}elseif($i < 100){
if(substr($i,0,1)!="0")  $rettxt .= $tens[substr($i,0,1)];
if(substr($i,1,1)!="0") $rettxt .= " ".$ones[substr($i,1,1)];
}else{
if(substr($i,0,1)!="0") $rettxt .= $ones[substr($i,0,1)]." ".$hundreds[0];
if(substr($i,1,1)!="0")$rettxt .= " ".$tens[substr($i,1,1)];
if(substr($i,2,1)!="0")$rettxt .= " ".$ones[substr($i,2,1)];
}
if($key > 0){
$rettxt .= " ".$hundreds[$key]." ";
}
}
if($decnum > 0){
$rettxt .= " and ";
if($decnum < 20){
$rettxt .= $ones[$decnum];
}elseif($decnum < 100){
$rettxt .= $tens[substr($decnum,0,1)];
$rettxt .= " ".$ones[substr($decnum,1,1)];
}
}
return $rettxt;
}
/*
 ==================
 Ajax Search
======================
*/
// add the ajax fetch js
add_action( 'wp_footer', 'ajax_fetch' );
function ajax_fetch() {
?>
<script type="text/javascript">
function search_fetch(){
    jQuery.ajax({
        url: '<?php echo admin_url("admin-ajax.php"); ?>',
        type: 'post',
        data: { action: 'data_fetch', keyword: jQuery('#keyword').val() },
        success: function(data) {
            jQuery('#datafetch').html( data );
        }
    });
}
</script>
<?php
}
// the ajax function
add_action('wp_ajax_data_fetch' , 'data_fetch');
add_action('wp_ajax_nopriv_data_fetch','data_fetch');
function data_fetch(){
	global $product,$wpdb;
	$search_txt = $_POST['keyword'];
    $the_query = new WP_Query( array( 'posts_per_page' => 6, 'post_type' => 'publish', 's' => esc_attr( $_POST['keyword'] ),
	'post_type' => array('page','product','product_variation','post','video','guides') ) );
    $the_product = new WP_Query( array( 'posts_per_page' => 6, 'post_type' => 'publish', 's' => esc_attr( $_POST['keyword'] ),
	'post_type' => array('product','product_variation') ) );
	$the_page= new WP_Query( array( 'posts_per_page' => 6, 'post_type' => 'publish', 's' => esc_attr( $_POST['keyword'] ),
		'post_type' => array('page') ) );
	$the_post= new WP_Query( array( 'posts_per_page' => 6, 'post_type' => 'publish', 's' => esc_attr( $_POST['keyword'] ),
			'post_type' => array('post') ) );
	$the_video= new WP_Query( array( 'posts_per_page' => 6, 'post_type' => 'publish', 's' => esc_attr( $_POST['keyword'] ),
		'post_type' => array('video') ) );
	$the_guides= new WP_Query( array( 'posts_per_page' => 6, 'post_type' => 'publish', 's' => esc_attr( $_POST['keyword'] ),
		'post_type' => array('guides') ) );
	if( $the_query->have_posts() ) :
		echo '<div class="search_box">';
		if( $the_product->have_posts() ) {
		echo '<div class="combination_box"> 	<h2>Products</h2>';
			while( $the_product->have_posts() ): $the_product->the_post();?>
				<div class="image_thumb"><a href="<?php echo esc_url( post_permalink() ); ?>"><?php the_post_thumbnail();?>
				<?php the_title();?></a>
				</div>
		<?php endwhile;
		echo '</div>';}
		$args = array(
				'taxonomy'      => array( 'product_cat' ), // taxonomy name
				'orderby'       => 'id',
				'order'         => 'ASC',
				'hide_empty'    => true,
				'fields'        => 'all',
				'name__like'    => $search_txt
			);
			$terms = get_terms( $args );
			$count = count($terms);
			foreach ($terms as $term) {
				$searched_cat_id= $term->term_id;
				$searched_cat_name= $term->name;
				$searched_cat_slug= $term->slug;
				$searched_cat_link= get_term_link($searched_cat_id,'product_cat');
							   echo '<div class="srchListWrap ">';
							   echo "<h2>Categories</h2>";
							   echo '<a class="shpByLink" href="' . $searched_cat_link . '">' . $searched_cat_name . '</a>';
							   $cat_count++;
						   }
						 	if( $the_post->have_posts() ) {
				echo '<div class="combination_box"> 	<h2>Blogs</h2>';
				while( $the_post->have_posts() ): $the_post->the_post();?>
					<div class="image_thumb"><a href="<?php echo esc_url( post_permalink() ); ?>"><?php the_post_thumbnail();?>
					<?php the_title();?></a>
					</div>
				<?php	endwhile; echo '</div>'; }
					if( $the_video->have_posts() ) {
						global $post;
					echo '<div class="combination_box"> 	<h2>Videos</h2>';
					while( $the_video->have_posts() ): $the_video->the_post();?>
					<?php $chapname = get_the_terms($post->ID, 'video_cat');?>
						<div class="image_thumb"><a href="<?php echo esc_url( post_permalink() ); ?>">
									<?php $video = get_field('video');?>
						        <?php if(!empty( $video ) ): ?>
						            <img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
						        <?php endif?>
						<?php the_title();?></a></div>
					<?php	endwhile; }
		 if( $the_guides->have_posts() ) {
			echo '<div class="combination_box"> 	<h2>Health Guides</h2>';
			while( $the_guides->have_posts() ): $the_guides->the_post();?>
			<div class="image_thumb"><a href="<?php echo esc_url( post_permalink() ); ?>"><?php the_post_thumbnail();?>
				<?php the_title();?></a>
			</div>
			<?php	endwhile;
		echo '</div>'; }
		 	if( $the_page->have_posts() ) {
			echo '<div class="combination_box"> 	<h2>Page</h2>';
				while( $the_page->have_posts() ): $the_page->the_post();?>
					<div class="image_thumb"><a href="<?php echo esc_url( post_permalink() ); ?>"><?php the_post_thumbnail();?>
						<?php the_title();?></a>
					</div>
				<?php	endwhile;
 	echo '</div>';	}
       echo '</div>';
	   wp_reset_postdata();
	else:
		echo "No result found";
    endif;
die();
}
function post_type_include( $query ) {
    if ( $query->is_main_query() && $query->is_search() && ! is_admin() ) {
        $query->set( 'post_type', array( 'post','page', 'product' ) );
    }
}
add_action( 'pre_get_posts', 'post_type_include' );
add_filter( 'posts_search', 'include_password_posts_in_search' );
function include_password_posts_in_search( $search ) {
    global $wpdb;
    if( !is_user_logged_in() ) {
        $pattern = " AND ({$wpdb->prefix}posts.post_password = '')";
        $search = str_replace( $pattern, '', $search );
    }
    return $search;
}
// Add COD discount
function add_cod_discount($cart) {
    if (is_admin() && !defined('DOING_AJAX'))
        return;
		$discount_l= get_field('cod_discount','option');
$discount_label= get_field('cod_label', 'option');
$discount_price= get_field('cod_discount_price', 'option');
if($discount_l == true){
    $chosen_payment_method = WC()->session->get('chosen_payment_method');
    if ($chosen_payment_method === 'razorpay') {
        $discount_amount = $discount_price; // Set your desired discount amount here
        $cart->add_fee(__($discount_label , 'woocommerce'), -   $discount_amount);
    }
}
}
add_action('woocommerce_cart_calculate_fees', 'add_cod_discount');
function dartcreations_remove_version() {
 return '';
} add_filter('the_generator', 'dartcreations_remove_version');
remove_action('wp_head', 'wp_generator');
add_action('woocommerce_admin_order_totals_after_tax', 'custom_admin_order_totals_after_tax', 10, 1 );
function custom_admin_order_totals_after_tax( $order_id ) {
    ?>
        <tr>
					<?php 	$discount_l= get_field('cod_discount','option');
							$discount_label= get_field('cod_label', 'option');
							$discount_price= get_field('cod_discount_price', 'option');  ?>
					<td class="label">Pre Paid Discount</td>
					<td width="1%"></td>
					<td class="total"><span class="woocommerce-Price-amount amount"><?php echo '- '. $discount_price;?></span></td>
				</tr>
    <?php
}
function show_sale_percentage_loop() {
	global $product;
	if ( ! $product->is_on_sale() ) return;
	if ( $product->is_type( 'simple' ) ) {
	   $max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;
	} elseif ( $product->is_type( 'variable' ) ) {
	   $max_percentage = 0;
	   foreach ( $product->get_children() as $child_id ) {
		  $variation = wc_get_product( $child_id );
		  $price = $variation->get_regular_price();
		  $sale = $variation->get_sale_price();
		  if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
		  if ( $percentage > $max_percentage ) {
			 $max_percentage = $percentage;
		  }
	   }
	}
    $image1_id = 3159; // Replace with your image attachment ID
	if ( $max_percentage > 0 ) echo "<div class='product-offter new'>" . round( $max_percentage ) . "% OFF</div>";
 }

function preload_images() {
    $image1_id = 3159; // Replace with your image attachment ID
    $image2_id = 1349; // Replace with your image attachment ID

    echo '
    <link rel="preload" href="' . wp_get_attachment_url($image1_id) . '" as="image">
    <link rel="preload" href="' . wp_get_attachment_url($image2_id) . '" as="image">
    ';
}
add_action('wp_head', 'preload_images');

// Set product quantity to 0
function set_product_quantity_to_zero( $product_id ) {
	update_post_meta( $product_id, '_stock', 0 );
	update_post_meta( $product_id, '_stock_status', 'outofstock' );
 }

 // Call the function and pass the product ID as a parameter
 set_product_quantity_to_zero( $product_id ); // Replace 123 with the actual product ID

// Change Add to Cart text on single product page when quantity is 0
add_filter( 'woocommerce_product_single_add_to_cart_text', 'custom_cart_button_text_when_zero_quantity', 10, 2 );
function custom_cart_button_text_when_zero_quantity( $text, $product ) {
    $qty = isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : 1;
    if ( $qty == 0 ) {
        return __('Product is out of stock', 'woocommerce');
    } else {
        return $text;
    }
}
// Function to generate the WhatsApp button HTML
function custom_whatsapp_button_shortcode($atts) {
    $atts = shortcode_atts(
        array(
            'number' => '', // WhatsApp number in international format without + or spaces
            'message' => 'Hello, I would like to chat with you.',
        ),
        $atts,
        'whatsapp_button'
    );

    if (empty($atts['number'])) {
        return ''; // Return nothing if no number is provided
    }

    $whatsapp_url = 'https://api.whatsapp.com/send?phone=' . esc_attr($atts['number']) . '&text=' . urlencode($atts['message']);

    return '<a class="custom-whatsapp-button" href="' . esc_url($whatsapp_url) . '" target="_blank"><i class="fa-brands fa-whatsapp"></i></a>';
}

// Register the shortcode
add_shortcode('whatsapp_button', 'custom_whatsapp_button_shortcode');

// Enqueue Font Awesome and custom styles
function custom_whatsapp_button_styles() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css');
    wp_enqueue_style('custom-whatsapp-button-styles', get_template_directory_uri() . '/custom-whatsapp-button-style.css');
}
add_action('wp_enqueue_scripts', 'custom_whatsapp_button_styles');
