<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Zigcy Lite
 */
get_header();
//$zigcy_lite_archive_post_layout_sidebars = get_theme_mod('zigcy_lite_archive_post_layout_sidebars','right-sidebar-enabled');
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-content">
		<div class="video-category-menu">
			<div  class="container">
				<div class="category-menu">video category</div>
				<ul>
					<li><a href="<?php echo site_url('video/');?>" class="active">All Videos</a></li>
					<?php
							$cat_style = '';
							$terms = get_terms( array(
							'taxonomy' => 'video_cat',
							'hide_empty' => false,
							'orderby' => 'ID',
							'order' => 'ASC'
							) ); // Get Terms
	                       // print_r($terms);
							foreach ($terms as $key => $value)
							{
								//$metaterms = get_term_meta($value->term_id);
								$cat_color= get_field('title_content_color',$value);
							?>
							<li>
								<a class="catbg<?php echo $key; ?>" href="<?php echo get_category_link($value->term_id); ?>" style="color:<?php echo $cat_color; ?>; border: 1px solid <?php echo $cat_color; ?>;">
							        <?php echo $value->name; ?>
								</a>
								<?php $cat_style .=  ' .video-category-menu ul li a.catbg'.$key.':hover{background: '.$cat_color.'!important; color: #fff !important;border: 1px solid '.$cat_color.' !important;} ';?>
							</li>
					      <?php } ?>
				</ul>
			</div>
			<style><?php echo $cat_style;?></style>
		</div>
		<div class="container">
			<div class="featured-videos mt-60">
				<h2 class="section-heading">Featured Videos</h2>
				<div class="featured-videos-slider">
					<div class="carousel coins-carousel">
					<?php
						$arg = array(
						'post_type' => 'video',
						'post_status' => 'publish',
						'posts_per_page'    => 10,
						//'order'=>'desc'
						);
						$postgn = new WP_Query($arg);?>
						<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
						<?php $chapname = get_the_terms($post->ID, 'video_cat');?>
		 				<div class="carousel-item">
							<a href="<?php echo get_the_permalink(); ?>">
								<div class="img-box">
									<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/play-btn.png" class="play-btn" alt="play btn">
									<?php $video = get_field('video');?>
						        <?php if(!empty( $video ) ): ?>
						            <img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
						        <?php endif?>
								</div>
							<div class="cnt">
								<?php $cat_color= get_field('title_content_color',$chapname[0]);
                      if(empty($cat_color)){
                      }else{
								?>
								<div class="category" style="background: <?php echo $cat_color; ?>;"><?php echo $chapname[0]->name; ?></div>
							<?php } ?>
								<h3><?php the_title(); ?></h3>
								<p><?php echo substr(strip_tags($post->post_content), 0, 75);?></p>
								<div class="read-more">Watch Now</div>
							</div>
							</a>
						</div>
           <?php endwhile;
            wp_reset_postdata();?>
					</div>
				</div>
			</div><!---->
             <?php
				$terms = get_categories(
					array(
						'parent' => 0,
						'taxonomy' => 'video_cat',
					)
				);
				foreach ($terms as $key => $value)
				{
					?>
					<?php $cat_color = get_field('title_content_color', $value); ?>
					<div class="management-slider mt-60">
					    <?php
					    $args = array('post_type' => 'video',
					    	            'orderby'   => 'ID',
                            'order' => 'DESC',
							'tax_query' => array(
					        array(
					              'taxonomy' => 'video_cat',
					              'field' => 'slug',
					              'terms' => $value->slug,
							),
					      ),
					    );
					    $loop = new WP_Query($args);
					    if($loop->have_posts()) { ?>
							<h2 class="section-title js-scroll fade-in-bottom">
								<?php echo $value->name; ?><span style="background-color:<?php echo $cat_color ?>"></span>
							</h2>
							<div class="management_slider mt-60 pb-60px">
							<?php
							while($loop->have_posts()) : $loop->the_post(); ?>
								<div>
									<div class="slide-box">
										<div class="post-image">
											<a href="<?php echo get_permalink(get_the_ID()); ?>">
											<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/play-btn.png" class="play-btn" alt="play btn">
											<?php $video = get_field('video');?>
									<?php if(!empty( $video ) ): ?>
											<img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
										</a>
									<?php endif?>
										</div>
										<div class="cnt-box">
											<div class="post-review">
												<div class="post-view">
													<span>1.8k Likes</span> <span>13.3k views</span>
												</div>
												<div class="post-share">
													<a href="#">
														<i class="icons share"></i>
													</a>
												</div>
											</div>
											<a style="color:<?php echo $cat_color; ?>" href="<?php echo get_permalink(get_the_ID()); ?>">
											<div class="post-title" ><?php the_title(); ?></div>
											</a>
											<div class="post-content"><?php echo substr(strip_tags($post->post_content), 0, 98);?></div>
											<a class="read-more" href="<?php echo get_permalink(get_the_ID()); ?>">Watch Now</a>
										</div>
									</div>
								</div>
							<?php
							endwhile;
							wp_reset_postdata();?>
							</div><!-- .management_slider -->
							<div class="align-center">
								<a class="btn btn-black view-all" href="<?php echo get_term_link($value->slug, 'video_cat');?>"><span>VIEW ALL</span></a>
							</div>
						<?php }	?>
					</div><!-- .management-slider -->
				<?php } ?>
		</div>
	</div><!-- .entry-content -->
 <script type = "text/javascript" src = "https://code.jquery.com/jquery-2.1.1.min.js"></script>
<script>
  $(document).ready(function () {
      $('.carousel').carousel();
  });
$('.carousel').carousel({
  onCycleTo: function(ele, dragged) {
      Session.set('selectedCurr', $('.coins-carousel > .active')[0].dataset.coin);
  }
});
</script>
</article><!-- #post-<?php the_ID(); ?> -->
<?php
get_footer();
