<?php

/**
 * Created by PhpStorm.
 * User: MSI
 * Date: 21/08/2015
 * Time: 9:45 SA
 */

use API\CMS\TourCMS;
use API\Validation\Validation;
use DeliciousBrains\WPMDB\Common\Replace;
use DeliciousBrains\WPMDB\Container\PhpOption\Option;

use function DeliciousBrains\WPMDB\Container\DI\value;
use function PHPSTORM_META\elementType;

define('TOURIST_DOMAIN', 'touristmkp');
define('TOURIST_DIR', __DIR__);

function traveler_childtheme_woocommerce_support()
{
    add_theme_support('woocommerce');
}
add_action('after_setup_theme', 'traveler_childtheme_woocommerce_support');

add_action('wp_enqueue_scripts', 'enqueue_parent_styles', 20);
function enqueue_parent_styles()
{
    $ver = round(time(), 3);
    //$ver = '1.201';
    if (wp_style_is('roboto-font', 'enqueued')) {
        wp_dequeue_style('roboto-font');
    }
    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
    if (is_singular('location')) {

        wp_enqueue_script('location', get_stylesheet_directory_uri() . '/js/location.js', array('jquery'), $ver, true);
        wp_localize_script('location', 'ajax_location', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
        wp_enqueue_script('location');

        wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/css/custom-style.css', array(), $ver);
        wp_enqueue_style('Header', get_stylesheet_directory_uri() . '/css/header.css', array(), $ver);
        wp_enqueue_style('Footer', get_stylesheet_directory_uri() . '/css/footer.css', array(), $ver);
        wp_enqueue_style('location', get_stylesheet_directory_uri() . '/css/location.css', array(), $ver); 
        wp_enqueue_style('touristml_style', get_stylesheet_directory_uri() . '/css/touristml-style.css', array(), $ver);
    } else if (is_singular('st_tours')) {


        wp_enqueue_script('jquery-ui-datepicker');
        wp_enqueue_script('api_calender', get_stylesheet_directory_uri() . '/calender-book/script.js', array('jquery'), $ver, true);
        wp_localize_script('api_calender', 'ajax_calender', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'currency' => TravelHelper::get_current_currency('symbol')
        ));

        // wp_enqueue_script('dataTables', 'https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js', array(), $ver, true);
        wp_enqueue_script('tours', get_stylesheet_directory_uri() . '/js/tours.js', array('jquery'), $ver, true);
        wp_enqueue_script('lightbox-js', get_stylesheet_directory_uri() . '/js/lightbox.js', array(), $ver, true);
        wp_localize_script('tours', 'ajax_tours', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
        wp_enqueue_script('tours');

        wp_enqueue_script('slick', get_stylesheet_directory_uri() . '/js/slick.min.js', array(), $ver, true);
        //    wp_enqueue_script('owl-carousel', get_stylesheet_directory_uri() . '/js/owl.carousel.min.js', array(), $ver, true);
        wp_enqueue_script('mapbox-js', get_stylesheet_directory_uri() . '/js/mapbox-gl.js', array(), $ver, true);
        wp_enqueue_script('query-js', get_stylesheet_directory_uri() . '/js/query.js', array(), $ver, true);
        wp_enqueue_script('woo-booking', get_stylesheet_directory_uri() . '/js/woo-booking.js', array(), $ver, true);
        wp_enqueue_script('share-js', get_stylesheet_directory_uri() . '/js/referral_link.js', array(), $ver, true);
        wp_enqueue_script('operator', get_stylesheet_directory_uri() . '/js/operator.js', array(), $ver, true);
        wp_localize_script('operator', 'ajax_operator', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'current' => TravelHelper::get_current_currency('symbol')
        ));
        wp_enqueue_script('social_share', get_stylesheet_directory_uri() . '/js/book.js', array('jquery'), $ver, true);
        wp_enqueue_script('Customize', get_stylesheet_directory_uri() . '/js/customize.js', array(), $ver, true);
        wp_localize_script('social_share', 'ajax_object', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
        wp_enqueue_script('social_share');
        // wp_enqueue_style('Header', get_stylesheet_directory_uri() . '/css/header.css', array(), $ver);
        // wp_enqueue_style('Footer', get_stylesheet_directory_uri() . '/css/footer.css', array(), $ver);
        //   wp_enqueue_style('single-calender', get_stylesheet_directory_uri() . '/css/single-calender.css', array(), $ver);
        wp_enqueue_style('home-css', get_stylesheet_directory_uri() . '/css/home.css', array(), true);
        wp_enqueue_style('child-style', get_stylesheet_uri());
        wp_enqueue_style('mapbox-gl-css', get_stylesheet_directory_uri() . '/css/mapbox-gl.css', array(), true);
        wp_enqueue_style('owl-carousel-css', get_stylesheet_directory_uri() . '/css/owl.carousel.css', array(), true);
        wp_enqueue_style('Header', get_stylesheet_directory_uri() . '/css/header.css', array(), $ver);
        wp_enqueue_style('Footer', get_stylesheet_directory_uri() . '/css/footer.css', array(), $ver);
        wp_enqueue_style('Custimize-style', get_stylesheet_directory_uri() . '/css/danny-style.css', array(), $ver);
        wp_enqueue_style('v2-style', get_stylesheet_directory_uri() . '/v2/css/style.css', array(), true);
        wp_enqueue_style('touristml_style', get_stylesheet_directory_uri() . '/css/touristml-style.css', array(), $ver);
        wp_enqueue_style('style-login-css', get_stylesheet_directory_uri() . '/css/style-login.css', array(), true);
        wp_enqueue_style('share-button-css', get_stylesheet_directory_uri() . '/css/share-button-style.css', array(), true);
        wp_enqueue_style('lightbox-css', get_stylesheet_directory_uri() . '/css/lightbox.css', array(), true);
        wp_enqueue_style('manage-booking-css', get_stylesheet_directory_uri() . '/css/manage-booking.css', array(), true);
        wp_enqueue_style('operator', get_stylesheet_directory_uri() . '/css/operator.css', array(), $ver);
        wp_enqueue_style('book', get_stylesheet_directory_uri() . '/css/book.css', array(), $ver);
    } else {
        wp_enqueue_script('dataTables', 'https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js', array(), $ver, true);
        wp_enqueue_script('slick', get_stylesheet_directory_uri() . '/js/slick.min.js', array(), $ver, true);
        wp_enqueue_script('lightbox-js', get_stylesheet_directory_uri() . '/js/lightbox.js', array(), $ver, true);
        wp_enqueue_script('owl-carousel', get_stylesheet_directory_uri() . '/js/owl.carousel.min.js', array(), $ver, true);
        wp_enqueue_script('mapbox-js', get_stylesheet_directory_uri() . '/js/mapbox-gl.js', array(), $ver, true);
        wp_enqueue_script('query-js', get_stylesheet_directory_uri() . '/js/query.js', array(), $ver, true);
        wp_enqueue_script('woo-booking', get_stylesheet_directory_uri() . '/js/woo-booking.js', array(), $ver, true);
        wp_enqueue_script('share-js', get_stylesheet_directory_uri() . '/js/referral_link.js', array(), $ver, true);
        wp_enqueue_script('operator', get_stylesheet_directory_uri() . '/js/operator.js', array(), round(time(), 3), true);
        wp_localize_script('operator', 'ajax_operator', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'current' => TravelHelper::get_current_currency('symbol')
        ));
        wp_enqueue_script('bokun', get_stylesheet_directory_uri() . '/js/bokun.js', array(), $ver, true);
        wp_localize_script('bokun', 'ajax_bokun', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));

        wp_enqueue_script('intlTelInput-js', get_stylesheet_directory_uri() . '/js/intlTelInput.js', array(), $ver, true);
        wp_enqueue_script('utils-js', get_stylesheet_directory_uri() . '/js/utils.js', array(), $ver, true);
        wp_enqueue_script('phone_number', get_stylesheet_directory_uri() . '/js/phone_number.js', array('jquery'), $ver, true);
        wp_enqueue_script('Customize', get_stylesheet_directory_uri() . '/js/customize.js', array(), $ver, true);
        wp_localize_script('social_share', 'ajax_object', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
        wp_enqueue_script('social_share');

        wp_enqueue_style('single-calender', get_stylesheet_directory_uri() . '/css/single-calender.css', array(), $ver);
        wp_enqueue_style('dataTables', 'https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css', array(), true);
        wp_enqueue_style('home-css', get_stylesheet_directory_uri() . '/css/home.css', array(), true);
        wp_enqueue_style('child-style', get_stylesheet_uri());
        wp_enqueue_style('mapbox-gl-css', get_stylesheet_directory_uri() . '/css/mapbox-gl.css', array(), true);
        wp_enqueue_style('slick', get_stylesheet_directory_uri() . '/css/slick.css', array(), true);
        wp_enqueue_style('book', get_stylesheet_directory_uri() . '/css/book.css', array(), $ver);
        wp_enqueue_style('owl-carousel-css', get_stylesheet_directory_uri() . '/css/owl.carousel.css', array(), true);
        wp_enqueue_style('Header', get_stylesheet_directory_uri() . '/css/header.css', array(), $ver);
        wp_enqueue_style('Footer', get_stylesheet_directory_uri() . '/css/footer.css', array(), $ver);
        wp_enqueue_style('Custimize-style', get_stylesheet_directory_uri() . '/css/danny-style.css', array(), $ver);
        wp_enqueue_style('checkout-style', get_stylesheet_directory_uri() . '/css/checkout.css', array(), $ver);
        wp_enqueue_style('account-style', get_stylesheet_directory_uri() . '/css/account.css', array(), $ver);
        wp_enqueue_style('v2-style', get_stylesheet_directory_uri() . '/v2/css/style.css', array(), true);
        wp_enqueue_style('touristml_style', get_stylesheet_directory_uri() . '/css/touristml-style.css', array(), $ver);
        wp_enqueue_style('share-button-css', get_stylesheet_directory_uri() . '/css/share-button-style.css', array(), true);
        wp_enqueue_style('contact-page', get_stylesheet_directory_uri() . '/css/contact.css', array(), $ver);
        wp_enqueue_style('style-login-css', get_stylesheet_directory_uri() . '/css/style-login.css', array(), true);
        wp_enqueue_style('intlTelInput-css', get_stylesheet_directory_uri() . '/css/intlTelInput.css', array(), true);
        wp_enqueue_style('lightbox-css', get_stylesheet_directory_uri() . '/css/lightbox.css', array(), true);
        wp_enqueue_style('manage-booking-css', get_stylesheet_directory_uri() . '/css/manage-booking.css', array(), true);
        wp_enqueue_style('operator', get_stylesheet_directory_uri() . '/css/operator.css', array(), $ver);
        wp_enqueue_style('location', get_stylesheet_directory_uri() . '/css/location.css', array(), $ver);
    }
    if (is_tax('tour_attraction') || is_tax('st_tour_type')) {
        wp_enqueue_script('location', get_stylesheet_directory_uri() . '/js/location.js', array('jquery'), $ver, true);
        wp_localize_script('location', 'ajax_location', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
        wp_enqueue_script('location');
    }
    wp_enqueue_script('menujs', get_stylesheet_directory_uri() . '/js/menujs.js', array('jquery'), $ver, true);
    wp_localize_script('menujs', 'menu_ajax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
    ));
         wp_enqueue_style('custom-style-nmg', get_stylesheet_directory_uri() . '/css/custom-style.css', array(), $ver);

}
add_action('admin_enqueue_scripts', 'load_admin_style');
function load_admin_style()
{
    wp_enqueue_script('admin-js-aff', get_stylesheet_directory_uri() . '/js/admin.js');
    wp_localize_script('admin-js-aff', 'ajax_object', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'search' => admin_url('admin-ajax.php'),
    ));
    wp_enqueue_style('admin-child-css', get_stylesheet_directory_uri() . '/css/admin-style.css', array(), true);
}

//remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
//remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);
// remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
// remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
// remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
// Function to check if page slug already exists
function the_slug_exists($post_name)
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'posts';
    if ($wpdb->get_row("SELECT post_name FROM $table_name WHERE post_name = '" . $post_name . "' AND post_type = 'page'", 'ARRAY_A')) {
        return 'yes';
    } else {
        return 'no';
    }
}
function touristml_widgets_init()
{
    register_sidebar(
        array(
            'name'          => 'Custom Languages',
            'id'            => 'custom_languages',
            'before_widget' => '<div class="widget %2$s id =%1$s">',
            'after_widget'  => '</div>'
        )
    );
}
add_action('widgets_init', 'touristml_widgets_init');

include_once get_stylesheet_directory() . '/API/update/index.php';

include_once get_stylesheet_directory() . '/inc/custom_function.php';
include_once get_stylesheet_directory() . '/inc/channel_manager_integration.php';
include_once get_stylesheet_directory() . '/inc/referral_link.php';
include_once get_stylesheet_directory() . '/inc/affiliate_wallet.php';
include_once get_stylesheet_directory() . '/inc/affiliates_commission.php';
include_once get_stylesheet_directory() . '/inc/customize.php';
include_once get_stylesheet_directory() . '/inc/telegram_notification.php';
include_once get_stylesheet_directory() . '/inc/posts_type.php';
// include_once get_stylesheet_directory() . '/inc/cancell_order.php';
include_once get_stylesheet_directory() . '/short_code/seach.php';
include_once get_stylesheet_directory() . '/API/API.php';
include_once get_stylesheet_directory() . '/API/setting.php';
include_once get_stylesheet_directory() . '/API/list/control_bokun.php';
include_once get_stylesheet_directory() . '/inc/ticket_order.php';
include_once get_stylesheet_directory() . '/woo-order/hook_cart.php';
include_once get_stylesheet_directory() . '/woo-order/orders-table.php';
include_once get_stylesheet_directory() . '/woocommerce/hook/cancelled.php';
include_once get_stylesheet_directory() . '/calender-book/call_api.php';

include_once get_stylesheet_directory() . '/taxonomys/tour_attraction.php';

include_once get_stylesheet_directory() . '/inc/tool_statistical.php';
include_once get_stylesheet_directory() . '/inc/custom_home.php';
if (in_array('js_composer/js_composer.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    include_once get_stylesheet_directory() . '/inc/vc_shortcode.php';
}
add_filter('whatsappme_whastapp_web', '__return_true');

if (!is_admin()) {
    require_once(ABSPATH . 'wp-admin/includes/post.php');
}

function fareharbor_get_availability_tour_frontend($args)
{
    $currecy = TravelHelper::get_current_currency('name');
    $currecy = strtolower($currecy);
    if ($currecy != 'eur') return false;
    $product_code = get_post_meta($args['id'], 'fareharbor_product_code', true);
    $shortname = get_post_meta($args['id'], 'fareharbor_company_shortname', true);
    $args['parames'] = [
        'shortname' => $shortname,
        'product_code' => $product_code,
        'base' => 'availabilitie'
    ];
    $far = new Fareharbor('GET', $args);
    $far_remote = json_decode($far->far_remote()['body'], true);
    $availabilities = $far->availabilities($far_remote);
    return $availabilities;
}
function experience_get_availability_tour_frontend($args)
{
    session_start();
    $experienceId = get_post_meta($args['id'], 'experience_product_id', true);
    $args['id'] = $experienceId;
    $api = new Experience('GET', ['id' => $args['id']]);
    $params = [
        'type'      => 'getAvailable',
        'id'        => $args['id'],
        'startTime' => $args['start'],
        'endTime'   => $args['end'],
    ];
    $get_available = $api->get_data($params);
    if (is_array($get_available) && $get_available != null) :
        foreach ($get_available['data'] as $key => $value) :
            foreach ($value['tickets'] as $key => $ticket) :
                # code...
                $date = str_replace(['.', "'"], ' ', $ticket['startDate']);
                $date = strtotime($date);
                $date = date('Y-m-d', $date);
                $date = strtotime($date);
                if ($ticket['available_quantity'] != 0 || $ticket['available_quantity'] == null) :
                    $array[$date]['list'] = [
                        'id'                => $value['productId'],
                        'maxUnitsRemaining' => $ticket['available_quantity'],
                    ];
                    $availableDate = strtotime($ticket['startDateTime']);
                    $array[$date][$value['productId']][$availableDate] = [
                        'startDate'             => $ticket['startDate'],
                        'endDate'               => $ticket['endDate'],
                        'startTime'             => $ticket['startTime'],
                        'endTime'               => $ticket['endTime'],
                        'startDateTime'         => $ticket['startDateTime'],
                        'endDateTime'           => $ticket['endDateTime'],
                    ];
                    $array[$date][$value['productId']]['units'][$ticket['id']] = [
                        'idTicket'          => $ticket['id'],
                        'min_quantity'      => $ticket['min_quantity'],
                        'max_quantity'      => $ticket['max_quantity'],
                        'price'             => $ticket['price']['amount'],
                        'idUnits'           => $ticket['product_ticket_type_id'],
                        'itemId'            => $value['itemId'],
                    ];
                endif;
            endforeach;
        endforeach;

        return $array;
    endif;
}

function pluralo_get_availability_tour_frontend($args)
{
    session_start();
    $pluraloId = get_post_meta($args['id'], 'pluralo_product_id', true);
    $api = new Pluralo('GET', '');
    $get_available = $api->get_available($pluraloId, $args['start'], $args['end']);
    if (is_array($get_available) && $get_available != null) :
        $get_events = $get_available['events'];
        foreach ($get_events as $key => $value) {
            # code...
            $date = str_replace(['.', "'"], ' ', $value['start']);
            $date = strtotime($date);
            $date = date('Y-m-d', $date);
            $date = strtotime($date);
            $array[$date]['list'][$value['id']] = [
                'id'                => $value['id'],
                'quantityAvailable' => $value['quantityAvailable']
            ];
            $availableDate = strtotime($value['start']);
            $array[$date][$value['id']][$availableDate] = [
                'id'                => $value['id'],
                'start'             => date('H:i:s', $availableDate),
                'end'               => $value['end'],
            ];
            $rates = $value['eventGenderPrices'];
            $i = 0;
            do {
                $type = $rates[$i]['genderPriceType'];
                $rateTitle = $rates[$i]['audienceTypeDescription'];
                if ($type == 1) :
                    $array[$date]['type'] = [
                        'type'          => $type,
                        'defaultPrice'  => $rates[0]['grossprice'],
                    ];
                endif;
                if ($rateTitle != null) :
                    if ($rateTitle == 'Adult') :
                        $rateTitleSlug = 'adult-unit';
                    else:
                        $rateTitleSlug = sanitize_title($rateTitle);
                    endif;
                    $array[$date][$value['id']]['rates'][$rates[$i]['id']] = [
                        'id'                => $rates[$i]['id'],
                        'title'             => $rateTitle,
                        'titleSlug'         => $rateTitleSlug,
                        'type'              => $type,
                        'restrictions'      => $rates[$i]['audienceTypeLabel'],
                        'price'             => $rates[$i]['grossprice'],
                    ];
                endif;
                $i++;
            } while ($i < count($rates));
        }
        return $array;
    endif;
}
/**
 * This is function 
 */
function _get_availability_tour_frontend()
{
    $product_id = get_post_meta($_POST['tour_id'], 'product_id', true);
    if ($product_id != false) :
        $meta_key = get_post_meta($product_id, 'external_bookings_manager_name', true);
        $check_in  = STInput::request('start', '');
        $check_out = STInput::request('end', '');
        $dateRanges = [];
        for ($i = strtotime($check_in); $i <= strtotime($check_out); $i = strtotime('+1 day', $i)) {
            $dateRanges[strtotime(date("Y-m-d", $i))] = date("Y-m-d", $i);
        }
        $args = [
            'id'    => $product_id,
            'start' => $check_in,
            'end'   => $check_out
        ];
        $current_moth = date('Y-m', strtotime($check_in . ('+15 days')));

        $array_api = [];
        $availability = WC()->session->get('availability_' . $product_id);
        if (is_array($availability)) :
            if (isset($availability['availability'][strtotime($current_moth)])) :
                $array_api = $availability['availability'][strtotime($current_moth)];
            else :
                $function = $meta_key . '_get_availability_tour_frontend';
                $array_api = $function($args);
                $availability['availability'][strtotime($current_moth)] = $array_api;
                WC()->session->set('availability_' . $product_id, $availability);
            endif;
        else :
            $function = $meta_key . '_get_availability_tour_frontend';
            $array_api = $function($args);
            WC()->session->set('availability_' . $product_id, [
                'availability' => [
                    strtotime($current_moth) => $array_api
                ],
                'meta_key' => $meta_key,
                'start' => $check_in,
                'end' => $check_out,
                'id' => $product_id
            ]);
        endif;
        $array = availability_switch($meta_key, $dateRanges, $array_api);
        echo json_encode(['events' => $array]);
        exit();
    endif;
}

/**
 * Set switch get list api
 */
function availability_switch($meta_key, $dateRanges, $array_api)
{
    $array = [];
    switch ($meta_key):
        case 'fareharbor':
            foreach ($dateRanges as $date) :
                if (isset($array_api[strtotime($date)])) :
                    $array[] = [
                        'date' =>  $date,
                        'day' =>  date('d', strtotime($date)),
                        'event' => $array_api[strtotime($date)][0]['event'] .
                            '<span id="list_' . date("dmY", strtotime($date)) . '" >' . json_encode($array_api[strtotime($date)]['list']) . '</span>' .
                            '<span id="activity_id' . date("dmY", strtotime($date)) . '">' . $array_api[strtotime($date)]['activityId'] . '</span>' .
                            '<span id="date_json_data' . date("dmY", strtotime($date)) . '" style= "display: none">'
                            . json_encode($array_api[strtotime($date)]['list']) .
                            '</span>' .
                            '<span id="time' . date("dmY", strtotime($date)) . '" style= "display: none">'
                            . json_encode($array_api[strtotime($date)]['time']) .
                            '</span>',
                        'start' =>  $date,
                        'status' =>  "disable",
                    ];
                else :
                    $array[] = calendar_available($date);
                endif;
            endforeach;
            break;
        default:
            $array = set_availability($dateRanges, $array_api, $meta_key . '_list');
            break;
    endswitch;
    return $array;
}

/**
 * This is function set availability api by date
 * 
 * @param array list price by from
 * @param array list data api availability
 * @param string class style name api
 * 
 * @return array
 */
function set_availability($dateRanges, $array_api, $api_name)
{
    $array = [];
    // Check list date and set data
    foreach ($dateRanges as $date) :
        if (isset($array_api[strtotime($date)])) :
            $array[] = [
                'date' =>  $date,
                'day' =>  date('d', strtotime($date)),
                'event' => $array_api[strtotime($date)][0]['event'] .
                    '<span class="' . $api_name . '" id="list_' . date("dmY", strtotime($date)) . '" >' . json_encode($array_api[strtotime($date)]) . '</span>',
                'start' =>  $date,
                'status' =>  "disable",
            ];
        else :
            $array[] = calendar_available($date);
        endif;
    endforeach;
    return $array;
}

/**
 * This is function set date false
 * 
 * @param string date
 * 
 * @return array list array false
 */
function calendar_available($date)
{
    return [
        'day' => date('d', strtotime($date)),
        'end' => $date,
        'event' => "Unavailable",
        'start' => $date,
        'status' => "not_available",
    ];
}


/**
 * Generate message when booking tour
 *
 * @return json
 */
add_action('wp_ajax_st_get_availability_tour_frontend', '_get_availability_tour_frontend');
add_action('wp_ajax_nopriv_st_get_availability_tour_frontend', '_get_availability_tour_frontend');
function message_form()
{
    WC()->cart->empty_cart(true);
    $message = [
        'select_time' => __('Please select time!', TOURIST_DOMAIN),
        'select_date' => __('Please select date!', TOURIST_DOMAIN),
        'min_person'  => __('The minimum number of passengers on this tour  is ', TOURIST_DOMAIN),
        'max_person'  => __('The maximum number of passengers on this tour  is ', TOURIST_DOMAIN),
        'minPassengersRequired' => __('The minimum number of passengers on this group is ', TOURIST_DOMAIN),
        'requied'     => __('This field is requied', TOURIST_DOMAIN),
        'text_max' => __('Max passengers: ', TOURIST_DOMAIN),
        'text_min' => __('Min passengers: ', TOURIST_DOMAIN)
    ];
    $message_json = json_encode($message);
    wp_send_json(['message' => $message_json]);
    die();
}
add_action('wp_ajax_message_form', 'message_form');
add_action('wp_ajax_nopriv_message_form', 'message_form');

/**
 * remove quick edit
 */
add_filter('post_row_actions', 'remove_row_actions', 10, 1);
function remove_row_actions($actions)
{
    if (get_post_type() === 'st_tours' || get_post_types() === 'product' || get_post_types() === 'post') {
        unset($actions['inline hide-if-no-js']);
    }

    return $actions;
}

function rezdy_get_availability_tour_frontend($args)
{
    $rezdyId = get_post_meta($args['id'], 'external_booking_system_product_code', true);
    $args['id'] = $rezdyId;
    $api = new Rezdy('GET', ['id' => $args['id']]);
    $get_available = $api->get_available($args['id'], $args['start'], $args['end']);
    $get_product = $api->get_product($args['id']);
    if (isset($get_product)) :
        $quantityRequired = $get_product['quantityRequired'];
        $quantityRequiredMin = $get_product['quantityRequiredMin'];
        if (!isset($get_product['quantityRequiredMax'])) :
            $quantityRequiredMax = 100;
        endif;
        $advertisedPrice = $get_product['advertisedPrice'];
        $array = [];
        foreach ($get_available as $key => $value) :
            $date = str_replace(['.', "'"], ' ', $value['startTime']);
            $date = strtotime(date('Y-m-d', strtotime($date)));
            $value_time = substr($value['startTime'], 0);
            $time = date('H:i', strtotime($value_time));
            $array[$date]['time'][$value['id']] = [
                'title' => $time,
                'id' => $value['id'],
                'seats' => $value['seats'],
                'allDay' => $value['allDay'],
                'seatsAvailable' => $value['seatsAvailable'],
                'quantityRequired' => $quantityRequired,
                'quantityRequiredMin' => $quantityRequiredMin,
                'quantityRequiredMax' => $quantityRequiredMax,
                'advertisedPrice'    => $advertisedPrice
            ];
            $array[$date]['list'][$value['id']] = $value['priceOptions'];
        endforeach;
        return $array;
    endif;
}

function tourcms_get_availability_tour_frontend($args)
{
    session_start();
    $tourcmsId = get_post_meta($args['id'], 'tourcms_product_code', true);
    $tourcmsChannelId = get_post_meta($args['id'], 'tourcms_channel_id', true);
    $args['id'] = $tourcmsId;
    $args['channel_id'] = $tourcmsChannelId;
    $api = new TourCMS('GET', ['id' => $args['id']]);
    $get_available = $api->get_available($tourcmsId, $tourcmsChannelId);
    $get_tour = $api->get_data($tourcmsId, $tourcmsChannelId);
    $json_string = json_encode($get_tour);
    $tour_json = json_decode($json_string, TRUE);
    $rates = $tour_json['tour']['new_booking']['people_selection']['rate'];
    foreach ($get_available as $key => $value) :
        $date = str_replace(['.', "'"], ' ', $value['start_date']);
        $date = strtotime($date);
        if ($value['status'] == 'OPEN') :
            $array[$date]['list'] = [
                'id' => $tour_json['tour']['tour_id'],
                'tourName' => $tour_json['tour']['tour_name'],
            ];
            $availableDateId = strtotime($value['start_date']);
            $array[$date][$tour_json['tour']['tour_id']][$availableDateId] = [
                'dateId'    => $availableDateId,
                'startDate' => $value['start_date'],
                'endDate'   => $value['end_date'],
                'dateCode'  => $value['date_code'],
                'startTime' => $value['start_time'],
                'endTime'   => $value['end_time'],

            ];
            $length = count($rates);
            $i = 0;
            do {
                $array[$date][$tour_json['tour']['tour_id']]['rates'][$rates[$i]['rate_id']] = [
                    'nameUnit'      => $rates[$i]['label_1'],
                    'minPerBook'    => $rates[$i]['minimum'],
                    'maxPerBook'    => $rates[$i]['maximum'],
                    'rateId'        => $rates[$i]['rate_id'],
                    'price'         => $rates[$i]['from_price']
                ];
                $i++;
            } while ($i < $length);

        endif;
    endforeach;
    return $array;
}

//Get all data param: product, currency, option tour..
function ventrata_get_params_data($product_api)
{
    $current_currency = TravelHelper::get_current_currency('name');
    $api = new Ventrata('GET', '');
    $apiAvailable = new Ventrata('POST', '');
    $params = [
        'type' => 'getTour',
        'tour_id' => $product_api,
        'currency' => $current_currency
    ];
    $get_tour = $api->get_data($params);
    $data_params = [];
    if ($get_tour != null && is_array($get_tour)) :
        $get_type_tour = $get_tour['availabilityType'];
        $get_options = $get_tour['options'];
        $get_options_type = $get_options[0]['id'];
        $lengthOption = count($get_options);
        $optionId = array_column($get_options, 'id');
        if ($lengthOption >= 2) {
            $data_params = [
                'type_tour'     => $get_type_tour,
                'data_options'  => $get_options,
                'optionType'    => $get_options_type,
                'currency'      => $current_currency,
                'tour_id'       => $product_api,
                'options'       => $optionId,
                'https_method'  => $apiAvailable,
                'countOption'   => 2,
                'pricingPer'    => $get_tour['pricingPer']
            ];
        } else {
            $data_params = [
                'type_tour'     => $get_type_tour,
                'data_options'  => $get_options,
                'optionType'    => $get_options_type,
                'currency'      => $current_currency,
                'tour_id'       => $product_api,
                'https_method'  => $apiAvailable,
                'countOption'   => 1,
                'pricingPer'    => $get_tour['pricingPer']
            ];
        }
        return $data_params;
    endif;
}
//Get available date If tour has 1 option 
function ventrata_get_availability_option($product_api, $start, $end)
{
    $data_params = ventrata_get_params_data($product_api);
    if ($data_params != null) :
        $apiAvailable = $data_params['https_method'];
        $get_options = $data_params['data_options'];
        $array_option = [];
        $array = [];
        //If dont have option ->option default
        if ($data_params['optionType'] == 'DEFAULT') :
            $data_params['optionType'] = 'DEFAULT';
        endif;
        // Params get available date
        $paramsAvailable = [
            'type' => 'getAvailable',
            'body' => [
                'productId'         => $data_params['tour_id'],
                'localDateStart'    => $start,
                'localDateEnd'      => $end,
                'currency'          => $data_params['currency'],
                'optionId'          => $data_params['optionType']
            ]
        ];
        //Get availalbe
        $get_available = $apiAvailable->get_data($paramsAvailable);
        if ($get_options != null) :
            foreach ($get_options as $key => $option) :
                // # code...
                $array_option[$data_params['optionType']] = [
                    'id'                            => $option['id'],
                    'typeTour'                      => $data_params['type_tour'],
                    'minUnitsOption'                => $option['restrictions']['minUnits'],
                    'maxUnitsOption'                => $option['restrictions']['maxUnits'],
                    'availabilityLocalStartTimes'   => $option['availabilityLocalStartTimes'],
                    'titleOption'                   => $option['title']
                ];
                foreach ($option['units'] as $key => $unit) :
                    # code...
                    $array_option[$data_params['optionType']]['unit'][] = [
                        'unitId'            => $unit['id'],
                        'paxCount'          => $unit['restrictions']['paxCount'],
                        'title'             => $unit['title'],
                        'original'          => $unit['pricingFrom'][0]['original'],
                        'retail'            => $unit['pricingFrom'][0]['retail'],
                    ];
                endforeach;
            endforeach;
        endif;
        if ($get_available != null) :
            foreach ($get_available as $key => $value) :
                $date = str_replace(['.', "'"], ' ', $value['id']);
                $date = strtotime($date);
                $date = date('Y-m-d', $date);
                $date = strtotime($date);
                if ($value['available'] != null || $value['status'] != 'CLOSED' || $value['capacity'] != 0) :
                    $array[$date]['typeTour'] = [
                        'typeTour'          => $array_option[$data_params['optionType']]['typeTour'],
                        'pricingPer'        => $data_params['pricingPer']
                    ];
                    $array[$date]['list'][$array_option[$data_params['optionType']]['id']] = [
                        'id'                => $array_option[$data_params['optionType']]['id'],
                        'capacity'          => $value['capacity'],
                        'maxUnits'          => $value['maxUnits'],
                        'minUnitsOption'    => $array_option[$data_params['optionType']]['minUnitsOption'],
                        'maxUnitsOption'    => $array_option[$data_params['optionType']]['maxUnitsOption'],
                        'titleOption'       => $array_option[$data_params['optionType']]['titleOption']
                    ];
                    $availableDate = strtotime($value['id']);
                    $array[$date][$array_option[$data_params['optionType']]['id']][$availableDate] = [
                        'availableDateId'               => $value['id'],
                        'localDate'                     => date('Y-m-d', $date),
                        'availabilityLocalStartTimes'   => substr(($value['id']), 11, 5),
                        'localDateTimeStart'            => $value['localDateTimeStart'],
                        'localDateTimeEnd'              => $value['localDateTimeEnd'],
                        'offerCode'                     => $value['offerCode'],
                    ];
                    foreach ($array_option[$data_params['optionType']]['unit'] as $key => $unit_item) {
                        # code...
                        $array[$date][$array_option[$data_params['optionType']]['id']][$availableDate]['units'][$unit_item['unitId']] = [
                            'unitId'                => $unit_item['unitId'],
                            'original'              => $unit_item['original'],
                            'retail'                => $unit_item['retail'],
                            'paxCount'              => $unit_item['paxCount'],
                            'title'                 => $unit_item['title']
                        ];
                    }
                endif;
            endforeach;
        endif;
        if ($array != null) :
            return $array;
        endif;
    endif;
}

// //Get available date If tour has more 1 option
function ventrata_get_availability_more_options($product_api, $start, $end)
{
    //Get all data from ventrata_get_params_data
    $data_params = ventrata_get_params_data($product_api);
    if ($data_params != null) :
        $pricingPer = $data_params['pricingPer'];
        $optionId = $data_params['options'];
        $get_options = $data_params['data_options'];
        $product_api = $data_params['tour_id'];
        $current_currency = $data_params['currency'];
        $get_type_tour = $data_params['type_tour'];
        $apiAvailable = $data_params['https_method'];
        $array_option = [];
        $array = [];
        //Get each options
        foreach ($optionId as $key => $value) {
            # code...
            $paramsAvailable = [
                'type' => 'getAvailable',
                'body' => [
                    'productId'         => $product_api,
                    'localDateStart'    => $start,
                    'localDateEnd'      => $end,
                    'currency'          => $current_currency,
                    'optionId'          => $value
                ]
            ];

            foreach ($get_options as $key => $option) :
                // # code...
                $array_option[$option['id']] = [
                    'id'                            => $option['id'],
                    'typeTour'                      => $get_type_tour,
                    'minUnitsOption'                => $option['restrictions']['minUnits'],
                    'maxUnitsOption'                => $option['restrictions']['maxUnits'],
                    'availabilityLocalStartTimes'   => $option['availabilityLocalStartTimes'],
                    'titleOption'                   => $option['title']
                ];
                if ($pricingPer == 'BOOKING') :
                    foreach ($option['units'] as $key => $unit) :
                        # code...
                        $array_option[$option['id']]['unit'][] = [
                            'unitId'            => $unit['id'],
                            'paxCount'          => $unit['restrictions']['paxCount'],
                            'original'          => $option['pricingFrom'][0]['original'],
                            'retail'            => $option['pricingFrom'][0]['retail'],
                        ];
                    endforeach;
                else :
                    foreach ($option['units'] as $key => $unit) :
                        # code...
                        $array_option[$option['id']]['unit'][] = [
                            'unitId'            => $unit['id'],
                            'paxCount'          => $unit['restrictions']['paxCount'],
                            'original'          => $unit['pricingFrom'][0]['original'],
                            'retail'            => $unit['pricingFrom'][0]['retail'],
                        ];
                    endforeach;
                endif;
            endforeach;

            //Get data date available from each options
            $get_available = $apiAvailable->get_data($paramsAvailable);
            if ($get_available != null) :
                foreach ($get_available as $key => $available) :
                    $date = str_replace(['.', "'"], ' ', $available['id']);
                    $date = strtotime($date);
                    $date = date('Y-m-d', $date);
                    $date = strtotime($date);
                    if ($available['available'] != null || $available['status'] != 'CLOSED' || $available['capacity'] != 0) :
                        $array[$date]['typeTour'] = [
                            'typeTour'          => $array_option[$value]['typeTour'],
                            'pricingPer'        => $data_params['pricingPer']
                        ];
                        $array[$date]['list'][$array_option[$value]['id']] = [
                            'id'                => $array_option[$value]['id'],
                            'capacity'          => $available['capacity'],
                            'maxUnits'          => $available['maxUnits'],
                            'minUnitsOption'    => $array_option[$value]['minUnitsOption'],
                            'maxUnitsOption'    => $array_option[$value]['maxUnitsOption'],
                            'titleOption'       => $array_option[$value]['titleOption'],
                        ];
                        $availableDate = strtotime($available['id']);
                        $array[$date][$array_option[$value]['id']][$availableDate] = [
                            'availableDateId'               => $available['id'],
                            'localDate'                     => date('Y-m-d', $date),
                            'availabilityLocalStartTimes'   => substr(($available['id']), 11, 5),
                            'localDateTimeStart'            => $available['localDateTimeStart'],
                            'localDateTimeEnd'              => $available['localDateTimeEnd'],
                            'offerCode'                     => $available['offerCode'],
                        ];
                        foreach ($array_option[$value]['unit'] as $key => $unit_item) {
                            # code...
                            $array[$date][$array_option[$value]['id']][$availableDate]['units'][$unit_item['unitId']] = [
                                'unitId'                => $unit_item['unitId'],
                                'original'              => $unit_item['original'],
                                'retail'                => $unit_item['retail'],
                                'paxCount'              => $unit_item['paxCount']
                            ];
                        }
                    endif;
                endforeach;
            endif;
        }
        if ($array != null) :
            return $array;
        endif;
    endif;
}

function ventrata_get_availability_tour_frontend($args)
{
    session_start();
    $product_api = get_post_meta($args['id'], 'ventrata_product_id', true);
    $data_params = ventrata_get_params_data($product_api);
    $array = [];
    if ($data_params != null) :
        $lengthOption  = $data_params['countOption'];
        if ($data_params['pricingPer'] == 'BOOKING') :
            add_post_meta($args['id'], 'flexible', 'done', true);
        endif;
        if ($lengthOption >= 2) :
            $array = ventrata_get_availability_more_options($product_api, $args['start'], $args['end']);
        else :
            $array = ventrata_get_availability_option($product_api, $args['start'], $args['end']);
        endif;
        return $array;
    endif;
}
function ventrata_customer_type_rate($data)
{
    $list = [];
    foreach ($data as $item => $key) :
        $pos = strpos($item, 'bokun_field_persons_book_');
        if ($pos !== false) {
            $explode = explode('bokun_field_persons_book_', $item);
            if ($key > 0) :
                for ($i = 0; $i < $key; $i++) :
                    $list[] = [
                        'unitId' => $explode[1]
                    ];
                endfor;

            endif;
        }
    endforeach;
    return $list;
}
function pluralo_customer_type_rate($data)
{
    $list = [];
    foreach ($data as $item => $key) :
        $pos = strpos($item, 'bokun_field_persons_book_');
        if ($pos !== false) {
            $explode = explode('bokun_field_persons_book_', $item);
            if ($key > 0) :
                $list[] = [
                    "AudienceType" => $_POST['AudienceType'][$explode[1]],
                    "Quantity" => (int)$key,
                    "AudienceGroup" => ($_POST['AudienceTypeGroup'][$explode[1]] != null) ? $_POST['AudienceTypeGroup'][$explode[1]] : null,
                ];
            endif;
        }
    endforeach;
    return $list;
}
function fareharbor_customer_type_rate($data)
{
    $list = [];
    foreach ($data as $item => $key) :
        $pos = strpos($item, 'bokun_field_persons_book_');
        if ($pos !== false) {
            $explode = explode('bokun_field_persons_book_', $item);
            if ($key > 0) :
                for ($i = 0; $i < $key; $i++) :
                    $list[] = [
                        'customer_type_rate' => (int) $explode[1]
                    ];
                endfor;

            endif;
        }
    endforeach;
    return $list;
}

function tourist_add_to_cart_validation($passed, $product_id, $quantity, $variation_id = 0, $variations = null)
{
    if (isset($_POST['api_name'])) :
        $api_name = $_POST['api_name'];
        
        WC()->session->set('api_name',$api_name);
        switch ($api_name) {
            case 'fareharbor':
                WC()->session->set('fareharbor', [
                    'product_code' => $_POST['fareharbor_product_code'],
                    'shortname' => $_POST['fareharbor_company_shortname'],
                    'wc_bookings_field_start_time_id' => $_POST['wc_bookings_field_start_time_id'],
                    'customers' => fareharbor_customer_type_rate($_POST)
                ]);
                if (WC()->session->get('bokun') != null) :
                    WC()->session->__unset('bokun');
                endif;
                if (WC()->session->get('ventrata') != null) :
                    WC()->session->__unset('ventrata');
                endif;
                $session = WC()->session->get('fareharbor');
                $options['customers'] = $session['customers'];
                $options = [
                    'customers' => $session['customers'],
                    'parames' => [
                        'shortname' => $session['shortname'],
                        'time_id' => $session['wc_bookings_field_start_time_id'],
                        'base' => 'bookings',
                        'validate' => 'validate'
                    ]
                ];
    
                $currecy = TravelHelper::get_current_currency('name');
                $currecy = strtolower($currecy);
                if ($currecy != 'eur')
                    return api_Validation('This currency is not supported');
                $fareharbor = new Fareharbor('POST', $options);
                $far_remote = $fareharbor->far_remote();
                $far_body = json_decode($far_remote['body'], true);
                if ((is_int($far_remote['code']) && $far_remote['code'] == 200)) {
                    if ($far_body['is_bookable'] == true) {
                        $price = ($far_body['receipt_total'] / 100);
                        WC()->session->set('custom_price', $price);
                        return 'success';
                    } else {
                        return api_Validation(Validation::is_string($far_body['error']));
                    }
                } else {
                    return api_Validation(Validation::is_string($far_body['error']));
                }
                return 'success';
                break;
            case 'experience':
                if (WC()->session->get('bokun') != null) :
                    WC()->session->__unset('bokun');
                endif;
                if (WC()->session->get('fareharbor') != null) :
                    WC()->session->__unset('fareharbor');
                endif;
                if (WC()->session->get('ventrata') != null) :
                    WC()->session->__unset('ventrata');
                endif;
                $currecy = TravelHelper::get_current_currency('name');
                if ($currecy != 'EUR') :
                    return api_Validation('This currency is not supported');
                else :
                    WC()->session->set('experience', [
                        'productId'             => $_POST['experience_product_id'],
                        'ticketId'              => $_POST['wc_experience_ticketId'],
                        'itemId'                => $_POST['wc_experience_itemId'],
                        'occupancy'             => $_POST['total_person_book'],
                        'price'                 => $_POST['wc_experience_price'],
                        'startTime'             => $_POST['wc_bookings_field_start_time_id'],
                    ]);
                    WC()->session->set('custom_price', $_POST['api_price']);
                    return 'success';
                endif;
                break;
            case 'pluralo':
                if (WC()->session->get('bokun') != null) :
                    WC()->session->__unset('bokun');
                endif;
                if (WC()->session->get('fareharbor') != null) :
                    WC()->session->__unset('fareharbor');
                endif;
                if (WC()->session->get('ventrata') != null) :
                    WC()->session->__unset('ventrata');
                endif;
                if (WC()->session->get('experience') != null) :
                    WC()->session->__unset('experience');
                endif;
    
                $array =  [
                    'EventId'             => $_POST['wc_bookings_field_start_time_id'],
                    'BookingOperatorCode' =>  'toursxplorer',
                    'Audiences'             => pluralo_customer_type_rate($_POST)
                ];
                $plurado = new Pluralo('POST',$array);
                $respon = $plurado->prebook();
                // print_r($array);
                // die;
                if (isset($respon['StatusCode']) && $respon['StatusCode'] == 200) :
                    WC()->session->set('pluralo', $respon['Data']['PrebookingReference'] ?? null);
                    if (isset( $respon['Data']['BillingTotal'] ) && $respon['Data']['BillingTotal'] != null) {
                        WC()->session->set('custom_price', $respon['Data']['BillingTotal'] );
                        WC()->session->set('wc_pluralo_BookingQuestion', $_POST['wc_pluralo_BookingQuestion']);
                        return 'success';
                    }
                    return api_Validation( 'Can not get price' );
                    
                else :
                    return api_Validation( isset($respon['Data']['ErrorMessage'])?isset($respon['Data']['ErrorMessage']): 'API not support' );
                endif;
                break;
            case 'ventrata':
                if (WC()->session->get('bokun') != null) :
                    WC()->session->__unset('bokun');
                endif;
                if (WC()->session->get('fareharbor') != null) :
                    WC()->session->__unset('fareharbor');
                endif;
                $currecy = TravelHelper::get_current_currency('name');
                if ($currecy != 'EUR' && $currecy != 'USD') :
                    return api_Validation('This currency is not supported');
                else :
                    $ventrata = new Ventrata('POST', '');
                    WC()->session->set('ventrata', [
                        'type'              => 'addCart',
                        'body'              => [
                            'productId'         => $_POST['ventrata_product_id'],
                            'optionId'          => $_POST['wc_ventra_optionId'],
                            'availabilityId'    => $_POST['wc_bookings_field_start_time_id'],
                            'currency'          => $currecy,
                            'unitItems'         => ventrata_customer_type_rate($_POST)
                        ],
                    ]);
                    $body =  WC()->session->get('ventrata');
                    $add_cart = $ventrata->get_data($body);
                    if ($add_cart) :
                        $price = $add_cart['pricing'];
                        if ($add_cart['offerCode'] !== null) :
                            WC()->session->set('custom_price', ($price['retail']) / 100);
                            WC()->session->set('uuid', $add_cart['uuid']);
                            return 'success';
                        else :
                            WC()->session->set('custom_price', ($price['original']) / 100);
                            WC()->session->set('uuid', $add_cart['uuid']);
                            return 'success';
                        endif;
                    else :
                        return api_Validation('Cannot add to cart');
                    endif;
                endif;
                break;
            case 'bokun':
                if (WC()->session->get('bokun') == null) :
                    WC()->session->set('bokun', md5('Tourist_' . microtime()));
                endif;
                if (WC()->session->get('ventrata') != null) :
                    WC()->session->__unset('ventrata');
                endif;
                if (WC()->session->get('fareharbor') != null) :
                    WC()->session->__unset('fareharbor');
                endif;
                $control_bokun = new control_bokun($_POST);
                $add_cart = $control_bokun->add_cart();
                if ($add_cart['status'] == true) :
                    $price = $control_bokun->get_price();
                    if ($price !== false) :
                        WC()->session->set('custom_price', $price);
                        return 'success';
                    else :
                        return api_Validation('This currency is not supported');
                    endif;
                else :
                    return api_Validation($add_cart['message']['message']);
                endif;
                break;
            case 'tourcms':
                return 'success';
                break;
            case 'rezdy':
                return 'success';
                break;
            default:
                return api_Validation('This currency is not supported');
                break;
        }
    else :
        if (WC()->session->get('bokun') != null) :
            WC()->session->__unset('bokun');
        endif;
        if (WC()->session->get('fareharbor') != null) :
            WC()->session->__unset('fareharbor');
        endif;
        return 'success';
    endif;
}
add_filter('woocommerce_add_to_cart_validation', 'tourist_add_to_cart_validation', 10, 5);


/**
 * This function validation api false
 */
function api_Validation($message)
{
    STTemplate::set_message(__($message, TOURIST_DOMAIN));
    return false;
}

/**
 * This is funtion book api false
 * if book false update order status
 *
 * @param int $order_id get by order id
 * @param string get name option api
 * @param string name api
 */
function book_api_false($order_id,  $name)
{
    $messages = get_option('messages_option', true);
    $false = null;
    if (is_array($messages)) :
        $false = $messages['failed'];
    endif;
    $order = wc_get_order($order_id);
    $order->update_status('failed', $name . ' book api failed');
    $admin_email = get_option('admin_email');
    $options = get_option('fareharbor_option', false);
    $headers[] = 'Cc: ' . (isset($options['Email'])) ? __($options['Email'], true)  : null;
    wp_mail($admin_email, $false, 'Book api' . $name . '<br> Order : ' . $order_id, $headers);
}
add_action('woocommerce_thankyou', 'thanks_api', 12);


/**
 * Function Create booking automatic check option
 */
function Create_booking_automatic()
{
    $options = get_option('messages_option', false);
    if (is_bool($options) && $options == false) return false;
    if (!isset($options['Create booking automatic']) ||  $options['Create booking automatic'] === 'no') return false;
}

function Body_exp($order, $dataSession, $options)
{
    $currecy = TravelHelper::get_current_currency('name');
    $arr = [
        'contact' => [
            'experience_fullName'                   => $order->get_billing_first_name() . " " . $order->get_billing_last_name(),
            'experience_phoneNumber'                => $order->get_billing_phone(),
            'experience_email'                      => $options['Email'],
            'experience_country'                    => $order->get_billing_country()
        ],
        'payment' => [
            'experience_amount'                     => $dataSession['price'],
            'experience_currency'                   => $currecy
        ],
        'items'   => [
            'experience_productId'                  => $dataSession['price'],
            'experience_itemId'                     => $dataSession['itemId']
        ],
        'tickets' => [
            'experience_startTime'                  => $dataSession['startTime'],
            'experience_occupancy'                  => $dataSession['occupancy'],
            'experience_idTicket'                   => $dataSession['ticketId']
        ],
        'priceTicket'   => [
            'experience_ticketAmount'               => $dataSession['price'],
            'experience_ticketCurrency'             => $currecy,
        ]
    ];
    return $arr;
}

function thanks_api($order_id)
{
    $order = wc_get_order($order_id);
    if (isset($_COOKIE['affiliate_for_woocommerce'])) :
        $affiliate_id =  $_COOKIE['affiliate_for_woocommerce'];
        if ($affiliate_id != null) :
            $user_id =  $order->get_user_id();
            update_user_meta($user_id, 'afwc_parent_chain', $affiliate_id);
        endif;
    endif;

    if (!is_a($order, 'WC_Order')) :
        return;
    endif;

    if (!API_Product_Booking($order)) return;
    $multibanco = multibanco_api_offline($order);
    if ($multibanco == true) {
        update_meta_api_mode($order, false, 'Pay with Multibanco');
        return;
    }

    $mbway_ifthen = mbway_ifthen_for_woocommerce($order);
    if ($mbway_ifthen == true) {
        update_meta_api_mode($order, false, 'Pay with mbway');
        return;
    }

    $api_paywith_online = api_paywith_online($order);
    if ($api_paywith_online == false) {
        update_meta_api_mode($order, false, 'Pay with online ' . $order->get_status());
        return;
    }
    $check_booking = Create_booking_automatic();
    if (is_bool($check_booking) && $check_booking == false) :
        update_meta_api_mode($order, false, 'Please open booking automatic in config');
        return;
    endif;
    
    
    $api_name = WC()->session->get('api_name');
    WC()->session->__unset('api_name');
    switch ($api_name) {
        case 'pluralo':
                $pluralo = WC()->session->get('pluralo');
                $wc_pluralo_BookingQuestion = get_post_meta($order_id, 'wc_pluralo_BookingQuestion', true);
                $wc_pluralo_BookingQuestion_rep = get_post_meta($order_id, 'wc_pluralo_BookingQuestion_rep', true);

                $array = [
                    'ReferenceNumber' => $pluralo,
                    'BookingOperatorCode' => $order_id,
                    'TravellerContact' => [
                        'Email' => $order->get_billing_email(),
                        'FirstName' => $order->get_billing_first_name(),
                        'LastName' => $order->get_billing_last_name(),
                        'PhoneNumber' => $order->get_billing_phone(),
                    ],
                    'Questions' => [
                        [
                            'Question' => $wc_pluralo_BookingQuestion,
                            'Answer' => $wc_pluralo_BookingQuestion_rep
                        ]
                    ],
                    'Note' => 'toursxplorer'
                ];
                $plurado = new Pluralo('POST', $array);
                $respon = $plurado->Book($array);
                if (isset($respon['StatusCode']) && $respon['StatusCode'] == 200) :
                    $order->update_status('completed');
                    update_post_meta($order_id, 'api_mode_fix',  true);
                    update_meta_api_mode($order, true, 'pluralo book success <br>Booking ID: ' . json_encode($respon));
                    update_post_meta($order_id, 'Data', json_encode($respon['Data']));

                else :
                    update_meta_api_mode($order, 'false', 'pluralo fail' . json_encode($respon));
                endif;
                WC()->session->__unset('pluralo');
            break;
        
        case 'fareharbor':
                $bokun = get_option('fareharbor_option', false);
                $options['contact'] = [
                    'fareharbor_email' => (isset($bokun['Email'])) ? __($bokun['Email'], true)  : null,
                    'fareharbor_firstName' => $order->get_billing_first_name(),
                    'fareharbor_lastName' => $order->get_billing_last_name(),
                    'fareharbor_phoneNumber' => $order->get_billing_phone(),
                ];
                $session = WC()->session->get('fareharbor');
                $options['customers'] = $session['customers'];
                $options['parames']['shortname'] = $session['shortname'];
                $options['parames']['time_id'] = $session['wc_bookings_field_start_time_id'];
                $options['parames']['base'] = 'bookings';
                $fareharbor = new Fareharbor('POST', $options);
                $far_remote = $fareharbor->far_remote();
                if ($far_remote['code'] == 200) :
                    $far_remote = json_decode($far_remote['body'], true);
                    if (isset($far_remote['booking']['uuid'])) :
                        $order->update_status('completed');
                        update_meta_api_mode($order, true, 'Fareharbor book success <br>Booking ID: ' . $far_remote['booking']['pk']);
                        update_post_meta($order_id, 'session_fareharbor', $far_remote['booking']['uuid']);
                    else :
                        update_meta_api_mode($order, false, 'Fareharbor fail' . json_encode($far_remote));
                    endif;
                else :
                    update_meta_api_mode($order, false, 'Fareharbor fail' . json_encode($far_remote));
                endif;
                WC()->session->__unset('fareharbor');
            break;
        case 'experience':
                $options = get_option('experience_option', false);
                $params = [
                    'type' => 'booking'
                ];
                $dataBodyExp = Body_exp($order, $experience, $options);
                $experience_class = new Experience('POST', $dataBodyExp);
                $experience_book = $experience_class->get_data($params);
                if ($experience_book != false) :
                    update_meta_api_mode($order, true, 'ExperienceWare book success');
                    update_post_meta($order_id, 'session_experience', $experience);
                    WC()->session->__unset('experience');
                else :
                    update_meta_api_mode($order, false, 'ExperienceWare book fail <br>' . json_encode($experience_book));
                endif;
                WC()->session->__unset('experience');
            break;
        case 'ventrata':
                $uuid = WC()->session->get('uuid');
                $params = [
                    'type' => 'confirmBook',
                    'uuid' => $uuid,
                    'body' => [
                        'contact'   => [
                            'emailAddress' => $order->get_billing_email(),
                            'fullName'     => $order->get_billing_first_name() . " " . $order->get_billing_last_name(),
                            'phoneNumber'  => $order->get_billing_phone(),
                            'country'      => $order->get_billing_country()
                        ]
                    ],
                ];
                $book = new Ventrata('POST', '');
                $confirm = $book->get_data($params);
                if ($confirm) :
                    update_post_meta($order_id, 'session_ventrata', $ventrata);
                    WC()->session->__unset('ventrata');
                    $order->update_status('completed');
                    update_meta_api_mode($order, true, 'Ventrata book success <br> ID :' . $confirm['uuid']);
                else :
                    update_meta_api_mode($order, false, 'Ventrata book fail <br>' . json_encode($confirm));
                endif;
                WC()->session->__unset('ventrata');
            break;
        case 'bokun':
                $data = [
                    'order' => $order_id
                ];
                $control_bokun = new control_bokun($data);
                $checkout = $control_bokun->checkout();
        
                if ($checkout == false) :
                    update_meta_api_mode($order, false, 'Bokun book fail <br>');
                else :
                    if (isset($checkout['message']['booking'])) :
                        $order->update_status('completed');
                        update_meta_api_mode($order, true, 'Bokun book success  <br> ID :' . $checkout['message']['booking']['bookingId']);
                    else :
                        update_meta_api_mode($order, false, 'Bokun book fail <br>' . json_encode($checkout));
                    endif;
                endif;
                update_post_meta($order_id, 'session_bokun', $bokun);
            break;
        default:
            if (!metadata_exists('post', $order_id, 'api_mode')) {
                update_meta_api_mode($order, false, 'API Not support');
            }
            break;
    }
    unset_api_session();
}


if (!function_exists('unset_api_session')) {

    /**
     * Unset all api session
     */

    function unset_api_session()
    {
        $list = ['fareharbor', 'experience', 'ventrata', 'bokun'];
        foreach ($list as $item) :
            WC()->session->__unset($item);
        endforeach;
    }
}

/**
 * This is function cancelled affilate
 */
add_action('edit_user_profile_update', 'updated_user_details');
function updated_user_details($user_id)
{
    if (metadata_exists('user', $user_id, 'afwc_is_affiliate')) :
        $user_meta = get_user_meta($user_id, 'afwc_is_affiliate', false);
        if (is_array($user_meta) && $user_meta[0] === 'no') :

            $user = get_users(array(
                'meta_query' => array(
                    array(
                        'key' => 'afwc_parent_chain',
                        'value' => $user_id,
                        'compare' => 'like'
                    ),
                )
            ));
            foreach ($user as $items) :
                update_user_meta($items->ID, 'afwc_parent_chain', null);
            endforeach;
            update_user_meta($user_id, 'afwc_parent_chain', null);
        endif;
    endif;
}
function bokun_get_availability_tour_frontend($args)
{
    session_start();
    $array = [];
    $current = TravelHelper::get_current_currency('name');
    $product_api = get_post_meta($args['id'], 'bokun_product_id', true);
    $api = new Bokun('GET', ['id' => $product_api]);
    $get_tour = $api->get_tour();
    if (is_array($get_tour) && $get_tour != null) :
        $typeTour = $get_tour['bookingType'];
    endif;
    if ($typeTour == 'DATE') :
        add_post_meta($args['id'], 'flexible', 'done', true);
    endif;
    $get_available = $api->get_available($args['start'], $args['end']);
    $price_list = $api->get_price();
    if (is_array($price_list)) :
        $price_list = $price_list['pricesByDateRange'][0]['rates'];
        $passengers_price_list = null;
        foreach ($price_list as $key => $value) :
            $passengers_price_list[$value['rateId']] = $value['passengers'];
        endforeach;
        $price_list = $passengers_price_list;
    endif;
    foreach ($get_available as $key => $value) :
        $date = str_replace(['.', "'"], ' ', $value['localizedDate']);
        $date = strtotime($date);
        if ($value['unavailable'] != 1 || $value['soldOut'] != 1) :
            foreach ($value['rates'] as $items => $rates) :
                if (isset($price_list[$rates['id']])) :
                    $array[$date]['list'][$rates['id']] = [
                        'id' => $rates['id'],
                        'title' => $rates['title'],
                        'minPerBooking' => $rates['minPerBooking'],
                        'maxPerBooking' => $rates['maxPerBooking'],
                    ];
                    $array[$date]['typeTour'] = $typeTour;
                    $array[$date]['date'] =  $date;
                    $array[$date][$rates['id']][$value['startTimeId']] = [
                        'date' => date('Y-m-d', $date),
                        'startTime' => $value['startTime'],
                        'startTimeId' => $value['startTimeId'],
                        'availabilityCount' => $value['availabilityCount']
                    ];
                    $array[$date][$rates['id']]['rates'] = $value['pricesByRate'][array_search($rates['id'], array_column($value['pricesByRate'], 'activityRateId'))];
                endif;
            endforeach;
        endif;
    endforeach;
    return $array;
}

// Disable auto update plugin and update theme
add_filter('auto_update_plugin', '__return_false');
add_filter('auto_update_theme', '__return_false');

// Set stripe default
add_action('template_redirect', 'define_default_payment_gateway');

function define_default_payment_gateway()
{

    if (is_checkout() && !is_wc_endpoint_url()) {

        // HERE define the default payment gateway ID

        $default_payment_id = 'none';



        WC()->session->set('chosen_payment_method', $default_payment_id);
    }
}

function wpdocs_logout_redirect($redirect_to, $requested_redirect_to, $user)
{

    $user_roles = $user->roles;
    $user_has_admin_role = in_array('administrator', $user_roles);

    if ($user_has_admin_role) :
        $redirect_to = admin_url();
    else :
        $redirect_to = home_url();
    endif;

    return $redirect_to;
}
add_filter('logout_redirect', 'wpdocs_logout_redirect', 9999, 3);

// Code to clear default payment option.
add_filter('pre_option_woocommerce_default_gateway' . '__return_false', 99);

// Enable Payment Cash on delivery for admin
add_filter('woocommerce_available_payment_gateways', 'bbloomer_paypal_enable_manager');

function bbloomer_paypal_enable_manager($available_gateways)
{
    if (isset($available_gateways['cod']) && !current_user_can('administrator')) {
        unset($available_gateways['cod']);
    }
    return $available_gateways;
}
// Facebook pixel
function tour_hook_facebook_pixel()
{
    if (is_singular('st_tours')) {
        $product_id = get_post_meta(get_the_ID(), 'product_id', true);
?>
        <!--meta property="product:brand" content="<?php echo get_the_author_meta('display_name'); ?>">
        <meta property="product:availability" content="in stock">
        <meta property="product:price:amount" content="<?php echo get_post_meta(get_the_ID(), 'adult_price', true); ?>">
        <meta property="product:price:currency" content="<?php echo get_woocommerce_currency_symbol(); ?>"
		<meta property="fb:app_id" content="1222474645214536" />-->
        <!-- Facebook Pixel Code -->
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window,
                document, 'script', 'https://connect.facebook.net/en_US/fbevents.js');
            // Line to enable Manual Only mode.
            fbq('set', 'autoConfig', false, '810768013397837');
            //Insert Your Facebook Pixel ID below. 
            fbq('init', '810768013397837');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=810768013397837&amp;ev=PageView&amp;noscript=1" />
        </noscript>
        <!-- End Facebook Pixel Code -->
    <?php
    } else {
        return;
    }
}
//add_action('wp_head', 'tour_hook_facebook_pixel');
function tour_hook_product_facebook_pixel()
{
    if (is_singular('st_tours')) {
        $product_id = get_post_meta(get_the_ID(), 'product_id', true);
    ?>
        <script type="application/ld+json">
            {
                "@context": "https:\/\/schema.org\/",
                "@type": "Product",
                "@id": "<?php echo get_the_permalink(); ?>\/#product",
                "name": "<?php echo get_the_title(); ?>",
                "url": "<?php echo get_the_permalink(); ?>",
                "image": "<?php echo get_the_post_thumbnail_url(); ?>",
                "description": "<?php echo get_the_title(); ?>",
                "brand": {
                    "@type": "Brand",
                    "name": "toursxplorer"
                },

                "sku": 5791,
                "offers": [{
                    "@type": "Offer",
                    "price": "<?php echo get_post_meta(get_the_ID(), 'adult_price', true); ?>",
                    "priceValidUntil": "2023-12-31",
                    "priceSpecification": {
                        "price": "<?php echo get_post_meta(get_the_ID(), 'adult_price', true); ?>",
                        "priceCurrency": "EUR",
                        "valueAddedTaxIncluded": "false"
                    },
                    "priceCurrency": "EUR",
                    "availability": "http:\/\/schema.org\/InStock",
                    "url": "<?php echo get_the_permalink(); ?>",
                    "seller": {
                        "@type": "Organization",
                        "name": "<?php echo get_the_author_meta('display_name'); ?>",
                        "url": "<?php echo get_home_url(); ?>"
                    }
                }]
            }
        </script>

<?php
    } else {
        return;
    }
}
add_action('wp_footer', 'tour_hook_product_facebook_pixel');

add_action('admin_init', 'mpe_add_portfolio_page_attributes');
function mpe_add_portfolio_page_attributes()
{

    add_post_type_support('st_tours', 'page-attributes');
}


/* Change Text Site Wide 

function wpfi_change_text( $translated_text, $text, $domain ) {
    switch ( $translated_text ) {
        case 'Barco Privado' :
            $translated_text = __( 'Private Boat' );
            break;
    }
    return $translated_text;
}

add_filter( 'gettext', 'wpfi_change_text', 20, 3 );
*/
