<?php
	global $product;
?>
<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>
<div class="product-element-top dd">
	<a href="<?php echo esc_url( get_permalink() ); ?>">
		<?php
			/**
			 * woocommerce_before_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10
			 * @hooked basel_template_loop_product_thumbnail - 10
			 */
			do_action( 'woocommerce_before_shop_loop_item_title' );
		?>
	</a>
	<?php basel_hover_image(); ?>
	<div class="basel-buttons">
		<?php do_action( 'basel_product_action_buttons' ); ?>
		<?php basel_compare_btn(); ?>
		<?php basel_quick_view_btn( get_the_ID() ); ?>
	</div>
</div>
<?php
	/**
	 * woocommerce_shop_loop_item_title hook
	 *
	 * @hooked woocommerce_template_loop_product_title - 10
	 */
	do_action( 'woocommerce_shop_loop_item_title' );
?>

<?php basel_product_brands_links();

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();

if ( $rating_count === 0 ) :?>

	<div class="woocommerce-product-rating">
	<a href="<?php echo esc_url( get_permalink() ); ?>#tab-reviews" class="woocommerce-review-link noreview"  tabindex="0" rel="nofollow">

 <?php //echo '<span class="avarge_rating">'. $average.'.0</span>' ;?>
 <div class="star-rating" role="img"><span style="width:0%"></span> </div>
( Leave a review ) <!-- 0 review -->
 </a>
</div>
<?php else : ?>
	<div class="woocommerce-product-rating">
	<a href="<?php echo esc_url( get_permalink() ); ?>#tab-reviews" class="woocommerce-review-link"  tabindex="0" rel="nofollow">
	<?php //echo '<span class="avarge_rating">'.  round($average, 1).'.0</span>' ;?>
		<?php echo wc_get_rating_html( $average, $rating_count ); // WPCS: XSS ok. ?>
		<?php if ( comments_open() ) : ?>
			<?php //phpcs:disable ?>

		 <?php printf( _n( '( %s Review )', '%s customer reviews', $review_count, 'woocommerce' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>
			<?php // phpcs:enable ?>
		<?php endif ?>
		</a>
	</div>

<?php endif; ?>


<div class="wrap-price">
	<div class="wrapp-swap">
		<div class="swap-elements dd">
			<?php
				/**
				 * woocommerce_after_shop_loop_item_title hook
				 *
				 * @hooked woocommerce_template_loop_rating - 5
				 * @hooked woocommerce_template_loop_price - 10
				 */
				do_action( 'woocommerce_after_shop_loop_item_title' );
			?>
			<div class="btn-add tt">
			<!--<a href="<?php //echo $product->add_to_cart_url() ?>" value="<?php //echo esc_attr( $product->get_id() ); ?>" class="ajax_add_to_cart add_to_cart_button" data-product_id="<?php //echo get_the_ID(); ?>" aria-label="Add “<?php //the_title_attribute() ?>” to your cart">
Add to Cart
</a>-->

				<?php  global $product;
    $link = $product->get_permalink();
    if ( !$product->is_in_stock() ) {
		echo do_shortcode('<a href="'.$link.'" class="button addtocartbutton">Out of Stock</a>');
	}else{
		echo '<a href="'. $product->add_to_cart_url().'" value="'. esc_attr( $product->get_id() ).'" class="ajax_add_to_cart add_to_cart_button" data-product_id="'.$product->get_id() .'" aria-label="Add “<?php //the_title_attribute() ?>” to your cart">Add to Cart</a>';
	}
	//do_action( 'woocommerce_after_shop_loop_item' ); ?>
			</div>
		</div>
	</div>
	<?php
		basel_swatches_list();
	?>
</div>

<?php if ( basel_loop_prop( 'progress_bar' ) ): ?>
	<?php basel_stock_progress_bar(); ?>
<?php endif ?>

<?php if ( basel_loop_prop( 'timer' ) ): ?>
	<?php basel_product_sale_countdown(); ?>
<?php endif ?>
