<?php
/**
 * Template Name: Product Reviews
 */

get_header();
?>

<div class="shop-loop-head">
    <?php basel_current_breadcrumbs( 'shop' );   ?>
</div>
<div class="review__section">


<h1>Customer Reviews</h1>

<div class="review_customer">
    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/review-banner.png">
</div>
    <div class="reviews-filter">
    <div class="border-box">
        <div id="review-rating">

       <?php display_product_ratings_overview(); ?>
        <div class="rating allreviews" style="display:none" data-value="all">See all reviews </div>
    </div>

    <div id="reviews-container">
        <?php display_reviews();
  ?>
</div>
    </div>

    <div id="pagination-container">
		<?php display_pagination(); ?>
	</div>
</div>
<script>

jQuery(document).ready(function($) {
	var selected_rating = 'all';
	function load_reviews(rating, page) {
        $.ajax({
            url: '<?php echo admin_url("admin-ajax.php"); ?>',
            type: 'POST',
            data: {
                action: 'filter_reviews',
                rating: rating,
                page: page,
                nonce: '<?php echo wp_create_nonce("filter_reviews_nonce"); ?>'
            },
            success: function(response) {
                if(response.success) {
                    $('#reviews-container').html(response.data.reviews);
                    $('#pagination-container').html(response.data.pagination);
                } else {
                    console.log(response.data);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            }
        });
    }

    jQuery('#review-rating .rating').click(function() {
        var rating = jQuery(this).data('value');
        selected_rating = rating;
        jQuery('#review-rating .rating').removeClass('selected');
        jQuery(this).addClass('selected');
        jQuery(".allreviews").css("display", "block");
        jQuery('#reviews-container').html("Loading...");

        load_reviews(rating, 1);
    });

    $(document).on('click', '.pagination a', function(e) {
        e.preventDefault();
        var page = $(this).attr('data-page');
        var rating = selected_rating; //$('.rating').data('value');
        load_reviews(rating, page);
    });

});

</script>

<?php get_footer(); ?>
