<?php
/*
Template Name:Home-template
*/
 get_header(); ?>
<link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/scrollbar/jquery.mCustomScrollbar.css" type="text/css" media="screen" />
<script src="<?php bloginfo('template_url'); ?>/scrollbar/CustomScrollbar.js" type="text/javascript"></script>
<script>
	(function($){
		$(window).load(function(){
			$(".events-scroll").mCustomScrollbar({
				scrollButtons:{
					enable:true
				}
			});
		});
	})(jQuery);
</script>
<?php $page_url    =  site_url();?>
<div id="core" class="container_home_page">
<div class="home-banner">
	<div class="hero-slider">
	 <?php if ( have_rows('slider_images') ) {
			while ( have_rows('slider_images') ) {
			the_row();
			$slide_image = get_sub_field('slide_image'); ?>
			<div>
			 	<img src="<?php echo esc_url($slide_image['url']); ?>" alt="<?php echo esc_attr($slide_image['name']); ?>" />
			 	<div class="slider-caption">
			 		<div class="container">
							 <div class="title"><?php the_sub_field('sub_title'); ?></div>
				 		<div class="slidedesc"><?php the_sub_field('slider_title'); ?></div>
				 		<div class="slider-tag"><?php the_sub_field('slider_tag'); ?></div>
				 	</div>
			 	</div>
			</div>
			<?php
			}
		} else{
		   the_post_thumbnail( 'full' );
		}?>
	</div>
</div>
	<?php $show_banner =  get_field( "show_banner" );
	$bg_color =  get_field( "background_color" );
	if($show_banner=='1'){?>
	<div class="home_banner" style="background-color:<?php echo $bg_color;?>">
		<div class="container" >
		<?php $link = get_field('banner_link');
		   if( $link ):
			$link_url = $link['url'];
			$link_title = $link['title'];
			$link_target = $link['target'] ? $link['target'] : '_self';
			?>
			<a class="button" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
			<?php endif; ?>
			<div class="inner-bx">
					<h3 class="common-heady"><?php echo get_field( "banner_title" );?></h3>
					<p class="irish"><?php echo get_field( "banner_content" );?></p>
					<p class="content-english"><?php echo get_field( "banner_content_english" );?></p>
			</div>
			<?php  if( $link ):  ?></a>	<?php endif; ?>
			</div>
		</div>
  <?php } ?>
<div class="about_school">
	<div class="container">
		<div class="about-left">
			<h2 class="common-heading"><?php echo get_field( "title" );?></h2>
			<p class="content-irish"><?php echo get_field( "content" );?></p>
			<p class="content-english"><?php echo get_field( "english" );?></p>
			<?php echo get_field( "button_link" );?>
		</div>
       <?php
	$args = array(
	'post_type' => 'gallery',
	'posts_per_page' => '5',
	'order' => 'DESC'
	);
	$count_posts = wp_count_posts( 'gallery' )->publish;
	$my_posts = new WP_Query( $args );?>
			<div class="about-right">
				<div class="home_gallery">
					<?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
					     <div class="post-thumb-wrapp">
					     	<div class="gallery-bx">
								<?php $id = get_the_ID();?>
								<?php //echo get_the_post_thumbnail($id,'medium', array('410','240'));?>
								<?php the_post_thumbnail( 'complete_medium' );?>
								<span class="gallery-tile"><?php the_title(); ?></span>
							</div>
			           		</div>
			           		<?php endwhile;
							 wp_reset_query();?>
					</div>
					<div class="align-rgt">
						<a class="border-btn" href="<?php echo site_url();?>/gallery">
						<span>Gaileara</span> Gallery
					</a>
				</div>
			</div>
		</div>
	</div>
	<div class="second-section">
		<div class="container">
			<div class="news_section">
				<h2 class="common-heading">Nuacht - <span>News</span></h2>
				<?php echo do_shortcode( '[home_news]' );?>
			</div>
			<div class="calender-event" id="calendar">
					<div class="inner-bx">
						<div class="left-part">
							<h2 class="common-heading">Féilire - <span>Calendar</span></h2>
							<iframe src="https://www.uniqueschoolapp.ie/site/viewcalender/school_id/301/style/list/type/mobile" style="border:none;width:100%;overflow: hidden;"></iframe>
						</div>
						<div class="right-part">
							<iframe src="https://www.uniqueschoolapp.ie/site/viewcalender/school_id/301/backgroundcolor/<?php the_field( "calendar_bg_color" );?>/textcolor/<?php the_field( "calendar_text_color" );?>/eventcolor/<?php the_field( "calendar_event_color" );?>/buttoncolor/<?php the_field( "calendar_button_color" );?>/todayscolor/<?php the_field( "calendar_today_color" );?>" style="border:none;width:100%;"></iframe>
						</div>
					</div>
  		</div>
		</div>
	</div>
<div class="learning_section">
	<div class="container">
		<h2 class="common-heading">
			Ag foghlaim i gColáiste Chilliain <br>
			<span>Learning at Coláiste Chilliain</span>
		</h2>
		<div class="four_img_box">
			<?php while( have_rows('learning_pages') ): the_row();?>
			<?php $learning_pages= get_sub_field('cms_pages');?>
			<?php $page_id	= $learning_pages->ID;?>
			<div class="inner-bx">
				<div class="cms_img"><img src="<?php echo get_the_post_thumbnail_url( $page_id, 'full' );?>"></div>
				<div class="page_title"><?php echo '<a href="'. esc_url( get_page_link( $page_id ) ) .'">'.'<span class="gen-title">'.$learning_pages->post_title .'</span>' .'<span class="arrow"></span>'.'</a>';?>
				</div>
			</div>
			<?php endwhile; ?>
		</div>
	</div>
</div>
  <div class="school_description">
  	<div class="container">
  		<div class="inner-bx">
  			<div class="left-part">
  				<div class="image"><?php $image= get_field( "image" );?>
					<img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" class="top_dots" />
				</div>
  			</div>
  			<div class="right-part">
  				<div class="content_school">
  					<p class="content-irish"><?php echo get_field( "content_description" );?></p>
  					<p class="content-english"><?php echo get_field( "content_description_english" );?></p>
  				</div>
  			</div>
  		</div>
  	</div>
  </div>
  <div class="register_now">
  	<div class="container">
  		<div class="inner-bx">
  			<div class="left-part">
  				<h3 class="common-heading white-color"><?php echo get_field( "text" );?></h3>
  				<p>
				  <span class="content-irish"><?php echo get_field( "content_register" );?></span>
  					<span class="content-english"><?php echo get_field( "content_english" );?></span>
  				</p>
  			</div>
  			<div class="right-part">
  				<div class="link_register">
						<?php $link = get_field('link_button'); echo $link;?>
				</div>
  			</div>
  		</div>
  	</div>
  </div>
   <div class="contact_info" id="contact">
   	<div class="container">
   		<div class="inner-bx">
	   		<div class="left-part">
	   			<h3 class="gen-heading"><?php echo get_field('main_headline','option' ); ?></h3>
	   			<div class="address-detail-bx">
	   				<ul>
	   					<li class="call">
	   						<div class="image">
	   							<img src="<?php echo bloginfo('template_url');?>/images/mobile-image.png" alt="mobile-image">
	   						</div>
	   						<div class="text">
	   							<h4 class="sub-heading"><?php echo get_field('phone_number__headline','option' ); ?> </h4>
								<p> <a href="tel:<?php echo get_field('phone','option' ); ?>"><?php echo get_field('phone','option' ); ?></a></p>
	   						</div>
	   					</li>
	   					<li class="email">
	   						<div class="image">
	   							<img src="<?php echo bloginfo('template_url');?>/images/icon-pen.png" alt="icon-pen">
	   						</div>
	   						<div class="text">
	   							<h4 class="sub-heading"><?php echo get_field('email_headline','option' ); ?></h4>
								<p><a href="mailto:<?php echo get_field('email','option' ); ?>"><?php echo get_field('email','option' ); ?></a></p>
	   						</div>
	   					</li>
	   					<li class="find_us">
	   						<div class="image">
	   							<img src="<?php echo bloginfo('template_url');?>/images/icon-flag.png" alt="icon-flag">
	   						</div>
	   						<div class="text">
	   							<h4 class="sub-heading"><?php echo get_field('address_title','option' ); ?> </h4>
								<p><?php echo get_field('address','option' ); ?></p>
	   						</div>
	   					</li>
	   				</ul>
	   			</div>
	   		</div>
	   		<div class="right-part">
	   			<div class="map">
			<?php $map= get_field('map_right','option');
			echo  $map;?>
				</div>
	   		</div>
		</div>
	</div>
  </div>
    </div>
  <div class="clearfix"></div>
  <script>
$('.home_gallery').slick({
	dots: true,
   infinite: true,
  slidesToShow: 1,
  slidesToScroll: 1,
 responsive: [
    {
      breakpoint: 768,
      settings: {
        arrows: false,
        dots: true,
   		infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    },
    {
      breakpoint: 480,
      settings: {
        dots: true,
  	    infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    }
  ]
});
$('.hero-slider').slick({
    dots: false,
    infinite: false,
    fade: true,
    autoplay:true,
    arrows:true,
    speed: 900,
    slidesToShow: 1,
    slidesToScroll: 1
});
</script>
<script>
	$('.caledar_select').on('change', function() {
		var category = $(this).find(":selected").val();
		$.ajax({
			method: "POST",
			url: "<?php echo admin_url('admin-ajax.php')?>",
			dataType: "json",
			data: {
				action: "myfilter_event",
				filter_req: category
			},
			success: function(response) {
				if(typeof response != "undefined")
					$('#events_list').html(response.html_text);
			}
		});
	});
</script>
 <?php get_footer(); ?>
