<?php
/*CHECK IF Complete row exist in the wp_options table. Needed for Redux Conversion process*/
$completedb = get_option( 'complete' );
//**************Complete SETUP******************//
function Complete_setup() {
	//add_theme_support( 'custom-header' );
	add_theme_support( 'title-tag' );			//WP 4.1 Site Title
	add_theme_support( 'woocommerce' );			//Woocommerce Support
	add_theme_support('automatic-feed-links');	//RSS FEED LINK
	add_theme_support( 'post-thumbnails' );		//Post Thumbnail
	//Custom Background
	add_theme_support( 'custom-background', array( 'default-color' => 'ffffff') );
	//Make theme available for translation
	load_theme_textdomain('complete', get_template_directory() . '/languages/');
	//Custom Thumbnail Size
	/*add_image_size( 'complete_thumb', 400, 270, true );*/ /*(cropped)*/
	add_image_size( 'complete_thumb', 300, 300, false ); /*(cropped)*/
	add_image_size( 'complete_medium', 700, 387, true ); /*(cropped)*/
	add_image_size( 'footerthumb', 50, 42, false );
	//Register Menus
	register_nav_menus( array(
			'primary' => __( 'Header Navigation', 'complete' ),
			'footer' => __( 'Footer Navigation', 'complete' ),
			'top-menu' => __( 'Top Menu Navigation', 'complete' ),
		) );
	}
add_action( 'after_setup_theme', 'Complete_setup' );
//**************Complete FUNCTIONS******************//
require(get_template_directory() . '/sktframe/core-functions.php');			//Include Complete sktframe Core Functions
require(get_template_directory() . '/lib/functions/core.php');					//Include Core Functions
require(get_template_directory() . '/lib/functions/enqueue.php');					//Include Enqueue CSS/JS Scripts
require(get_template_directory() . '/lib/functions/admin.php');				//Include Admin Functions (admin)
require(get_template_directory() . '/lib/functions/woocommerce.php');			//Include Woocommerce Functions
require(get_template_directory() . '/lib/functions/defaults.php');
require(get_template_directory() . '/customizer/customizer.php');
require(get_template_directory() . '/lib/functions/converter.php');
require(get_template_directory() . '/lib/includes/google_fonts.php');
//WIDGETS
require(get_template_directory() . '/sktframe/core-posts.php');
require(get_template_directory() . '/sktframe/core-pagination.php');
define('SKT_THEME_DOC', 'http://sktthemesdemo.net/documentation/lms-documentation/','complete');
define('SKT_URL','https://www.sktthemes.net','complete');
define('SKT_PRO_THEME_URL','https://www.sktthemes.net/shop/lms-wordpress-theme/','complete');
define('SKT_LIVE_DEMO','http://sktperfectdemo.com/demos/education/','complete');
define('SKT_THEMES','https://www.sktthemes.net/themes/','complete');
require_once get_template_directory() . '/customize-pro/example-1/class-customize.php';
/*Custom template for about theme. */
require get_template_directory() . '/sktframe/about-themes.php';
/**
 * Add REST API support to an already registered post type.
 */
add_filter( 'register_post_type_args', 'my_post_type_args', 10, 2 );
function my_post_type_args( $args, $post_type ) {
    if ( 'event' === $post_type ) {
        $args['show_in_rest'] = true;
        $args['rest_base']             = 'events';
        $args['rest_controller_class'] = 'WP_REST_Events_Controller';
    }
    return $args;
}
add_filter( 'eventorganiser_register_taxonomy_event-categories', function( $args ) {
	$args = array_merge( array(
		'show_in_rest'          => true,
		'rest_base'             => 'event-categories',
		'rest_controller_class' => 'WP_REST_Event_Categories_Controller',
	), $args );
	return $args;
} );
add_post_type_support( 'gallery', 'thumbnail' );
function create_posttype() {
 register_post_type( 'gallery',
     array(
            'labels' => array(
                'name' => __( 'Gallery' ),
                'singular_name' => __( 'gallery' ),
            ),
            'public' => true,
            'has_archive' => true,
            'show_in_rest' => true,
			'rest_base' => "",
			'rest_controller_class' => "WP_REST_Posts_Controller",
			'exclude_from_search' => false,
			'capability_type' => "post",
            'rewrite' => array('slug' => 'gallery')
        )
    );
}
add_action( 'init', 'create_posttype' );

function vipx_remove_cpt_slug( $post_link, $post, $leavename ) {
    if ( ! in_array( $post->post_type, array( 'gallery' ,'video-gallery') ) || 'publish' != $post->post_status )
        return $post_link;
   // return $post_link;
}
//add_filter( 'post_type_link', 'vipx_remove_cpt_slug', 10, 3 );
function vipx_parse_request_tricksy( $query ) {
    // Only noop the main query
    if ( ! $query->is_main_query() )
        return;
    // Only noop our very specific rewrite rule match
    if ( 2 != count( $query->query )
        || ! isset( $query->query['page'] ) )
        return;
    // 'name' will be set if post permalinks are just post_name, otherwise the page rule will match
    if ( ! empty( $query->query['name'] ) )
        $query->set( 'post_type', array( 'post', 'activity-gallary', 'page' ) );
}
//add_action( 'pre_get_posts', 'vipx_parse_request_tricksy' );
function home_news() {
$args = array(
	'post_type' => 'post',
	'posts_per_page' => '3',
	'order' => 'DESC'
	);
	  $my_posts1 = new WP_Query( $args );
ob_start(); ?>
 <div class="media-posts">
  <?php while ( $my_posts1->have_posts() ) : $my_posts1->the_post() ?>
	<div class="gal-col all">
     <div class="pic-section">
		 <a class="read-more" href="<?php the_permalink();?>"><?php the_post_thumbnail( 'medium_large' );?></a>
       </div>
         <div class="text-box">
            <a class="read-more" href="<?php the_permalink();?>"><h3 class="sub-heading"><?php the_title();?></h3></a>
            <div class="news_date">

				<?php

					 echo get_the_date();?></div>
            <a class="read-more text-link" href="<?php the_permalink();?>"><span class="content-irish">léigh níos mó anseo</span><br>
			<span class="content-english">Read More</span></a>
           </div>
        </div>
 	<?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $content =  ob_get_clean();
    return $content;
}
add_shortcode("home_news", "home_news");
if ( function_exists( 'acf_add_options_page' ) ) {
	//acf_add_options_page( 'Global Settings' );
}
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init() {
    // Check function exists.
    if( function_exists('acf_add_options_page') ) {
        // Register options page.
        $option_page = acf_add_options_page(array(
            'page_title'    => __('Global Settings'),
            'menu_title'    => __('Global Settings'),
            'menu_slug'     => 'global-settings',
            'capability'    => 'edit_posts',
            'redirect'      => false
        ));
    }
}
function do_this_hourly_calendar(){
	$ch = curl_init();
	curl_setopt($ch,CURLOPT_URL,"https://api.uniqueschoolapp.ie/feeds/calendar?idschool=166&sort_order=asc&limit=9999");
	curl_setopt($ch,CURLOPT_HEADER,0);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
	curl_setopt($ch,CURLOPT_TIMEOUT,40);
	$response = curl_exec($ch);
	curl_close($ch);
	$events = json_decode($response);
	ob_start();
	var_dump($events);
	$args = array(
        'post_type'      => 'event',
        'posts_per_page' => -1
    );
     $posts = get_posts( $args );
    foreach ( $posts as $post ) {
		  $my_post = array(
		  'ID'           => $post->ID,
		  'post_status'    => 'draft',
		);
      wp_update_post( $my_post );
    }
    foreach ($events->data->calendar AS $event) {
		//$gallery_data == array();
		$post_array = $event_keys = array();
		$found_post = false;
		$found_post = post_exists( '','',$event->created_date,'event');
		//$found_post = post_exists( $event->title,'',$event->created_date,'event');
        if(!$found_post) {
			$post_array = array(
					'post_author' => 1,
					'post_content' => $event->description,  // content of the article,
					'post_title' => $event->title,
					'post_date' => $event->created_date,
					'post_status' => 'publish',   // i just published the post directly, but you can change the status as of your need
					'post_type' => 'event'  // if any custom post type, you can use it here
				);
			//echo "==";
			echo $starttime = ($event->start_time!='')?trim($event->start_time):'00:00:00';
			//echo "==";
			echo $endtime = ($event->end_time!='')?trim($event->end_time):'23:00:00';
			//echo "==";
			$start	= new DateTime( $event->start_date.' '.$starttime);
			$end 	= new DateTime( $event->end_date.' '.$endtime );
			$event_data = array(
				'schedule' => 'once',
				'all_day' => '',
				'start' => $start,
				'end' => $end,
				);
			$new_cat_id = '';
			echo "<br/>category data :";
			echo $new_category_name = ($event->category->name)?$event->category->name:'';
			echo "==data end<br/>";
			$category_color= ($event->color!='')?$event->color:'';
			if(!empty($new_category_name)){
				if( !get_term_by( 'name', $new_category_name, 'event-category' ) ){
					$new_cat = wp_insert_term( $new_category_name, 'event-category', array('colour' => $category_color ) );
					echo '<pre>';
					print_r($new_cat);
					echo '</pre>';
					if( !is_wp_error( $new_cat ) && $new_cat ){
						$new_cat_id = $new_cat['term_id'];
						$re = update_option( "eo-event-category_{$new_cat_id}", array( 'colour' => $category_color ) );
					}
				}
			}
			$cat = get_term_by( 'name', $new_category_name, 'event-category' );
			if( $cat )
				$event_data['tax_input']['event-category'][] =  intval( $cat->term_id );
			echo '<pre>';
			print_r($event_data);
			echo '</pre>';
			$event_post_id = eo_insert_event($post_array,$event_data);
			echo "==event id ==".$event_post_id . "==<br/>";
		}
		else
		{
			 wp_update_post(array(
				'ID'    =>  $found_post,
				'post_status'   =>  'publish'
				));
				echo "event already exixts<br/>";
		}
	}
	$args = array(
        'post_type'      => 'event',
        'post_status'    => 'draft',
        'posts_per_page' => -1
    );
     $posts = get_posts( $args );
    foreach ( $posts as $post ) {
		  $my_post = array(
		  'ID'           => $post->ID,
		  'post_status'    => 'trash',
		);
      wp_update_post( $my_post );
    }
    $log_data = ob_get_clean();
	set_transient( 'my_plugin_log', $log_data, 24 * HOUR_IN_SECONDS );
}
add_action( 'calendar_event', 'do_this_hourly_calendar' );
add_action('wp_enqueue_scripts', function(){
	wp_localize_script('handle_of_script', "Object_var", [
		"ajax_url_attr" => admin_url( 'admin-ajax.php' )
	]);
});
add_action( 'wp_ajax_nopriv_myfilter_event', 'myfilter_event' );
add_action( 'wp_ajax_myfilter_event', 'myfilter_event' );
function myfilter_event(){
	$filter_req = $_POST['filter_req'];
	// Run filter of whatever
	if(!empty($filter_req)){
		$events = eo_get_events(array(
			'numberposts'=>100,
			'event_start_after'=>'today',
			'showpastevents'=>false,
			'tax_query'=>array( array(
			'taxonomy'=>'event-category',
			'operator' => 'IN',
			'field'=>'slug',
			'terms'=>array($filter_req)
		 ))));
	}
	else{
		$events = eo_get_events(array(
			'numberposts'=>100,
			'event_start_after'=>'today',
			'showpastevents'=>false,//Will be deprecated, but set it to true to play it safe.
			));
	}	// Convert values to html/text
	$html_text = convert_to_html_text($events);
	$atts['event_category'] = $filter_req;
	$calendar_text = eo_get_event_fullcalendar($atts);
	$return = array('html_text' => $html_text,'calendar_text' => $calendar_text);
	wp_send_json($return);
	wp_exit();
};
function convert_to_html_text($events) {
$html_text = "";
ob_start();
if($events){?>
	<ul>
		<?php foreach ($events as $event):
			$format = ( eo_is_all_day($event->ID) ? get_option('date_format') : get_option('date_format').' '.get_option('time_format') );
			$circle_color	= (!empty(eo_get_event_color($event->ID)))?eo_get_event_color($event->ID):'#EFAC1F'; ?>
			<li>
				<span class="color_circle" style="background-color:<?php echo $circle_color;?>">&nbsp;</span>
				<a href="<?php echo get_permalink($event->ID);?>"> <?php echo get_the_title($event->ID);?></a>
				<br/>
				<span class="calendar"></span>
				<?php echo eo_get_the_start( $format, $event->ID, $event->occurrence_id );?>
			</li>
		<?php endforeach; ?>
	</ul>
<?php }
	else{ ?>
	<ul>
		<li>No Incoming Event.</li>
	</ul>
	<?php };
	$html_text = ob_get_clean();
	return $html_text;
}
function eo_assign_default_event_color( $color, $event_id ){
    if( empty( $color ) ){
        $color = '#EFAC1F'; //rust
    }
    return $color;
}
add_filter( 'eventorganiser_event_color', 'eo_assign_default_event_color', 10, 2 );
function my_error_notice() { ?>
<div class="error notice">
	<p><?php _e( 'For More Options buy pro version <a href="https://www.sktthemes.net/shop/lms-wordpress-theme/" target="_blank">Buy Now</a>', 'complete');?></p>
</div>
<?php }
add_action( 'admin_notices', 'my_error_notice' );
function my_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/assets/images/logo.png);
            width: 103px; height: 141px; background-size: 100%; background-color: transparent; padding: 0; background-position: center;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );
add_filter( 'login_headerurl', 'custom_loginlogo_url' );
function custom_loginlogo_url($url) {
    return home_url();
}

function translate_month_name($date) {
    $months = array(
        'January' => 'Eanáir',
        'February' => 'Feabhra',
        'March' => 'Márta',
        'April' => 'Aibreán',
        'May' => 'Bealtaine',
        'June' => 'Meitheamh',
        'July' => 'Iúil',
        'August' => 'Lúnasa',
        'September' => 'Meán Fómhair',
        'October' => 'Deireadh Fómhair',
        'November' => 'Samhain',
        'December' => 'Nollaig'
    );
    return str_replace(array_keys($months), array_values($months), $date);
}

add_filter('the_date', 'translate_month_name');
add_filter('get_the_date', 'translate_month_name');

function irish_date_shortcode($atts) {
    // Parse attributes and set default date to today if not provided
    $atts = shortcode_atts(array(
        'date' => 'today'
    ), $atts, 'irish_date');
    // Create a DateTime object from the provided date
    $date = new DateTime($atts['date']);

    // Create a formatter for the Irish locale
    $formatter = new IntlDateFormatter('ga_IE', IntlDateFormatter::LONG, IntlDateFormatter::NONE);

    // Format the date
    $formattedDate = $formatter->format($date);

    // Return the formatted date
    return $formattedDate;
}

// Register the shortcode
add_shortcode('irish_date', 'irish_date_shortcode');