<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo e($title); ?> : <?php echo e($subTitle); ?></h1>
        <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
    <!-- Main content -->
    <section class="content main_box">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="box box-primary">
                    <?php echo e(Form::model($userDetail, array('route' => array($controllerUri.'.update', \Crypt::encryptString($userDetail->id)), 'method' => 'PUT', 'novalidate' => 'false', 'files' => true,'id'=>$formId))); ?>


                    <div class="box-body form_box">
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">First Name</label>
                                    <?php echo e(Form::text('first_name', $userDetail->first_name, ['class'=>'form-control required', 'id'=>'firstName','placeholder' => 'First Name', 'onchange' => "return trim(this)"])); ?>

                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Last Name</label>
                                    <?php echo e(Form::text('last_name', $userDetail->last_name, ['class'=>'form-control required', 'id'=>'lastName','placeholder' => 'Last Name', 'onchange' => "return trim(this)"])); ?>

                                </div>
                            </div>
                        </div>

                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="username">Username</label>
                                    <?php echo e(Form::text('user_name', $userDetail->user_name, ['class'=>'form-control required', 'id'=>'username','placeholder' => 'Username', 'onchange' => "return trim(this)"])); ?>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Email</label>
                                    <?php echo e(Form::email('', $userDetail->email, ['class'=>'form-control required customemail', 'id'=>'email','placeholder' => 'Email', 'onchange' => "return trim(this)" , 'disabled'=>'disabled'])); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="form-group">

                                    <label for="exampleInputEmail1" class="col-md-12">Phone Number</label>
                                    <div class="col-md-3">
                                        <input value="+233" class="form-control" type="text" disabled>  
                                    </div>
                                    <div class="col-md-9">
                                    <?php echo e(Form::number('phone_number', !empty($userDetail->phone_number) ? $userDetail->phone_number : '', ['class'=>'form-control required', 'id'=>'phone_number','placeholder' => 'Phone number: eg; 9876543210', 'onchange' => "return trim(this)"])); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Status</label>
                                    <?php echo e(Form::select('status',[1 => 'Active', 0 => 'Inactive'], ((isset($userDetail->status) && is_numeric($userDetail->status)) ? $userDetail->status : 0), ['class'=>'form-control'])); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row input_row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-7">
                                        <div class="image-upload">
                                            <div class="file-label" style="text-align: left">Upload Image</div>
                                            <?php echo e(Form::file('avatar', ['id' => 'avatar'])); ?>

                                        </div>
                                    </div>
                                <?php if(!empty($userDetail->profile_image)): ?>
                                <div class="ImgPopup productimages" style="cursor: pointer"
                                        href="<?php echo e($userDetail->profile_image); ?>">
                                    <?php echo e(Html::image($userDetail->profile_image, null, array('style' => 'max-width:100px;', 'id' => 'headshot_preview','title' => 'Image Preview'))); ?>

                                    </div>
                                <?php else: ?>
                                <div class="imgpreview" href="<?php echo e($defaultAvatarUrl); ?>">
                                    <?php echo e(Html::image($defaultAvatarUrl, null, array('style' => 'max-width:100px;', 'id' => 'headshot_preview', 'title' => 'Image Preview'))); ?>

                                </div>
                                <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-footer row">
                        <div class="col-md-6">
                            <?php echo e(Form::submit('Submit', array('class'=>'btn btn-success pull-right'))); ?>

                        </div>
                        <div class="col-md-6">
                            <a href="<?php echo e(route('customer.index')); ?>">
                                <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                            </a>
                        </div>
                    </div>
                    <?php echo e(Form::close()); ?>

                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Admin.adminForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/customer/edit.blade.php ENDPATH**/ ?>