<?php $__env->startSection('content'); ?>
<?php
$id = \Crypt::encryptString($profileData->id);
$editUrl = env('VENDOR_URL').'/profile/'.$id.'/edit';
?>
<div class="container restaurant-pro">
    <div class="row page-heading">
        <div class="col-lg-4 col-md-6 col-50">
            <h1 class="page-title">Restaurant Profile</h1>
        </div>
        <div class="col-lg-8 col-md-6 col-50 edit-detail">
            <a href="<?php echo e($editUrl); ?>"><i class="icons pencil"></i>Edit Profile</a>
        </div>
    </div>
    <div class="border-box">
        <div class="profile-detail">
            <div class="col-lft">
                <h2><?php echo e($profileData->name); ?></h2>
                <div class="items-align"><i class="icons map-marker"></i>
                    <p><?php echo e($profileData->address1); ?></p>
                </div>
            </div>
            <div class="col-rgt">
                <div class="column">
                    <div class="items-align"><i class="icons envelope"></i> <span
                            class="emailid"><?php echo e($profileData->user->email); ?></span></div>
                    <a href="#change-email" data-toggle="modal" data-keyboard="true" data-keyboard="true"
                        class="text-link">Change</a>
                </div>
                <div class="column">
                    <div class="items-align"><i class="icons phone"></i> +233 <?php echo e($profileData->user->phone_number); ?>

                    </div>
                    <a href="#change-phone-number" data-toggle="modal" data-keyboard="true" class="text-link">Change</a>
                </div>
            </div>
        </div>
        <div class="description">
            <div class="cnt">
                <h3>Restaurant bio</h3>
                <p><?php echo e($profileData->bio); ?></p>
            </div>
            <div class="item-pic">
                <figure>
                    <?php if(!empty($userAvatar)): ?>
                <img id="imagePreview" src="<?php echo e($userAvatar); ?>">
                <?php else: ?>
                <img id="imagePreview" src="<?php echo e(config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE')); ?>" alt="<?php echo e($profileData->name); ?>" title="<?php echo e($profileData->name); ?>">
                <?php endif; ?>


                <?php if(!empty($profileData->delivery_time)): ?>
                    <figcaption>Delivery Time: <strong><?php echo e($profileData->delivery_time); ?> min</strong></figcaption>
                <?php endif; ?>
                </figure>
            </div>
        </div>
    </div><!-- border-box -->
</div>





<!------ Add Comment modal Popup ------>
<div class="modal fade" id="change-email" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content small-box">
                

                <div id="change-email-div" class="">

                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">Change Email Address</h4>
                        <button type="button" class="close" data-dismiss="modal"><i class="icons cross-icon"></i></button>
                    </div>

                    <?php echo e(Form::open(array('url' => $url.'/change-email', 'method' => 'post' , 'class'=>'form-section' , 'id'=>'changeEmailForm'))); ?>


                    <div class="modal-body">
                        <div id="change-email-error-msg"></div>
                        <div class="form-group">
                            <label>Old email</label>
                            <input type="text" name="old_email" id="old_email" class="form-control"
                                placeholder="Enter old email address">
                            <span id="old_email_error" class="validation-error"></span>
                        </div>
                        <div class="form-group">
                            <label>New email</label>
                            <input type="text" name="new_email" id="new_email" class="form-control"
                                placeholder="Enter new email address">
                            <span id="new_email_error" class="validation-error"></span>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-primary clear-validation">Submit</button>
                    </div>
                    <?php echo e(Form::close()); ?>

                </div>

                <div id="verify-password-div" class="profileChangeEmail">
                        <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">Change Email Address</h4>
                        <button type="button" class="close" data-dismiss="modal"><i class="icons cross-icon"></i></button>
                    </div>
                    <?php echo e(Form::open(array('url' => $url.'/validate-current-password', 'method' => 'post' , 'class'=>'form-section' , 'id'=>'validateCurrentPasswordForm'))); ?>

                    <div class="modal-body">
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" id="password" class="form-control"
                                placeholder="Enter your password">
                            <span id="password_error" class="validation-error"></span>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-primary clear-validation">Submit</button>
                    </div>
                    <?php echo e(Form::close()); ?>


                </div>

                <div id="verify-otp-div" class="profileChangeEmail">
                    <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">Verification Code</h4>
                    <button type="button" class="close" data-dismiss="modal"><i class="icons cross-icon"></i></button>
                </div>
                    <?php echo e(Form::open(array('url' => $url.'/verify-otp', 'method' => 'post' , 'class'=>'form-section' , 'id'=>'verifyOtpFormEmailChange'))); ?>

                    <div class="modal-body">
                        <p>Please enter the verification code sent to your registered Email ID</p>
                        <div class="form-group verification">
                            <div class="verification-code">Enter Verification Code</div>
                            <div class="row d-flex verification-no">
                                <div class="col">
                                    <input type="number" name="otp[]" class="form-control otp-input" maxlength="1" autofocus="" tabindex="1"
                                        required />
                                </div>
                                <div class="col"><input type="number" name="otp[]" maxlength="1" class="form-control otp-input" tabindex="2"
                                        required /></div>
                                <div class="col"><input type="number" name="otp[]" maxlength="1" class="form-control otp-input" tabindex="3"
                                        required /></div>
                                <div class="col"><input type="number" name="otp[]" maxlength="1" class="form-control otp-input" tabindex="4"
                                        required /></div>
                            </div>
                            <span id="otp_error" class="validation-error"></span>
                            <div class="form-group time" id="remaining-div-change-email">
                                Remaining time: <strong id="remaining-time-change-email"></strong>
                            </div>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="modal-footer justify-content-center">
                        <button type="submit" id="verify-otp-btn" class="btn btn-primary clear-validation">Verify now</button>
                        <button type="button" data-url="<?php echo e($url); ?>" style="display: none;" id="resent-otp-btn"
                            class="btn btn-primary">Resend OTP</button>
                    </div>
                    <?php echo e(Form::close()); ?>


                </div>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="change-email-success-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content small-box">
                <div class="modal-body success-model success-model-profile delete-model">
                    <div class="yes-icon"><span></span></div>
                    <h3>Success!</h3>
                    <p>Your email address has been changed successfully!</p>
                    <a href="<?php echo e($url); ?>" class="btn btn-primary">My Profile</a>
                </div>
            </div>
        </div>
    </div>
</div>








<!------ Change Phone Number modal Popup ------>
<div class="modal fade" id="change-phone-number" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
    aria-hidden="true">
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content small-box">
                

                <div id="change-phone-div" class="">
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">Change Phone Number</h4>
                        <button type="button" class="close" data-dismiss="modal"><i class="icons cross-icon"></i></button>
                    </div>

                    <?php echo e(Form::open(array('url' => $url.'/change-phone-number', 'method' => 'post' , 'class'=>'form-section' , 'id'=>'changePhoneNumberForm'))); ?>


                    <div class="modal-body">
                        <div class="form-group">
                            <label>Old Number</label>
                            <input type="number" name="old_number" id="old_number" class="form-control"
                                placeholder="Enter Old Phone Number">
                            <span id="old_number_error" class="validation-error"></span>
                        </div>
                        <div class="form-group">
                            <label>New Phone Number</label>
                            <input type="number" name="new_number" id="new_number" class="form-control"
                                placeholder="Enter New Phone Number">
                            <span id="new_number_error" class="validation-error"></span>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-primary clear-validation">Submit</button>
                    </div>
                    <?php echo e(Form::close()); ?>

                </div>



                <div id="verify-phone-otp-div" class="profileChangeEmail">
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">Verification Code</h4>
                        <button type="button" class="close" data-dismiss="modal"><i class="icons cross-icon"></i></button>
                    </div>
                    <?php echo e(Form::open(array('url' => $url.'/verify-sms-otp', 'method' => 'post' , 'class'=>'form-section' , 'id'=>'verifyOtpNumberForm'))); ?>

                    <div class="modal-body">
                        <p>Please enter the verification code sent to your Phone Number</p>
                        <div class="form-group verification">
                            <div class="verification-code">Enter Verification Code</div>
                            <div class="row d-flex verification-no">
                                <div class="col">
                                    <input type="number" name="otp[]" class="form-control otp-input" maxlength="1" autofocus="" tabindex="5"
                                        required />
                                </div>
                                <div class="col"><input type="number" name="otp[]" maxlength="1" class="form-control otp-input" tabindex="6"
                                        required /></div>
                                <div class="col"><input type="number" name="otp[]" maxlength="1" class="form-control otp-input" tabindex="7"
                                        required /></div>
                                <div class="col"><input type="number" name="otp[]" maxlength="1" class="form-control otp-input" tabindex="8"
                                        required /></div>
                            </div>
                            <span id="sms_otp_error" class="validation-error"></span>
                            <div class="form-group time" id="remaining-div-sms">
                                Remaining time: <strong id="remaining-time-sms-otp"></strong>
                            </div>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="modal-footer justify-content-center">
                        <button type="submit" id="verify-sms-otp-btn" class="btn btn-primary clear-validation">Verify now</button>
                        <button type="button" data-url="<?php echo e($url); ?>" style="display: none;" id="resent-sms-otp-btn"
                            class="btn btn-primary">Resend OTP</button>
                    </div>

                    <?php echo e(Form::close()); ?>


                </div>


               

            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="change-phone-no-success-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content small-box">
                <div class="modal-body success-model success-model-profile delete-model">
                    <div class="yes-icon"><span></span></div>
                    <h3>Success!</h3>
                    <p>Your Phone Number has been changed successfully!</p>
                    <a href="<?php echo e($url); ?>" class="btn btn-primary">My Profile</a>
                    <br><br><br><br>
                </div>
            </div>
        </div>
    </div>
</div>










<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Vendor.vendorDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/profile/index.blade.php ENDPATH**/ ?>