<?php $__env->startSection('content'); ?>

        <div class="container dashboard-page">
            <div class="row">
                <div class="col column-1">
                    <div class="time">
                    <?php
                    date_default_timezone_set("Africa/Accra");
                    echo date("h:i a");
                    ?>
                    </div>
                    <!-- <div class="status rstOnOffLine"><i class="icons switeh-icon"></i> Online</div> -->
                    <div class="status">
                   <?php if(Auth::guard('restaurant')->user()->is_active): ?>
                        <label class="switch rstOnOffLine">
                          <input type="checkbox" checked>
                          <span class="slider round"></span>
                        </label>
                    Online
                    <?php else: ?>
                    <label class="switch rstOnOffLine">
                          <input type="checkbox">
                          <span class="slider round"></span>
                        </label>
                    Offline
                    <?php endif; ?>
                    </div>

                </div>
            </div><!-- Row end -->
            <div class="row page-heading pt-0">
                <div class="col">
                    <h1 class="page-title">Dashboard</h1>
                </div>
            </div><!-- Row end -->
            <div class="row ">
                <div class="col card-section">


                    <a href="<?php echo e(env('VENDOR_URL').'/order'); ?>" class="card-box order">
                      <div class="cnt">
                            <div class="title">Orders</div>
                            <strong><?php echo e(isset($ordersCount)? $ordersCount: 0); ?></strong>
                        </div>
                        <div class="icon">
                            <span class="circle"><i class="icons order-icon"></i></span>
                        </div>
                     </a>


                    <a href="<?php echo e(env('VENDOR_URL').'/menu'); ?>" class="card-box items">
                        <div class="cnt">
                            <div class="title">Menu Items</div>
                            <strong><?php echo e(isset($menuItemsCount)? $menuItemsCount: 0); ?></strong>
                        </div>
                        <div class="icon">
                            <span class="circle"><i class="icons item-icon"></i></span>
                        </div>
                    </a>

                    <div class="card-box revenue">
                        <div class="cnt">
                            <div class="title">Total Revenue</div>
                            <strong><i class="symble-icon"><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                               <?php echo e(isset($revenueCount->total_revenue)? $revenueCount->total_revenue: 0); ?>

                           </strong>
                        </div>
                        <div class="icon">
                            <span class="circle"><i class="icons revenue-icon"></i></span>
                        </div>
                    </div>
                </div>
            </div><!-- Row end -->
            <div class="border-box gray-bg pb-0">
                <div class="row">
                    <div class="col">
                        <div class="page-subtitle">
                            <h2>Today’s Completed Orders</h2>
                            <a href="<?php echo e(Url('/securerestaurant/order')); ?>" class="view-order"> View All Orders
                                <i class="icons arrow-yellow"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php if(isset($orderDetails[0])): ?>
                     <div class="col">
                                <div class="order-complete">
                                    <?php $__currentLoopData = $orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="white-box">
                                        <div class="order-id">
                                            <strong>
                                                <a href="<?php echo e(env('VENDOR_URL').'/order/'.\Crypt::encryptString($value->id)); ?>">#<?php echo e($value->id); ?></a></strong>
                                            <?php
                                            date_default_timezone_set("Africa/Accra");
                                            echo date_format($value->created_at,"d M, h:i a");
                                            ?>
                                        </div>
                                        <div class="order-amount">
                                            Order Amount
                                            <strong class="amount"><i class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                                                <!-- <?php echo e(number_format(($value->sub_total + $value->tax), 2, '.', '')); ?> -->

                                                <?php echo e(number_format(($value->sub_total), 2, '.', '')); ?>


                                            </strong>
                                        </div>
                                        <div class="completed">
                                            <span class="green-btn">Completed</span>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                    <?php else: ?>
                    <div class="col no-order">
                        <div class="cnt">
                            <i class="icons no-order-icon"></i>
                            There is no order has been completed today
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div><!-- border-box -->
        </div>
<!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Vendor.vendorDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/vendor/dashboard.blade.php ENDPATH**/ ?>