<?php $__env->startSection('content'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo e($title); ?><small><?php echo e($subTitle); ?></small></h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Dashboard</a></li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo e(!empty($publicCustomerCount) ? $publicCustomerCount : '0'); ?></h3>
                        <p>Customers</p>
                    </div>
                    <div class="icon">
                        <!-- <i class="ion ion-stats-bars"></i> -->
                    </div>
                    <a href="<?php echo e($url.'/customer'); ?>" class="small-box-footer">View Customers <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo e(!empty($deliveryPersonCount) ? $deliveryPersonCount : '0'); ?></h3>
                        <p>Delivery Persons</p>
                    </div>
                    <div class="icon">
                        <!-- <i class="ion ion-bag"></i> -->
                    </div>
                    <a href="<?php echo e($url.'/delivery-persons'); ?>" class="small-box-footer">View Delivery Persons<i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo e(!empty($restaurantOwnerCount) ? $restaurantOwnerCount : '0'); ?></h3>
                        <p>Restaurants</p>
                    </div>
                    <div class="icon">
                        <!-- <i class="ion ion-person-add"></i> -->
                    </div>
                    <a class="small-box-footer" href="<?php echo e($url.'/restaurant'); ?>">View Restaurants <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo e(!empty($totalOrderCount) ? $totalOrderCount : '0'); ?></h3>
                        <p>Orders</p>
                    </div>
                    <div class="icon">
                        <!-- <i class="ion ion-pie-graph"></i> -->
                    </div>
                    <a href="<?php echo e($url.'/order'); ?>" class="small-box-footer">View Orders <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
        </div>

        <!-- TABLE: Recent Order -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><strong>Recent Orders</strong></h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="table-responsive">
                    <?php if($orderData->count() > 0): ?>
                    <table class="table no-margin">
                        <thead>
                            <tr>
                                <th>Sr.No.</th>
                                <th>Order ID</th>
                                <th>Customer Name</th>
                                <th>Delivery Person Name</th>
                                <th>Restaurant Name</th>
                                <th>Order Date</th>
                                <th>Order Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $srNo = 1;
                            ?>
                            <?php $__currentLoopData = $orderData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($srNo++); ?></td>
                                <td>
                                <a href="<?php echo e(url($url.'/order/'.\Crypt::encryptString($order->id))); ?>">
                                    <?php echo e($order->id); ?>

                                </a>    
                                
                                </td>
                                <td>
                                    <a href="<?php echo e(url($url.'/customer/'.\Crypt::encryptString($order->user_id))); ?>" class="various"data-fancybox-type="iframe" title="View">
                                        <?php echo e($order->user->first_name.' '.$order->user->last_name); ?>

                                    </a>
                                </td>
                                <td> 
                                    <?php if(!empty($order->deliveryPerson)): ?>
                                        <a href="<?php echo e(url($url.'/delivery-persons/'.\Crypt::encryptString($order->delivery_person_id))); ?>" class="various" data-fancybox-type="iframe" title="View">
                                        <?php echo e($order->deliveryPerson->user->first_name.' '.$order->deliveryPerson->user->last_name); ?>

                                       </a>
                                    <?php else: ?>
                                       <?php echo e('N/A'); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(url($url.'/restaurant/'.\Crypt::encryptString($order->restaurant_id))); ?>" 
                                        class="various" data-fancybox-type="iframe" title="View"><?php echo e($order->restaurant->name); ?>

                                    </a>
                                </td>
                                <td><?php echo e(\Carbon\Carbon::parse($order->created_at)->format('d-M-Y')); ?></td>
                                <td><?php echo e($order->orderStatus->name); ?></td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php else: ?>
                    <table class="table">
                        <tr>
                            <td colspan="10" class="text-danger text-center error-msg">
                                <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                        </tr>
                    </table>
                    <?php endif; ?>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                <a href="<?php echo e($url.'/order'); ?>" class="btn btn-sm btn-default btn-flat pull-right">View All Order</a>
            </div>
            <!-- /.box-footer -->
        </div>
        <!-- End Recent Order -->
         
         <!-- TABLE: Recent Customer -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><strong>Recent customers</strong></h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                            class="fa fa-times"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="table-responsive">
                    <?php if($customerData->count() > 0): ?>
                    <table class="table no-margin">
                        <thead>
                            <tr>
                                <th>Sr.No.</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Image</th>
                                <th>Phone Number</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $srNo = 1;
                            ?>
                            <?php $__currentLoopData = $customerData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($srNo++); ?></td>
                                <td><a href="<?php echo e(url($url.'/customer/'.\Crypt::encryptString($value->id))); ?>"
                                        class="various" data-fancybox-type="iframe" title="View"><?php echo e($value->first_name); ?></a>
                                </td>
                                <td><?php echo e(!empty($value->last_name) ? $value->last_name: \config('admin.constants.EmptyNotation')); ?></td>
                                <td><?php echo e(!empty($value->email)? $value->email: \config('admin.constants.EmptyNotation')); ?>

                                </td>
                                <td>
                                    <?php if(!empty($value->profile_image)): ?>
                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                        href="<?php echo e($value->profile_image); ?>">
                                        <?php echo e(Html::image($value->profile_image, '', array('width' => 50,'height' => 50, 'title' => 'Profile Image'))); ?>

                                    </div>
                                    <?php else: ?>
                                    <div class="imgpreview" href="<?php echo e($defaultAvatarUrl); ?>">
                                        <?php echo e(Html::image($defaultAvatarUrl, null, array('width' => 50, 'height' => 50))); ?>

                                    </div>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(!empty($value->phone_number) ? $value->phone_number : \config('admin.constants.EmptyNotation')); ?></td>
                                <td>
                                    <span class="label <?php echo e($value->status ? "label-success" : "label-danger"); ?>">
                                        <?php echo e($value->status?"Active":"Inactive"); ?></span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php else: ?>
                    <table class="table">
                        <tr>
                            <td colspan="10" class="text-danger text-center error-msg">
                                <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                        </tr>
                    </table>
                    <?php endif; ?>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                <a href="<?php echo e($url.'/customer'); ?>" class="btn btn-sm btn-default btn-flat pull-right">View All customer</a>
            </div>
            <!-- /.box-footer -->
        </div>
        <!-- End Recent Customer -->

        <!-- TABLE: Recent Restaurants -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><strong>Recent Restaurants</strong></h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                            class="fa fa-times"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="table-responsive">
                    <?php if($restaurantData->count() > 0): ?>
                    <table class="table no-margin">
                        <thead>
                            <tr>
                                <th>Sr.No.</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone Number</th>
                                <th>Profile Pic</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $srNo = 1;
                            ?>
                            <?php $__currentLoopData = $restaurantData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($srNo++); ?></td>
                                <td><a href="<?php echo e(url($url.'/restaurant/'.\Crypt::encryptString($user->restaurant->id))); ?>"
                                        class="various" data-fancybox-type="iframe" title="View"><?php echo e($user->restaurant->name); ?></a>
                                </td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->phone_number); ?></td>
                                <td>
                                <?php
                                    $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id'=>$user->id])->latest()->first();
                                    ?>
                                    <?php if(!empty($userAvatar->avatar)): ?>
                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                        href="<?php echo e($userAvatar->avatar); ?>">
                                        <?php echo e(Html::image($userAvatar->avatar, '', array('width' => 50,'height' => 50, 'title' => 'Restaurant Image'))); ?>

                                    </div>
                                    
                                    <?php else: ?>
                                    <div class="imgpreview" href="<?php echo e($defaultAvatarUrl); ?>">
                                        <?php echo e(Html::image($defaultAvatarUrl, null, array('width' => 50, 'height' => 50))); ?>

                                    </div>
                                <?php endif; ?>
                                </td>
                                <td>
                                    <span class="label <?php echo e($user->status ? "label-success" : "label-danger"); ?>"><?php echo e($user->status?"Active":"Inactive"); ?></span>
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php else: ?>
                    <table class="table">
                        <tr>
                            <td colspan="10" class="text-danger text-center error-msg">
                                <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                        </tr>
                    </table>
                    <?php endif; ?>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                <a href="<?php echo e($url.'/restaurant'); ?>" class="btn btn-sm btn-default btn-flat pull-right">View All Restaurants</a>
            </div>
            <!-- /.box-footer -->
        </div>
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/admin/dashboard.blade.php ENDPATH**/ ?>