<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> <?php echo e($title); ?> </h1>
            <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                <?php echo e(Form::open(['method' => 'get', 'class' => 'form-horizontal'])); ?>

                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-3">
                                        <?php echo e(Form::text('search', app('request')->input('search'), ['placeholder' => 'Order ID', 'class' => 'form-control'])); ?>

                                    </div>
                                    <div class="col-sm-3">
                                        <?php echo e(Form::select('restaurant', $restaurantList, app('request')->input('restaurant'), ['placeholder' => 'Select Restaurant', 'class' => 'form-control select2'])); ?>

                                    </div>

                                    <div class="col-sm-2">
                                        <?php echo e(Form::select('payment_status', [0 => 'Un-Paid', 1 => 'Paid'], app('request')->input('payment_status'), ['placeholder' => 'Payment Status', 'class' => 'form-control'])); ?>

                                    </div>
                                    <div class="col-sm-2">
                                        <?php echo e(Form::date('start_date', app('request')->input('start_date'), ['placeholder' => 'End Date', 'class' => 'form-control'])); ?>

                                    </div>

                                    <div class="col-sm-2">
                                        <?php echo e(Form::date('end_date', app('request')->input('end_date'), ['placeholder' => 'End Date', 'class' => 'form-control'])); ?>

                                    </div>

                                    <br><br>
                                    <div class="col-sm-2">
                                        <?php echo e(Form::submit('Search', ['class' => 'btn btn-success'])); ?>

                                        <a href="<?php echo e($url); ?>" class="btn btn-default">Reset</a>
                                    </div>

                                    <div class="col-sm-2 pull-right">
                                        <button type="button" class="btn btn-primary"
                                            onclick="restaurantAmountPayHandler()">Pay Now</button>
                                    </div>
                                </div>

                                <?php echo e(Form::close()); ?>

                            </div>
                        </div>
                        <div class="box-body">
                            <?php if(count($orderList) > 0): ?>
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="selectAllCheckbox" value="">
                                                    Select all
                                                </th>
                                                <th width="15%">Order ID</th>
                                                <th>Restaurant Name</th>
                                                <th>Customer Name</th>
                                                <th>Order Amount</th>
                                                <th>Commission</th>
                                                <th>Tax</th>
                                                <th>Amount To Pay</th>
                                                <th>Revenue</th>
                                                <th>Order Date</th>
                                                <th>Payment Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $srNo = $limit * ($page - 1) + 1;
                                            ?>
                                            <?php $__currentLoopData = $orderList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <div class="td-count-checkbox">

                                                            <span><?php echo e($srNo++); ?></span>
                                                            <?php if($order->vendor_payment_status == 0): ?>
                                                                <input type="checkbox"
                                                                    class="selectAll orderCheckBox checkbox"
                                                                    value="<?php echo e($order->id); ?>">
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(url($orderUrl . '/' . \Crypt::encryptString($order->id))); ?>"
                                                            title="View" target="_blank">
                                                            <?php echo e($order->id); ?>

                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(url($restaurantUrl . '/' . \Crypt::encryptString($order->restaurant_id))); ?>"
                                                            class="various" data-fancybox-type="iframe" title="View">
                                                            <?php echo e($order->restaurant->name); ?>

                                                        </a>
                                                    </td>


                                                    <td>
                                                        <a href="<?php echo e(url($customerUrl . '/' . \Crypt::encryptString($order->user_id))); ?>"
                                                            class="various" data-fancybox-type="iframe" title="View">
                                                            <?php echo e($order->firstname . ' ' . $order->lastname); ?>

                                                        </a>
                                                    </td>

                                                    <td><?php echo e($order->total_amount); ?></td>
                                                    <td><?php echo e($order->commission); ?></td>
                                                    <td><?php echo e($order->tax); ?></td>
                                                    <td><?php echo e($order->sub_total - $order->commission); ?></td>
                                                    <td><?php echo e($order->revenue_on_delivery_charge); ?></td>

                                                    <td><?php echo e(\Carbon\Carbon::parse($order->created_at)->format('d-M-Y')); ?>

                                                    </td>
                                                    <td><?php echo e($order->vendor_payment_status == 1 ? 'Paid' : 'Un-Paid'); ?>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                                    </tr>
                                </table>
                            <?php endif; ?>
                        </div>
                        <?php if(count($orderList) > 0): ?>
                            <?php echo $__env->make('elements.Admin.pagination-link', [
                                'dataList' => $orderList,
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/transaction/restaurant/index.blade.php ENDPATH**/ ?>