<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> <?php echo e($title); ?> </h1>
        <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            <?php echo e(Form::open(array('method' => 'get','class' => 'form-horizontal'))); ?>

                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    <?php echo e(Form::text('search', app('request')->input('search'), ['placeholder'=>'Name, Email', 'class'=>'form-control'])); ?>

                                </div>
                                <div class="col-sm-2">
                                    <?php echo e(Form::submit('Submit', ['class'=>'btn btn-success'])); ?>

                                    <a href="<?php echo e($url); ?>" class="btn btn-default">Reset</a>
                                </div>
                            </div>
                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                    <div class="box-body">
                        <?php if(count($contactSupportList) > 0): ?>
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Title</th>
                                        <th>Message</th>
                                        <th>Created On</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    ?>
                                    <?php $__currentLoopData = $contactSupportList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contactSupport): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                 
                                    <tr>
                                        <td><?php echo e($srNo++); ?></td>

                                        <td>
                                            <?php if(!empty($contactSupport->users->full_name) || !empty($contactSupport->users->restaurant->name)): ?>
                                            <?php if($contactSupport->users->role_id == config('admin.constants.RESTAURANT_OWNER_ROLE')): ?>
                                                <a href="<?php echo e(url($adminUrl.'/restaurant/'.\Crypt::encryptString($contactSupport->users->restaurant->id))); ?>"
                                                class="various" data-fancybox-type="iframe"
                                                title="View"><?php echo e(!empty($contactSupport->users->restaurant->name) ? $contactSupport->users->restaurant->name :\config('admin.constants.EmptyNotation')); ?></a>
                                            <?php else: ?> 
                                                <a href="<?php echo e(url($adminUrl.'/customer/'.\Crypt::encryptString($contactSupport->users->id))); ?>"
                                                class="various" data-fancybox-type="iframe"
                                                title="View"><?php echo e(!empty($contactSupport->users->full_name) ? $contactSupport->users->full_name :\config('admin.constants.EmptyNotation')); ?></a>
                                            <?php endif; ?>


                                            <?php else: ?>
                                            <span><?php echo e(\config('admin.constants.EmptyNotation')); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <?php echo e(!empty($contactSupport->users->email) ? $contactSupport->users->email : \config('admin.constants.EmptyNotation')); ?>

                                        </td>
                                        <td>
                                            <?php echo e(!empty($contactSupport->title->name) ? $contactSupport->title->name : $contactSupport->titleString); ?>

                                        </td>
                                        <td>
                                            <?php echo e(!empty($contactSupport->message) ? $contactSupport->message : \config('admin.constants.EmptyNotation')); ?>

                                        </td>

                                        <td>
                                            <?php echo e(\Carbon\Carbon::parse($contactSupport->created_at)->format('d M Y')); ?>

                                        </td>

                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    <?php echo e(config('flash_msg.NoRecordFound')); ?>

                                </td>
                            </tr>
                        </table>
                        <?php endif; ?>
                    </div>
                    <!-- /.box-body -->
                    <?php if(count($contactSupportList) > 0): ?>
                    <?php echo $__env->make('elements.Admin.pagination-link', ['dataList' => $contactSupportList], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
<script>
let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/contact-supports/index.blade.php ENDPATH**/ ?>