<?php
$requestSegments = Request::segments();
$actionName =  !empty($requestSegments[2]) ? $requestSegments[2]:'' ;
$routeArray = request()->route()->getAction();
$controllerAction = class_basename($routeArray['controller']);
list($controllerC, $action) = explode('@', $controllerAction);
$controller = str_replace('-controller', '', str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($controllerC, '-')));
$orgAction = $action;
$action = str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($action, '-'));
$module = new \app\Model\Admin\Modules();
$roleId = \Auth::guard('admin')->user()->role_id;

$modules = $module->fetchMenuList($roleId);
?>

<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
        <ul class="sidebar-menu" data-widget="tree">
            <li class="<?php echo e($action == 'dashboard' ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/'.config("admin.constants.ADMIN_ROUTE_NAME").'/dashboard')); ?>">
                    <i class="fa fa-tachometer"></i>
                    <span>Manage Dashboard</span>
                </a>
            </li>
            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $treeClass = [];
            $activeClass = false;
            ?>
            <?php if(count($module->children)): ?>
            <?php
            $treeClass[] = 'treeview';
            ?>
            <?php endif; ?>
            <?php if((isset($module->getPermissions[0]) && $module->getPermissions[0]->role_id == \Auth::guard('admin')->user()->role_id) || \Auth::guard('admin')->user()->role_id == config('admin.constants.SuperAdminRole')): ?>
            <?php if(count($module->children)): ?>
            <?php $__currentLoopData = $module->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if((isset($child->getPermissions[0]) && $child->getPermissions[0]->role_id == \Auth::guard('admin')->user()->role_id) || \Auth::guard('admin')->user()->role_id == config('admin.constants.SuperAdminRole')): ?>
            <?php
            $childController = strlen($child->controller) > 0?str_replace('-controller', '', str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($child->controller, '-'))):'';
            ?>
            <?php if($childController == $controller): ?>
            <?php
            $treeClass[] = 'menu-open';
            $activeClass = true;
            ?>
            <?php endif; ?>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <?php
            $childController = strlen($module->controller) > 0?str_replace('-controller', '', str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($module->controller, '-'))):'';
            ?>
            <?php if($childController == $controller): ?>
            <?php
            $treeClass[] = 'active';
            ?>
            <?php endif; ?>
            <?php endif; ?>
            <li class="<?php echo e(implode(' ', $treeClass)); ?>">
                <a href="<?php echo e(($module->path)?url('/'.config('admin.constants.ADMIN_ROUTE_NAME').$module->path):'javascript:;'); ?>">
                    <i class="<?php echo e($module->icon_class); ?>"></i>
                    <span><?php echo e($module->title); ?></span>

                    <?php if(count($module->children)): ?>
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                    <?php endif; ?>
                </a>
                <?php if(count($module->children)): ?>
                <ul class="treeview-menu<?php echo e(($activeClass)?' active':''); ?>" style="<?php echo e($activeClass?'display:block;':''); ?>">
                    <?php $__currentLoopData = $module->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if((isset($child->getPermissions[0]) && $child->getPermissions[0]->role_id == \Auth::guard('admin')->user()->role_id) || \Auth::guard('admin')->user()->role_id == config('admin.constants.SuperAdminRole')): ?>
                    <li class="<?= !empty($controller) && ($controllerC == $child->controller) ? 'active child' : ''
?>">

                        <a href="<?php echo e(($child->path)?url('/'.config('admin.constants.ADMIN_ROUTE_NAME').$child->path):'javascript:;'); ?>">
                            <i class="<?php echo e($child->icon_class); ?>"></i>
                            <span><?php echo e($child->title); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>
                <?php endif; ?>
            </li>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

    </section>
</aside>
<style>
    .sidebar-menus {
        display: block;
    }
</style>
<?php /**PATH /var/www/html/bmf-dev/resources/views/elements/Admin/base-aside.blade.php ENDPATH**/ ?>