<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="content-header">
        <h1> <?php echo e($title); ?> </h1>
        <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">
                        <?php if(count($emailTemplateList) > 0): ?>
                        <div class="emailtemp_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>Email Type</th>
                                        <th>Subject</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $emailTemplateList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $emailTemplate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(($emailTemplateList->currentpage()-1) * $emailTemplateList->perpage() + $key + 1); ?></td>

                                        <td><?php echo e($emailTemplate->emailType?$emailTemplate->emailType->name: \config('admin.constants.EmptyNotation')); ?></td>

                                        <td>
                                        <a href="<?php echo e(url($url.'/'.\Crypt::encryptString($emailTemplate->id))); ?>" class="various"
                                                data-fancybox-type="iframe" title="View"><?php echo e($emailTemplate->subject); ?></a>
                                        </td>

                                        <td class="action-btn">
                                        <!-- change status of the resource -->
                                        <span style="float:left; margin:2px 10px;">
                                            <a href="javascript:void(0)" id="<?php echo e($emailTemplate->id); ?>" data="<?php echo e(\Crypt::encryptString($emailTemplate->id)); ?>"
                                                baseUrl="<?php echo e($adminUrl.'/'.$controllerUri.'/'.\Crypt::encryptString($emailTemplate->id).'/edit'); ?>"
                                                model="<?php echo e(\Crypt::encryptString('email_templates')); ?>" class="change-status-confirm"
                                                msg="<?php echo e(__('admin/flash_msg.error.ConfirmChangeStatus')); ?>">
                                                <span style="cursor:pointer" class="glyphicon <?php echo e(($emailTemplate->status==1)?'glyphicon-ok':'glyphicon-remove'); ?>"
                                                    aria-hidden="true" title="<?php echo e(($emailTemplate->status==1)? 'Active' : 'Inactive'); ?>">
                                                </span>
                                            </a>
                                        </span>

                                        <!-- edit resource -->
                                        <span>
                                            <?php echo Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                            \Crypt::encryptString($emailTemplate->id)]]); ?>

                                            <?php echo Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left
                                            fa fa-edit', 'title' => 'Edit']); ?>

                                            <?php echo Form::close(); ?>

                                        </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>

                            </table>
                        </div>
                        <?php else: ?>
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                            </tr>
                        </table>
                        <?php endif; ?>
                    </div>
                    <!-- /.box-body -->
                    <?php if(count($emailTemplateList) > 0): ?>
                    <?php echo $__env->make('elements.Admin.pagination-link', ['dataList' => $emailTemplateList], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
    </section>
</div>
<script>
let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/email-templates/index.blade.php ENDPATH**/ ?>