<?php $__env->startSection('content'); ?>
    <div class="container my-order">
        <div class="row page-heading">
            <div class="col">
                <h1 class="page-title pb-0">Manage Transactions</h1>
            </div>
            <div class="col align-right">
                <span class="red">Pending Amount : <?php echo e(config('admin.constants.CURRENCY')); ?>

                    <?php echo e(!empty($paymentSummary[0]) ? $paymentSummary[0] : 0); ?>

                </span>
                <span class="green">Paid Amount : <?php echo e(config('admin.constants.CURRENCY')); ?>

                    <?php echo e(!empty($paymentSummary[1]) ? $paymentSummary[1] : 0); ?></span>
            </div>
            
        </div><!-- Row end -->
        <div class="row transaction_row">
            <?php echo e(Form::open(['url' => $url, 'method' => 'get'])); ?>

            <div class="search-col">
                <div class="col">
                    <?php echo e(Form::date('start_date', Request::get('start_date'), ['placeholder' => 'Start Date', 'class' => 'form-control'])); ?>

                </div>

                <div class="col">
                    <?php echo e(Form::date('end_date', Request::get('end_date'), ['placeholder' => 'End  Date', 'class' => 'form-control'])); ?>

                </div>
                <div class="col search-box">
                    <i class="icons search-icon"></i>
                    <input type="search" name="search" value="<?php echo e(Request::get('search')); ?>" placeholder="Order ID / Name">
                    <input type="submit" value="Go">
                </div>
                <div class="col">
                    <a href="<?php echo e($url); ?>" class="reset-btn">Reset</a>
                </div>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
        <div class="responsive-table">
            <table>
                <thead>
                    <tr>
                        <th>Order Date</th>
                        <th>Order ID</th>
                        <th>Customer Name</th>
                        <th>Amount</th>
                        <th>Commision</th>
                        <th>Status</th>
                        <th>Payment Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td data-title="Order Date">
                                <?php echo e(\Carbon\Carbon::parse($data->created_at)->isoFormat('D MMMM YYYY h:mm a')); ?></td>
                            <td data-title="Order ID">
                                <strong>
                                    <a
                                        href="<?php echo e(env('VENDOR_URL') . '/order/' . \Crypt::encryptString($data->id)); ?>">#<?php echo e($data->id); ?></a>
                                </strong>
                            </td>
                            <td data-title="Customer Name"><?php echo e($data->firstname . ' ' . $data->lastname); ?></td>
                            <td data-title="Amount"><?php echo e(config('admin.constants.CURRENCY')); ?> <?php echo e($data->sub_total- $data->commission); ?>

                            </td>
                            <td data-title="Commision"><?php echo e(config('admin.constants.CURRENCY')); ?> <?php echo e($data->commission); ?>

                            </td>
                            <td data-title="Status"><?php echo e($data->orderStatus->name); ?></td>
                            <td data-title="Payment Status"><?php echo e($data->vendor_payment_status == 1 ? 'Paid' : 'Un-Paid'); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5">No Orders</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <!-- paginate -->
        <?php echo e($list->links('layouts.Vendor.pagination')); ?>

        <!-- paginate -->
    </div>


    <script type="text/javascript">
        //Tab
        if (screen.width <= 900) {
            jQuery(function() {
                jQuery(".showSingle").click(function() {
                    jQuery(".showSingle").removeClass("active");
                    jQuery(this).addClass("active");
                    jQuery(".targetDiv").hide();
                    var rel = $(this).attr("rel")
                    jQuery("#" + rel).show();
                });
                jQuery("#first-anchor").trigger("click");
            });
        }
        window.onresize = function() {
            location.reload();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Vendor.vendorDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/transaction/index.blade.php ENDPATH**/ ?>