<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo e($title); ?> : <?php echo e($subTitle); ?></h1>
            <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </section>

        <!-- Main content -->
        <section class="content main_box">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <!-- general form elements -->
                    <div class="box box-primary">
                        <?php echo e(Form::model($userDetail, ['route' => [$controllerUri . '.update', \Crypt::encryptString($userDetail->id)],'method' => 'PUT','novalidate' => 'false','files' => true,'id' => $formId])); ?>


                        <div class="box-body form_box">
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Name</label>
                                        <?php echo e(Form::text('restaurant_name', $userDetail->name, ['class' => 'form-control required','id' => 'restaurant_name','placeholder' => 'Restaurant Name','onchange' => 'return trim(this)'])); ?>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Email</label>
                                        <?php echo e(Form::email('email', $userDetail->user->email, ['class' => 'form-control required ','id' => 'restaurant_email_id','disabled' => 'disabled','placeholder' => 'Email Id','onchange' => 'return trim(this)'])); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="col-md-12">Phone Number</label>

                                        <div class="col-md-3">
                                            <input value="+233" class="form-control" type="text" disabled>
                                        </div>
                                        <div class="col-md-9">
                                            <?php echo e(Form::number('restaurant_phone_number', $userDetail->user->phone_number, ['class' => 'form-control required','id' => 'restaurant_phone_number','placeholder' => 'Phone number: eg; 8888888888','onchange' => 'return trim(this)'])); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="address">Address1</label>
                                        <?php echo e(Form::text('address1', $userDetail->address1, ['class' => 'form-control required','autocomplete' => 'off','id' => 'address1','onFocus' => 'initializeAutocomplete()','placeholder' => 'Address1','onchange' => 'return trim(this)'])); ?>

                                        <span id="addressAdmin-error" class="help-block" style="color:red;"></span>

                                    </div>
                                </div>
                            </div>
                            <div class="row input_row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Bio</label>

                                        <?php echo e(Form::textarea('restaurant_bio', $userDetail->bio, ['class' => 'form-control required','id' => 'restaurant_bio','rows' => 5,'placeholder' => 'Restaurant Bio','onchange' => 'return trim(this)'])); ?>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Address2</label>
                                        <?php echo e(Form::text('address2', !empty($userDetail->address2) ? $userDetail->address2 : '', ['class' => 'form-control required','id' => 'address2','placeholder' => 'Address2','onchange' => 'return trim(this)'])); ?>

                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Region</label>
                                        <?php echo e(Form::text('country', $userDetail->region, [
                                            'class' => 'form-control required',
                                            'id' => 'country',
                                            'placeholder' => 'Region',
                                            'onchange' => 'return trim(this)',
                                        ])); ?>

                                    </div>
                                </div>

                            </div>
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="restaurant_lat">City</label>
                                        <?php echo e(Form::text('locality', $userDetail->city, ['class' => 'form-control required','id' => 'locality','placeholder' => 'City','onchange' => 'return trim(this)'])); ?>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="postal_code">Zip Code </label>
                                    <?php echo e(Form::text('postcode', $userDetail->zipcode, [
                                        'class' => 'form-control',
                                        'id' => 'postcode',
                                        'placeholder' => 'Zip Code',
                                    ])); ?>


                                    <?php echo e(Form::hidden('latitude', $userDetail->latitude, ['id' => 'latitude'])); ?>

                                    <?php echo e(Form::hidden('longitude', $userDetail->longitude, ['id' => 'longitude'])); ?>

                                </div>
                            </div>

                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="image-upload">
                                                <div class="file-label" style="text-align: left">Upload Image</div>
                                                <?php echo e(Form::file('avatar', ['id' => 'avatar'])); ?>

                                            </div>
                                        </div>
                                        <?php
                                            $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id' => $userDetail->user->id])
                                                ->latest()
                                                ->first();
                                        ?>
                                        <?php if(!empty($userAvatar->avatar)): ?>
                                            <div class="ImgPopup productimages" style="cursor: pointer"
                                                href="<?php echo e($userAvatar->avatar); ?>">
                                                <?php echo e(Html::image($userAvatar->avatar, '', ['width' => 50, 'height' => 50, 'title' => 'Restaurant Image'])); ?>

                                            </div>
                                        <?php else: ?>
                                            <div class="ImgPopup productimages" href="<?php echo e($defaultRestaurantImage); ?>">
                                                <?php echo e(Html::image($defaultRestaurantImage, null, ['width' => 50, 'height' => 50])); ?>

                                            </div>
                                        <?php endif; ?>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="restaurant_lat">Delivery Time</label>
                                    <?php echo e(Form::text('deliverytime', $userDetail->delivery_time, ['class' => 'form-control required','id' => 'deliverytime','placeholder' => 'Delivery Time','onchange' => 'return trim(this)'])); ?>

                                </div>

                            </div>
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <!-- <div class="form-group"> -->
                                    <label for="exampleInputEmail1">Restaurant Type</label>
                                    <div class="form-group">
                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="resturent_type_local"
                                                value="<?php echo e($userDetail->resturent_type_local ? 1 : 0); ?>"
                                                class="restaurantType"
                                                <?php echo e($userDetail->resturent_type_local ? 'checked' : ''); ?>>Local
                                        </label>

                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="resturent_type_continental"
                                                value="<?php echo e($userDetail->resturent_type_continental ? 1 : 0); ?>"
                                                class="restaurantType"
                                                <?php echo e($userDetail->resturent_type_continental ? 'checked' : ''); ?>>Continental
                                        </label>
                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="resturent_type_groceries"
                                                value="<?php echo e($userDetail->resturent_type_groceries ? 1 : 0); ?>"
                                                class="restaurantType"
                                                <?php echo e($userDetail->resturent_type_groceries ? 'checked' : ''); ?>>Groceries
                                        </label>
                                        <span id="restaurant_type-error" class="help-block" style="color:red;"></span>
                                    </div>
                                    <!--  </div> -->
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Commission</label>
                                        <?php echo e(Form::select('is_include_commission',[1 => 'Enable', 0 => 'Disable'],isset($userDetail->is_include_commission) && is_numeric($userDetail->is_include_commission)? $userDetail->is_include_commission: 0,['class' => 'form-control'])); ?>

                                    </div>
                                </div>


                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Status</label>
                                        <?php echo e(Form::select('status',[1 => 'Active', 0 => 'Inactive'],isset($userDetail->user->status) && is_numeric($userDetail->user->status) ? $userDetail->user->status : 0,['class' => 'form-control'])); ?>

                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="box-footer row">
                            <div class="col-md-6">
                                <?php echo e(Form::submit('Submit', ['class' => 'btn btn-success pull-right', 'id' => 'restaurantUpd'])); ?>

                            </div>
                            <div class="col-md-6">
                                <a href="<?php echo e(route('restaurant.index')); ?>">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/address.js')); ?>"></script>
    <script src="//maps.googleapis.com/maps/api/js?libraries=places&key=<?php echo e(env('ADDRESS_API_KEY')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/restaurant/edit.blade.php ENDPATH**/ ?>