<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    
    <?php if(env('APP_ENV') == 'local'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/AdminLTE.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/plugins/iCheck/square/blue.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/custom.css')); ?>">
    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/css/'.env('APP_ENV').'.errors.min.css')); ?>">
    <?php endif; ?>
    
</head>

<body class="hold-transition" style="background:#ecf0f5">
    <?php echo $__env->yieldContent('content'); ?>
    
</body>

</html><?php /**PATH /var/www/html/bmf-dev/resources/views/layouts/Admin/errors.blade.php ENDPATH**/ ?>