<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> <?php echo e($title); ?> </h1>
            <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            </div>
                        </div>

                        <div class="box-body">
                            <div class="new_product_form">
                                <div class="col-sm-6 owntable table-scrollable" style="width:100% !important;">
                                    <table id="example1" class="table table-bordered table-striped">

                                        <tr>
                                            <th scope="row"><?= __('Order ID') ?></th>
                                            <td>
                                                <?php echo e($orderData->id); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Order Status') ?></th>
                                            <td>
                                                <?php echo e($orderData->orderStatus->name); ?>


                                                <?php echo \app\Traits\OrderStatusTrait::orderStatusOptionHandler($orderData->order_status_id, $orderData->id) ?>
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Txn no') ?></th>
                                            <td>
                                                <?php echo e($orderData->transaction->txn_no); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Txn Mode') ?></th>
                                            <td>
                                                <?php echo e(\app\Helpers\CommonHelper::getTransactionMode($orderData->transaction->mode)); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Customer Name') ?></th>
                                            <td>

                                                <?php echo e($orderData->firstname . ' ' . $orderData->lastname); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Phone Number') ?></th>
                                            <td>
                                                <?php echo e($orderData->phone_number); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Email') ?></th>
                                            <td>
                                                <?php echo e($orderData->email); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Delivery Address1') ?></th>
                                            <td>
                                                <?php echo e($orderData->address1); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Delivery Address2') ?></th>
                                            <td>
                                                <?php echo e($orderData->address2); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('City') ?></th>
                                            <td>
                                                <?php echo e($orderData->city); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('State') ?></th>
                                            <td>
                                                <?php echo e($orderData->state); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Zipcode') ?></th>
                                            <td>
                                                <?php echo e($orderData->zipcode); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Address Type') ?></th>
                                            <td>
                                                <?php echo e(\app\Helpers\CommonHelper::getAddressType($orderData->address_type)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Delivery Note') ?></th>
                                            <td>
                                                <?php echo e($orderData->delivery_note); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Order Location') ?></th>
                                            <td>
                                                <div id="map" style="width:400px;height:300px;"></div>
                                            </td>
                                        </tr>


                                        <tr>
                                            <th scope="row"><?= __('Distance') ?></th>
                                            <td>
                                                <?php echo e($orderData->distance . ' Miles'); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Created at') ?></th>
                                            <td>
                                                <?php echo e(!empty($orderData->created_at) ? \Carbon\Carbon::parse($orderData->created_at)->format('d-M-Y H:i:s a') : \config('admin.constants.EmptyNotation')); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="text-center" colspan="2">Restaurant details</th>
                                        </tr>
                                        <tr>

                                        </tr>


                                        <tr>
                                            <th scope="row"><?= __('Restaurant Name') ?></th>
                                            <td>
                                                <?php echo e($orderData->restaurant->name); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant address') ?></th>
                                            <td>
                                                <?php echo e($orderData->restaurant->address1); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant phone no') ?></th>
                                            <td>
                                                <?php echo e($orderData->restaurant->user->phone_number); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant email') ?></th>
                                            <td>
                                                <?php echo e($orderData->restaurant->user->email); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant status') ?></th>
                                            <td>
                                                <?php echo e($orderData->restaurant->user->is_active == 1 ? 'Online' : 'Offline'); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th class="text-center" colspan="2">Delivery person details</th>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Name') ?></th>
                                            <td>
                                                <?php echo e(!empty($orderData->deliveryPerson->user->first_name) ? $orderData->deliveryPerson->user->first_name : \config('admin.constants.EmptyNotation')); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Phone number') ?></th>
                                            <td>
                                                <?php echo e(!empty($orderData->deliveryPerson->user->phone_number) ? $orderData->deliveryPerson->user->phone_number : \config('admin.constants.EmptyNotation')); ?>



                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Age') ?></th>
                                            <td>
                                                <?php echo e(!empty($orderData->deliveryPerson->age) ? $orderData->deliveryPerson->age : \config('admin.constants.EmptyNotation')); ?>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Image') ?></th>
                                            <td>

                                                <?php if(!empty($orderData->deliveryPerson->user->profile_image)): ?>
                                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                                        href="<?php echo e($orderData->deliveryPerson->user->profile_image); ?>">
                                                        <?php echo e(Html::image($orderData->deliveryPerson->user->profile_image, '', ['width' => 50, 'height' => 50, 'title' => 'Restaurant Image'])); ?>

                                                    </div>
                                                <?php else: ?>
                                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                                        href="<?php echo e($defaultAvatarUrl); ?>">
                                                        <?php echo e(Html::image($defaultAvatarUrl, null, ['width' => 50, 'height' => 50])); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>

                                        <tr>
                                            <th class="text-center" colspan="2">Order items</th>
                                        </tr>


                                        <tr>
                                            <td colspan="2">
                                                <table class="table table-bordered table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>Item</th>
                                                            <th>Image</th>
                                                            <th>Price</th>
                                                            <th>Qty</th>
                                                            <th>Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $orderData->orderItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($item->itemDetail->name); ?></td>
                                                                <td>

                                                                    <?php if(!empty($item->itemDetail->image)): ?>
                                                                        <div class="ImgPopup productimages"
                                                                            style="cursor: pointer"
                                                                            href="<?php echo e($item->itemDetail->image); ?>">
                                                                            <?php echo e(Html::image($item->itemDetail->image, '', ['width' => 50, 'height' => 50, 'title' => 'Profile Image'])); ?>

                                                                        </div>
                                                                    <?php else: ?>
                                                                        <div class="imgpreview"
                                                                            href="<?php echo e($defaultAvatarUrl); ?>">
                                                                            <?php echo e(Html::image($defaultAvatarUrl, null, ['width' => 50, 'height' => 50])); ?>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                    <?php echo e($item->item_price); ?></td>
                                                                <td><?php echo e($item->item_qty); ?></td>
                                                                <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                    <?php echo e($item->item_price * $item->item_qty); ?></td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        <tr>
                                                            <td colspan="4">Sub total</td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->sub_total); ?></td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Service Fee (

                                                                <?php echo e($orderData->tax_value); ?>

                                                                <?php echo e($orderData->tax_type == 'percentage' ? '%' : 'Fixed Amount '); ?>)
                                                            </td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->tax); ?></td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Commission
                                                                (<?php echo e($orderData->commission_percentage); ?>%)</td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->commission); ?></td>
                                                        </tr>


                                                        <tr>
                                                            <td colspan="4">Delivery charges</td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->delivery_charge); ?></td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Rider Revenue</td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->delivery_person_revenue); ?></td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Revenue on Delivery Charges</td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->revenue_on_delivery_charge); ?></td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Grand total</td>
                                                            <td>(<?php echo e(config('admin.constants.CURRENCY')); ?>)
                                                                <?php echo e($orderData->total_amount); ?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>



                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";
    </script>


    <script>
        // Initialize and add the map
        function initMap() {
            // The order location
            const orderLocation = {
                lat: <?php echo e($orderData->latitude); ?>,
                lng: <?php echo e($orderData->longitude); ?>

            };

            const restaurantLocation = {
                lat: <?php echo e($orderData->restaurant->latitude); ?>,
                lng: <?php echo e($orderData->restaurant->longitude); ?>

            };

            // The map, centered at orderLocation
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 8,
                center: orderLocation,
            });
            // The marker, positioned at orderLocation
            var marker = new google.maps.Marker({
                position: orderLocation,
                map: map,
                label: 'Customer'
            });

            var marker = new google.maps.Marker({
                position: restaurantLocation,
                map: map,
                label: 'Restaurant'
            });
        }
    </script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('ADDRESS_API_KEY')); ?>&callback=initMap&libraries=&v=weekly">
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/order/show.blade.php ENDPATH**/ ?>