<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(ucwords(config('app.name', 'Laravel'))); ?> | <?php echo e($title); ?> - <?php echo e($subTitle); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <?php if(env('APP_ENV') == 'local'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/AdminLTE.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/plugins/iCheck/square/blue.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/custom.css')); ?>">
    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/css/'.env('APP_ENV').'.adminLogin.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/plugins/iCheck/square/blue.css')); ?>">
    <?php endif; ?>
</head>

<body class="hold-transition login-page">

    <div class="wrapper">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <?php if(env('APP_ENV') == 'local'): ?>
    
    <!-- part1 js include -->
    <script defer src="<?php echo e(asset('resources/assets/js/jquery.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/bootstrap.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/fastclick.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/plugins/iCheck/icheck.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/plugins/jquery-validate/jquery.validate.js')); ?>"></script>
    
    <!-- js message objects to access by validation plugin -->
    <?php echo $__env->make('elements.Admin.lang.validation.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- part2 js include -->
    <script defer src="<?php echo e(asset('resources/assets/js/validation/user.js')); ?>"></script>
    <?php else: ?>

    <!-- part1 js include -->
    <script defer src="<?php echo e(asset('public/js/'.env('APP_ENV').'.adminLogin.min.js')); ?>"></script>
    <!-- js message objects to access by validation plugin -->
    <?php echo $__env->make('elements.Admin.lang.validation.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- part2 js include -->
    <script defer src="<?php echo e(asset('public/js/'.env('APP_ENV').'.adminLogin1.min.js')); ?>"></script>
    <?php endif; ?>
</body>

</html><?php /**PATH /var/www/html/bmf-dev/resources/views/layouts/Admin/adminLogin.blade.php ENDPATH**/ ?>