<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> <?php echo e($title); ?> </h1>
            <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                <?php echo e(Form::open(['method' => 'get', 'class' => 'form-horizontal'])); ?>

                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-4">
                                        <?php echo e(Form::text('search', app('request')->input('search'), ['placeholder' => 'Order ID / Username','class' => 'form-control'])); ?>

                                    </div>
                                    <div class="col-sm-2">
                                        <?php echo e(Form::date('start_date', app('request')->input('start_date'), ['placeholder' => 'End Date','class' => 'form-control'])); ?>

                                    </div>

                                    <div class="col-sm-2">
                                        <?php echo e(Form::date('end_date', app('request')->input('end_date'), ['placeholder' => 'End Date','class' => 'form-control'])); ?>

                                    </div>

                                    <div class="col-sm-2">
                                        <?php echo e(Form::submit('Search', ['class' => 'btn btn-success'])); ?>

                                        <a href="<?php echo e($url); ?>" class="btn btn-default">Reset</a>
                                    </div>


                                </div>
                                <?php echo e(Form::close()); ?>

                            </div>
                        </div>

                        <div class="box-body">
                            <?php if(count($notificationList) > 0): ?>
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th width="5%">Date</th>
                                                <th width="5%">Order ID</th>
                                                <th width="15%">User</th>
                                                <th width="15%">User Type</th>
                                                <th width="15%">Phone Number</th>
                                                <th width="15%">Email</th>
                                                <th width="15%">Title</th>
                                                <th width="15%">Description</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $srNo = $limit * ($page - 1) + 1;
                                            ?>
                                            <?php $__currentLoopData = $notificationList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr
                                                    class="<?php echo e($notification->is_read == 1 ? 'read-notification-tr' : 'unread-notification-tr'); ?>">
                                                    <td><?php echo e(\Carbon\Carbon::parse($notification->created_at)->format('M d,Y h:i a')); ?>

                                                    </td>
                                                    <td> <?php echo e($notification->order_id); ?> </td>

                                                    <td>
                                                        <?php if($notification->user->role_id == config('admin.constants.RESTAURANT_OWNER_ROLE')): ?>
                                                            <?php echo e($notification->restaurant->name); ?>

                                                        <?php else: ?>
                                                            <?php if($notification->user->is_delivery_person == 1): ?>
                                                                <?php echo e($notification->user->first_name . ' ' . $notification->user->last_name); ?>

                                                            <?php else: ?>
                                                                <?php echo e($notification->user->first_name . ' ' . $notification->user->last_name); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e(\app\Helpers\CommonHelper::getRoleForNotification($notification->user->role_id, $notification->action_id)); ?>

                                                    </td>
                                                    <td><?php echo e($notification->user->phone_number); ?> </td>
                                                    <td><?php echo e($notification->user->email); ?> </td>

                                                    <td>
                                                        <?php if(!empty($notification->order_id)): ?>
                                                            <a target="_blank"
                                                                href="<?php echo e(url(config('admin.constants.ADMIN_ROUTE_NAME') . '/order/' . \Crypt::encryptString($notification->order_id))); ?>">
                                                                <?php echo e($notification->title); ?>

                                                            </a>
                                                        <?php else: ?>
                                                            <?php echo e($notification->title); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($notification->description); ?> </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                                    </tr>
                                </table>
                            <?php endif; ?>
                        </div>
                        <?php if(count($notificationList) > 0): ?>
                            <?php echo $__env->make('elements.Admin.pagination-link', [
                                'dataList' => $notificationList,
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/notification/index.blade.php ENDPATH**/ ?>