<?php
$viewUrl = url()->current().'/'.\Crypt::encryptString($row->id);
$statusTitle = 'Inactive';
$statusValue = 1;
//$statusIconClass = 'fa fa-fw fa-check';
$statusIconClass = 'glyphicon glyphicon-remove';
$isChecked = "";
if($row->status == 1){
    $statusTitle = 'Active';
    $statusValue = 0;
    $statusIconClass = 'glyphicon glyphicon-ok';
    $isChecked = "checked";
}


$id = \Crypt::encryptString($row->id);
$editUrl = env('VENDOR_URL').'/menu/'.$id.'/edit';
?>
<?php if($controlType=='all'): ?>
    <div class="col-status">
        <div class="title-mob">status</div>
        <div class="status">
            <div class="switch-btn" id="switch-btn-<?php echo e($row->id); ?>">
                <label class="switch">
                    <input type="checkbox" data="<?php echo e($id); ?>" baseUrl="<?php echo e($editUrl); ?>" class="change-restaurant-menu-status" msg="<?php echo e(__('admin/flash_msg.error.ConfirmChangeStatus')); ?>" <?php echo e($isChecked); ?>>
                    <span class="slider round"></span>
                </label>
                <?php echo e($statusTitle); ?>

            </div>							
        </div>
    </div>
    

    <div class="col-action">
        <div class="title-mob">action</div>
        <div class="action-btns">
            <a href="<?php echo e($viewUrl); ?>"  class="view">View</a>
            <a href="#delete-model-<?php echo e($row->id); ?>" data-toggle="modal" data-keyboard="true" class="delete">Delete</a>
            <div class="modal fade" id="delete-model-<?php echo e($row->id); ?>" tabindex='-1'>
                <div class="vertical-alignment-helper">
                    <div class="modal-dialog vertical-align-center">
                        <div class="modal-content success-model delete-model">
                            <div class="modal-body">
                                <div class="exclamation"><i class="icons excl-icon"></i></div>
                                <h3>Are you sure you want to delete this menu item</h3>
                                <p class="text-gray">You will not be able to recover it</p>
                                <?php echo Form::open(['method' => 'DELETE', 'route' => [$controllerUri.'.destroy',
                                        \Crypt::encryptString($row->id)]]); ?>

                                <div class="modal-btn-group">
                                    <button type="button" class="btn btn-cancel" data-dismiss="modal">Cancel</button>
                                    
                                        <?php echo Form::button('Yes, delete it', [
                                        'type' => 'submit',
                                        'class' => 'btn btn-primary',
                                        'data-id'=>\Crypt::encryptString($row->id),
                                        'id'=>'delete-restaurant-'.$row->id,
                                        'title' => 'Delete',
                                        ]); ?>

                                </div>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>



            
           
            
        </div>	
    </div>
<?php endif; ?>


<?php if($controlType=='statusHandler'): ?>

<div class="switch-btn" id="switch-btn-<?php echo e($row->id); ?>">
    <label class="switch">
        <input type="checkbox" data="<?php echo e($id); ?>" baseUrl="<?php echo e($editUrl); ?>" class="change-restaurant-menu-status"  <?php echo e($isChecked); ?>>
        <span class="slider round"></span>
    </label>
    <?php echo e($statusTitle); ?>

</div>
<?php endif; ?>


<?php if($controlType=='deleteButton'): ?>

        <a href="#delete-model-<?php echo e($row->id); ?>" data-toggle="modal" data-keyboard="true" class="delete">Delete</a>
        <div class="modal fade" id="delete-model-<?php echo e($row->id); ?>" tabindex='-1'>
            <div class="vertical-alignment-helper">
                <div class="modal-dialog vertical-align-center">
                    <div class="modal-content success-model delete-model">
                        <div class="modal-body">
                            <div class="exclamation"><i class="icons excl-icon"></i></div>
                            <h3>Are you sure you want to delete this menu item</h3>
                            <p class="text-gray">You will not be able to recover it</p>
                            <?php echo Form::open(['method' => 'DELETE', 'route' => [$controllerUri.'.destroy',
                                    \Crypt::encryptString($row->id)]]); ?>

                            <div class="modal-btn-group">
                                <button type="button" class="btn btn-cancel" data-dismiss="modal">Cancel</button>
                                
                                    <?php echo Form::button('Yes, delete it', [
                                    'type' => 'submit',
                                    'class' => 'btn btn-primary',
                                    'data-id'=>\Crypt::encryptString($row->id),
                                    'id'=>'delete-restaurant-'.$row->id,
                                    'title' => 'Delete',
                                    ]); ?>

                            </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php endif; ?>



<?php if($controlType=='editHandler'): ?>
<span>
    <?php echo Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
    \Crypt::encryptString($row->id)]]); ?>

    <?php echo Form::button('Edit', ['type' => 'submit', 'class' => 'actions-edit-btn', 'title' => 'Edit'  ]); ?>

    <?php echo Form::close(); ?>

</span>
<?php endif; ?>

<?php /**PATH /var/www/html/bmf-dev/resources/views/elements/vendor/action-link-restaurant-menu.blade.php ENDPATH**/ ?>