<?php
$emailFlag = $passFlag = false;
?>
<?php $__env->startSection('content'); ?>
<section class="login-page">
  <div class="login-container">
	<article class="lft-section">
		
			<div class="logo">
				<a href="<?php echo e($url); ?>"><img src="<?php echo e(asset('resources/assets/vendor/images/logo.png')); ?>" alt="" title=""></a>
			</div>
			<h1>Grow Your Business</h1>
			<p>Reach new customers, increase your sales and grow your business.</p>
			<figure>
				<img src="<?php echo e(asset('resources/assets/vendor/images/order.png')); ?>" alt="" title="">
			</figure>
		
	</article>
	<article class="rgt-section">
		
		<h2>Create Account</h2>
		<p>Sign up to get started!</p>
		    <?php echo $__env->make('Vendor.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<?php echo Form::open(['method' => 'POST', 'class' => 'form-section', 'id'=> $formId]); ?>

			<div class="form-group">
				<label>Restaurant name<span class="required">*</span></label>
				<?php echo e(Form::text('name', null, array('class'=>'form-control required', 'id'=>'name','placeholder' => 'Enter restaurant name'))); ?>

			</div>
			<div class="form-group">
			   <label>Restaurant bio<span class="required">*</span></label>
			   <?php echo e(Form::textarea('bio', null, array('class'=>'form-control required', 'id'=>'bio','placeholder' => 'Enter restaurant bio'))); ?>

			</div>
			<div class="form-group">
				<label>Restaurant type<span class="required">*</span></label>
				
				<div class="restaurant-row">
					<div class="custom-checkbox">
						<label>
						   <?php echo e(Form::checkbox('local', null, null, array('id'=>'local' ,'class'=>'restaurantTypes'))); ?>

							<span id="local-span">Local</span>
						</label>
					</div>
					<div class="custom-checkbox">
						<label>
						<?php echo e(Form::checkbox('continental', null,  null , array('id'=>'continental' ,'class'=>'restaurantTypes'))); ?>

							<span id="continental-span">Continental</span>
						</label>
					</div>
					<div class="custom-checkbox">
						<label>
						<?php echo e(Form::checkbox('groceries', null, null , array('id'=>'groceries' ,'class'=>'restaurantTypes'))); ?>

							<span id="groceries-span">Groceries</span>
						</label>
					</div>
				</div>
				<div id="restaurant-type-error">	</div>
			</div>
			<div class="form-group">
				<label>Email<span class="required">*</span></label>
				<?php echo e(Form::email('email', null, array('class'=>'form-control required', 'id'=>'email','placeholder' => 'Enter email address'))); ?>

			</div>
			<div class="form-group">
				<label>Phone<span class="required">*</span></label>
				   <div class="input-group">
				   	 <span class="input-addon"> +233 </span>
				      <?php echo e(Form::number('phone_number', null, array('class'=>'input-field required', 'id'=>'phone_number',
				                       'placeholder' => 'Enter phone number'))); ?>

				  </div>
			</div>

			<div class="form-group">
				<label>Address1<span class="required">*</span></label>
				<div class="relative-box">
					<?php echo e(Form::text('address1', null, array('class'=>'form-control', 'autocomplete'=>'off', 'id'=>'address1', 
					            'onFocus'=>'initializeAutocomplete()','placeholder' => 'Enter address'))); ?>

					<div class="icons map-icon"></div>
					<div id="address-web-error"></div>
				</div>
			</div>
			<div class="form-group">
				<label>Address2<span class="required">*</span></label>
				<?php echo e(Form::text('address2', null, array('class'=>'form-control', 'id'=>'address2','placeholder' => 'Enter street, landmark…'))); ?>

			</div>

			<div class="form-group">
				<label>CITY<span class="required">*</span></label>
					<?php echo e(Form::text('locality', null, array('class'=>'form-control required', 'id'=>'locality','placeholder' => 'City', 'onchange' => "return trim(this)"))); ?>

			</div>
			 <div class="row">
					<div class="col">
						<div class="form-group">
						<label>Region<span class="required">*</span></label>
						<?php echo e(Form::text('country', null, array('class'=>'form-control', 'id'=>'country','placeholder' => 'Region'))); ?>

					   </div>
					</div>
					<div class="col">
						<div class="form-group">
							<label>Zip code</label>
							<?php echo e(Form::number('postcode', null, array('class'=>'form-control', 'id'=>'postcode', 'placeholder' => 'Zip code'))); ?>


							<?php echo e(Form::hidden('latitude', null, ['id'=>'latitude'])); ?>

              <?php echo e(Form::hidden('longitude', null, ['id'=>'longitude'])); ?>

					    </div>
					</div>
				</div>
				<div class="form-group">
					<label>password<span class="required">*</span></label>
					<div class="password-input">
						<!-- <?php echo e(Form::input('password', 'password', null, array('class'=>'form-control required', 'id'=>'password','placeholder' => 'Enter password'))); ?> -->
						<input type="password" id="password" name="password" class="form-control required" placeholder="Enter password">
						
						<div class="pshow-icon">
							<a href="javascript:void(0)"><span toggle="#password-field" class="show-eye toggle-password"></span></a>
						</div>
					</div>
				</div>
				
				<div class="form-group">
					<label>Confirm Password<span class="required">*</span></label>
					<div class="password-input">
						<!-- <?php echo e(Form::input('password', 'password_confirmation', null, array('class'=>'form-control required', 'id'=>'password_confirmation','placeholder' => 'Re-enter password'))); ?> -->
						<input type="password" id="password_confirmation" name="password_confirmation" class="form-control required" 
						  placeholder="Re-enter password">

						<div class="pshow-icon">
							<a href="javascript:void(0)"><span toggle="#password-field" class="show-eye toggle-password-conf"></span></a>
						</div>
					</div>
				</div>

				<div class="form-group mb-0">
					<div class="d-flex">
					<div class="custom-checkbox">
						<label>
						   <?php echo e(Form::checkbox('termcondition', null, null ,array('id'=>'termcondition', 'onchange' => "return trim(this)"))); ?>

							<span></span>
						</label>
					</div>

						<div class="cnt">
							By signing up, you agree to our 
							<a href="<?php echo e($url.'/terms-of-services'); ?>" target="_blank" class="text-link">Terms of Services  </a> 
							  and have read and acknowledge the 
							<a href="<?php echo e($url.'/privacy-policy'); ?>" target="_blank" class="text-link">Privacy Policy</a>
						</div>
				</div>
				<div id="termcondition-error"></div>
				</div>
				<div class="form-group">
					<?php echo e(Form::input('submit', 'submit', 'Submit', array('class'=>'btn btn-primary', 'id'=>'restaurantUpd'))); ?>

				</div>
				<div class="form-group">
					<p class="account">Already have an account? <a href="<?php echo e($url); ?>" class="text-link">Login</a></p>
				</div>
	   <?php echo e(Form::close()); ?>

	</article>
		<div class="clearfix"></div>
	</div>
</section><!-- sign up-page End -->


<script defer src="<?php echo e(asset('resources/assets/js/address.js')); ?>"></script>
<script src="//maps.googleapis.com/maps/api/js?libraries=places&key=<?php echo e(env('ADDRESS_API_KEY')); ?>"></script>
<script src="<?php echo e(asset('resources/assets/vendor/js/jquery.min.js')); ?>"></script> 
<script type = "text/JavaScript"> $('input:checkbox').removeAttr('checked'); </script>

<script>
	$(document).on('click' , '.restaurantTypes' , function(){
		var checked = jQuery(".restaurantTypes:checked").length;
		if(checked > 0){
			$('#restaurant-type-error').html('');
		}
		else{
			$('#restaurant-type-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The restaurant type field is required</label>');
        $("#restaurant-type-error").focus();
		}
	});


	$(document).on('click' , '#termcondition' , function(){
		var checked = jQuery("#termcondition:checked").length;
		if(checked){
			$('#termcondition-error').html('');
		}
		else{
			$('#termcondition-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">You must agree with the terms and conditions.</label>');
		}
	});

	$(document).on('keyup' , '#address1' , function(){
		var length = jQuery("#address1").val().trim().length;
		if(length > 0){
			$('#address-web-error').html('');
		}
		else{
			$('#address-web-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The Address1 field is required for autosuggestion.</label>');
		}
	});
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Vendor.vendorRegister', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/vendor/register.blade.php ENDPATH**/ ?>