<!--
 - @auther: NMG - PR
 - @Description: Javascript validation messages & constants for user module. Values are taken from-
 -  /config/admin/constants.php
 -  /resources/lang/en/admin/validation/user.php
 - @dated: 20/Nov/2019
 -->

<?php if($formId == 'forgotPassword'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    email: {
        'maxLength': "<?php echo e(config('admin.constants.user.email.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.email.regex')); ?>",
    },
}
let objValMsgConst = {
    email: {
        'code': "<?php echo e(__('admin/validation/user.email.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.email.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.email.string')); ?>",
        'email': "<?php echo e(__('admin/validation/user.email.email')); ?>",
        'max': "<?php echo e(__('admin/validation/user.email.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/user.email.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/user.email.exists')); ?>",
    },
}
</script>
<?php elseif($formId == 'loginForm'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    email: {
        'maxLength': "<?php echo e(config('admin.constants.user.email.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.email.regex')); ?>",
    },
    password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
}
let objValMsgConst = {
    email: {
        'code': "<?php echo e(__('admin/validation/user.email.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.email.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.email.string')); ?>",
        'email': "<?php echo e(__('admin/validation/user.email.email')); ?>",
        'max': "<?php echo e(__('admin/validation/user.email.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/user.email.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/user.email.exists')); ?>",
    },
    password: {
        'code': "<?php echo e(__('admin/validation/user.password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.password.current_password')); ?>",
    },
}
</script>
<?php elseif($formId == 'signup'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    name: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.restaurant.restaurant_name.regex')); ?>",
    },
    bio: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_bio.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.restaurant.restaurant_bio.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.restaurant.restaurant_bio.regex')); ?>",
    },
    email: {
        'maxLength': "<?php echo e(config('admin.constants.restaurant.restaurant_email_id.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.restaurant.restaurant_email_id.regex')); ?>",
    },
    phone_number: {
        'minLength': "<?php echo e(config('admin.constants.user.phone_number.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.phone_number.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.phone_number.regex')); ?>",
    },
    address1: { 
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.minLength')); ?>",
    },
    city: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.minLength')); ?>",
    },
    password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    password_confirmation: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
}
let objValMsgConst = {
    name: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/restaurant.restaurant_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/restaurant.restaurant_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.restaurant_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/restaurant.restaurant_name.regex')); ?>",
    },
    bio: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.required')); ?>",
        'string': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.string')); ?>",
        'min': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.min')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.regex')); ?>",
    },
    email: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.required')); ?>",
        'string': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.string')); ?>",
        'email': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.email')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.exists')); ?>",
    },
    phone_number: {
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_phone_number.required')); ?>",
        'min': "<?php echo e(__('admin/validation/user.phone_number.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.phone_number.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.phone_number.regex')); ?>",
    },
    address1: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_address.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_address.required')); ?>",
    },
    address2: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_address2.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_address2.required')); ?>",
    },
    city: {
        'code': "<?php echo e(__('admin/validation/restaurant.city.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.city.required')); ?>",
    },
    country: {  
        'code': "<?php echo e(__('admin/validation/restaurant.region.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.region.required')); ?>",
    },
    password: {
        'code': "<?php echo e(__('admin/validation/user.password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.password.current_password')); ?>",
    },
    password_confirmation: {
        'code': "<?php echo e(__('admin/validation/user.confirm_password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.confirm_password.required')); ?>",
        'equalTo': "<?php echo e(__('admin/validation/user.confirm_password.equalTo')); ?>",
    },
    termcondition: {
        'code': "<?php echo e(__('admin/validation/restaurant.termcondition.code')); ?>", 
        'required': "<?php echo e(__('admin/validation/restaurant.termcondition.required')); ?>",
    },
}
</script>

<?php elseif($formId == 'editRestaurant'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    name: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.restaurant.restaurant_name.regex')); ?>",
    },
    bio: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_bio.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.restaurant.restaurant_bio.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.restaurant.restaurant_bio.regex')); ?>",
    },
    email: {
        'maxLength': "<?php echo e(config('admin.constants.restaurant.restaurant_email_id.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.restaurant.restaurant_email_id.regex')); ?>",
    },
    phone_number: {
        'minLength': "<?php echo e(config('admin.constants.user.phone_number.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.phone_number.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.phone_number.regex')); ?>",
    },
    address1: { 
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.minLength')); ?>",
    },
    city: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.restaurant_name.minLength')); ?>",
    },
    password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    password_confirmation: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
}
let objValMsgConst = {
    name: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/restaurant.restaurant_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/restaurant.restaurant_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.restaurant_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/restaurant.restaurant_name.regex')); ?>",
    },
    bio: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.required')); ?>",
        'string': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.string')); ?>",
        'min': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.min')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/restaurant.restaurant_bio.regex')); ?>",
    },
    email: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.required')); ?>",
        'string': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.string')); ?>",
        'email': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.email')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/restaurant.restaurant_email_id.exists')); ?>",
    },
    phone_number: {
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_phone_number.required')); ?>",
        'min': "<?php echo e(__('admin/validation/user.phone_number.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.phone_number.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.phone_number.regex')); ?>",
    },
    address1: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_address.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_address.required')); ?>",
    },
    address2: {
        'code': "<?php echo e(__('admin/validation/restaurant.restaurant_address2.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.restaurant_address2.required')); ?>",
    },
    city: {
        'code': "<?php echo e(__('admin/validation/restaurant.city.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.city.required')); ?>",
    },
    country: {  
        'code': "<?php echo e(__('admin/validation/restaurant.region.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.region.required')); ?>",
    },
    password: {
        'code': "<?php echo e(__('admin/validation/user.password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.password.current_password')); ?>",
    },
    password_confirmation: {
        'code': "<?php echo e(__('admin/validation/user.confirm_password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.confirm_password.required')); ?>",
        'equalTo': "<?php echo e(__('admin/validation/user.confirm_password.equalTo')); ?>",
    },
    termcondition: {
        'code': "<?php echo e(__('admin/validation/restaurant.termcondition.code')); ?>", 
        'required': "<?php echo e(__('admin/validation/restaurant.termcondition.required')); ?>",
    },
}
</script>
<?php elseif($formId == 'changePassword'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    new_password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    new_password_confirmation: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
}
let objValMsgConst = {
    password: {
        'code': "<?php echo e(__('admin/validation/user.password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.password.current_password')); ?>",
    },
    new_password: {
        'code': "<?php echo e(__('admin/validation/user.new_password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.new_password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.new_password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.new_password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.new_password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.new_password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.new_password.current_password')); ?>",
    },
    new_password_confirmation: {
        'code': "<?php echo e(__('admin/validation/user.new_password_confirmation.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.new_password_confirmation.required')); ?>",
        'equalTo': "<?php echo e(__('admin/validation/user.new_password_confirmation.equalTo')); ?>",
    },
}
</script>
<?php elseif($formId == 'resetPasswordForm'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    email: {
        'maxLength': "<?php echo e(config('admin.constants.user.email.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.email.regex')); ?>",
    },
    new_password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    new_password_confirmation: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
}
let objValMsgConst = {
    email: {
        'code': "<?php echo e(__('admin/validation/user.email.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.email.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.email.string')); ?>",
        'email': "<?php echo e(__('admin/validation/user.email.email')); ?>",
        'max': "<?php echo e(__('admin/validation/user.email.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/user.email.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/user.email.exists')); ?>",
    },
    new_password: {
        'code': "<?php echo e(__('admin/validation/user.new_password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.new_password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.new_password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.new_password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.new_password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.new_password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.new_password.current_password')); ?>",
    },
    new_password_confirmation: {
        'code': "<?php echo e(__('admin/validation/user.new_password_confirmation.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.new_password_confirmation.required')); ?>",
        'equalTo': "<?php echo e(__('admin/validation/user.new_password_confirmation.equalTo')); ?>",
    },
}
</script>
<?php elseif($formId == 'restaurantResetPassword'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    email: {
        'maxLength': "<?php echo e(config('admin.constants.user.email.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.email.regex')); ?>",
    },
    otp: {
        'minLength': "<?php echo e(config('admin.constants.restaurant.otp.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.restaurant.otp.maxLength')); ?>",
    },
    new_password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    new_password_confirmation: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
}
let objValMsgConst = {
    email: {
        'code': "<?php echo e(__('admin/validation/user.email.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.email.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.email.string')); ?>",
        'email': "<?php echo e(__('admin/validation/user.email.email')); ?>",
        'max': "<?php echo e(__('admin/validation/user.email.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/user.email.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/user.email.exists')); ?>",
    },
    otp: {
        'code': "<?php echo e(__('admin/validation/restaurant.otp.code')); ?>",
        'required': "<?php echo e(__('admin/validation/restaurant.otp.required')); ?>",
        'min': "<?php echo e(__('admin/validation/restaurant.otp.min')); ?>",
        'max': "<?php echo e(__('admin/validation/restaurant.otp.max')); ?>",
    },
    new_password: {
        'code': "<?php echo e(__('admin/validation/user.new_password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.new_password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.new_password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.new_password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.new_password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.new_password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.new_password.current_password')); ?>",
    },
    new_password_confirmation: {
        'code': "<?php echo e(__('admin/validation/user.new_password_confirmation.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.new_password_confirmation.required')); ?>",
        'equalTo': "<?php echo e(__('admin/validation/user.new_password_confirmation.equalTo')); ?>",
    },
}
</script>
<?php elseif($formId == 'profileEditForm'): ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    first_name: {
        'minLength': "<?php echo e(config('admin.constants.user.first_name.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.first_name.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.first_name.regex')); ?>",
    },
    last_name: {
        'minLength': "<?php echo e(config('admin.constants.user.last_name.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.last_name.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.last_name.regex')); ?>",
    },
    avatar: {
        'size': "<?php echo e(config('admin.constants.user.avatar.size')); ?>",
    },
}
let objValMsgConst = {
    first_name: {
        'code': "<?php echo e(__('admin/validation/user.first_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.first_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.first_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.first_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.first_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.first_name.regex')); ?>",
    },
    last_name: {
        'code': "<?php echo e(__('admin/validation/user.last_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.last_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.last_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.last_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.last_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.last_name.regex')); ?>",
    },
    avatar: {
        'code': "<?php echo e(__('admin/validation/user.avatar.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.avatar.required')); ?>",
        'image': "<?php echo e(__('admin/validation/user.avatar.image')); ?>",
        'mimes': "<?php echo e(__('admin/validation/user.avatar.mimes')); ?>",
        'filesize': "<?php echo e(__('admin/validation/user.avatar.filesize')); ?>",
    }
}
</script>

<?php else: ?>
<script>
let formId = "<?php echo e($formId); ?>";
let objValConst = {
    user_name: {
        minLength: "<?php echo e(config('admin.constants.user.user_name.minLength')); ?>",
        maxLength: "<?php echo e(config('admin.constants.user.user_name.maxLength')); ?>",
        regex: "<?php echo e(config('admin.constants.user.user_name.regex')); ?>",
    },
    email: {
        'minLength': "<?php echo e(config('admin.constants.user.email.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.email.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.email.regex')); ?>",
    },
    phone_number: {
        'minLength': "<?php echo e(config('admin.constants.user.phone_number.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.phone_number.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.phone_number.regex')); ?>",
    },
    mobile_no: {
        'minLength': "<?php echo e(config('admin.constants.user.mobile_no.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.mobile_no.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.mobile_no.regex')); ?>",
    },

    pincode: {
        'minLength': "<?php echo e(config('admin.constants.user.pincode.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.pincode.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.pincode.regex')); ?>",
    },
    
    password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    confirm_password: {
        'minLength': "<?php echo e(config('admin.constants.user.password.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.password.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.password.regex')); ?>",
    },
    first_name: {
        'minLength': "<?php echo e(config('admin.constants.user.first_name.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.first_name.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.first_name.regex')); ?>",
    },
    last_name: {
        'minLength': "<?php echo e(config('admin.constants.user.last_name.minLength')); ?>",
        'maxLength': "<?php echo e(config('admin.constants.user.last_name.maxLength')); ?>",
        'regex': "<?php echo e(config('admin.constants.user.last_name.regex')); ?>",
    },
    avatar: {
        'size': "<?php echo e(config('admin.constants.user.avatar.size')); ?>",
    },
};
let objValMsgConst = {
    role_id: {
        'code': "<?php echo e(__('admin/validation/user.role_id.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.role_id.required')); ?>",
    },
    facility_id: {
        'code': "<?php echo e(__('admin/validation/user.facility_id.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.facility_id.required')); ?>",
    },
    department_id: {
        'code': "<?php echo e(__('admin/validation/user.department_id.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.department_id.required')); ?>",
    },
    title_id: {
        'code': "<?php echo e(__('admin/validation/user.title_id.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.title_id.required')); ?>",
    },
    user_name: {
        'code': "<?php echo e(__('admin/validation/user.user_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.user_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.user_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.user_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.user_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.user_name.regex')); ?>",
    },
    email: {
        'code': "<?php echo e(__('admin/validation/user.email.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.email.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.email.string')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.email.regex')); ?>",
        'min': "<?php echo e(__('admin/validation/user.email.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.email.max')); ?>",
        'unique': "<?php echo e(__('admin/validation/user.email.unique')); ?>",
        'exists': "<?php echo e(__('admin/validation/user.email.exists')); ?>",
    },
    phone_number: {
        'min': "<?php echo e(__('admin/validation/user.phone_number.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.phone_number.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.phone_number.regex')); ?>",
    },
    pincode: {
        'min': "<?php echo e(__('admin/validation/user.pincode.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.pincode.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.pincode.regex')); ?>",
    },
    mobile_no: {
        'code': "<?php echo e(__('admin/validation/user.mobile_no.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.mobile_no.required')); ?>",
        'min': "<?php echo e(__('admin/validation/user.mobile_no.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.mobile_no.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.mobile_no.regex')); ?>",
    },
    password: {
        'code': "<?php echo e(__('admin/validation/user.password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.password.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.password.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.password.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.password.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.password.regex')); ?>",
        'current_password': "<?php echo e(__('admin/validation/user.password.current_password')); ?>",
    },
    confirm_password: {
        'code': "<?php echo e(__('admin/validation/user.confirm_password.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.confirm_password.required')); ?>",
        'equalTo': "<?php echo e(__('admin/validation/user.confirm_password.equalTo')); ?>",
    },
    first_name: {
        'code': "<?php echo e(__('admin/validation/user.first_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.first_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.first_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.first_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.first_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.first_name.regex')); ?>",
    },
    last_name: {
        'code': "<?php echo e(__('admin/validation/user.last_name.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.last_name.required')); ?>",
        'string': "<?php echo e(__('admin/validation/user.last_name.string')); ?>",
        'min': "<?php echo e(__('admin/validation/user.last_name.min')); ?>",
        'max': "<?php echo e(__('admin/validation/user.last_name.max')); ?>",
        'regex': "<?php echo e(__('admin/validation/user.last_name.regex')); ?>",
    },
    avatar: {
        'code': "<?php echo e(__('admin/validation/user.avatar.code')); ?>",
        'required': "<?php echo e(__('admin/validation/user.avatar.required')); ?>",
        'image': "<?php echo e(__('admin/validation/user.avatar.image')); ?>",
        'mimes': "<?php echo e(__('admin/validation/user.avatar.mimes')); ?>",
        'filesize': "<?php echo e(__('admin/validation/user.avatar.filesize')); ?>",
    }
}
</script>
<?php endif; ?>
<?php /**PATH /data_vhost/var/www/html/bmf-dev/resources/views/elements/Admin/lang/validation/user.blade.php ENDPATH**/ ?>