<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(ucwords(config('app.name', 'Laravel'))); ?> | <?php echo e($title); ?> - <?php echo e($subTitle); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('resources/assets/vendor/images/logo.png')); ?>">
    <!-- Custom styling -->
    <link href="<?php echo e(asset('resources/assets/vendor/css/bootstrap.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/plugins/select-box/bootstrap-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/custom.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/responsive.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/fonts.css')); ?>" />

    <script src="<?php echo e(asset('resources/assets/vendor/js/jquery.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/plugins/jquery-validate/jquery.validate.js')); ?>"></script>
</head>

<body>
    <main class="wrapper">
        
        <?php echo $__env->make('layouts.Vendor.header' , ['url'=>$url], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>

        </section>
        </div>
        <!-- /.content-wrapper -->

    </main><!-- wrapper End -->

    
    <script type="text/javascript" src="<?php echo e(asset('resources/assets/vendor/plugins/select-box/popper.min.js')); ?>">
    </script>
    <script type="text/javascript"
        src="<?php echo e(asset('resources/assets/vendor/plugins/select-box/bootstrap-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('resources/assets/vendor/js/bootstrap.min.js')); ?>"></script>

    <script defer src="<?php echo e(asset('resources/assets/plugins/iCheck/icheck.min.js')); ?>"></script>
    <!-- <script defer src="<?php echo e(asset('resources/assets/js/validation/restaurant.js')); ?>"></script> -->
    <script src="<?php echo e(asset('resources/assets/vendor/js/custom.js')); ?>"></script>

    <!-- js message objects to access by validation plugin -->
    <?php echo $__env->make('elements.Admin.lang.validation.restaurant', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <script type="text/javascript">
    $('.selectpicker').selectpicker({
        dropupAuto: false
    });
    $(function() {
        $(".fakeFile").each(function() {
            var $this = $(this),
                $browse = $this.children(".browse"),
                $file = $this.prev("input");
            if ( /*@cc_on!@*/ false) {
                $file
                    .parent().addClass("isIE")
                    .end()
                    .bind({
                        click: function(e) {
                            $(this).blur();
                        },
                        mousedown: function() {
                            $browse.addClass("active");
                        },
                        mouseup: function() {
                            $browse.removeClass("active");
                        },
                        mouseover: function() {
                            $browse.addClass("hover");
                        },
                        mouseout: function() {
                            $browse.removeClass("hover active");
                        },
                        change: function() {
                            $(this).next().children(".text").text($(this).val());
                        }
                    });
            } else {
                $this.bind({
                    click: function(e) {
                        $file.trigger("click");
                    },
                    mousedown: function() {
                        $browse.addClass("active");
                    },
                    mouseup: function() {
                        $browse.removeClass("active");
                    },
                    mouseover: function() {
                        $browse.addClass("hover");
                    },
                    mouseout: function() {
                        $browse.removeClass("hover active");
                    }
                });
                $file.change(function() {
                    var filename = $('input[type=file]').val().replace(/.*(\/|\\)/, '');
                    // alert($(this).val());
                    $this.children(".text").text(filename);
                });
            }
        });
    });


    //Accordion
    var Accordion = function(el, multiple) {
        this.el = el || {};
        this.multiple = multiple || false;
        var links = this.el.find('.article-title');

        links.on('click', {
            el: this.el,
            multiple: this.multiple
        }, this.dropdown)
    }
    Accordion.prototype.dropdown = function(e) {
        var $el = e.data.el;

        $this = $(this),
            $next = $this.next();

        $next.slideToggle();
        $this.parent().toggleClass('open');

        if (!e.data.multiple) {
            $el.find('.accordion-content').not($next).slideUp().parent().removeClass('open');
        };
    }

    var accordion = new Accordion($('.accordion-container'), false);
    </script>
</body>

</html>
<?php echo $__env->make('layouts.Vendor.vendorSidenav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/layouts/Vendor/vendorDatagrid.blade.php ENDPATH**/ ?>