<?php $__env->startSection('content'); ?>
    <div class="container order-detail">
        <div class="row page-heading">
            <div class="col">
                <h1 class="page-title pb-0">Order Detail</h1>
            </div>
        </div>
        <div class="border-box">
            <div class="gray-box">
                <div class="col-lft">
                    <div class="order-id">#<?php echo e($orderData->id); ?></div>
                    <div class="time">
                        <?php echo e(\Carbon\Carbon::parse($orderData->created_at)->isoFormat('D MMMM YYYY')); ?> <span>at
                            <?php echo e(\Carbon\Carbon::parse($orderData->created_at)->isoFormat('h:mm a')); ?></span></div>
                </div>
                <div class="col-rgt">
                    <div class="status">Order Status: <strong
                            class="text-orange"><?php echo e($orderData->orderStatus->name); ?></strong></div>
                    <div class="status-btn">

                        <?php if($orderData->order_status_id == config('admin.constants.ORDER_STATUS_PENDING')): ?>
                            <a href="<?php echo e(env('VENDOR_URL') . '/order/reject/' . \Crypt::encryptString($orderData->id)); ?>"
                                class="btn white-btn">Reject Order</a>
                            <a href="<?php echo e(env('VENDOR_URL') . '/order/approve/' . \Crypt::encryptString($orderData->id)); ?>"
                                class="btn btn-primary">Accept order</a>
                        <?php elseif($orderData->order_status_id == config('admin.constants.ORDER_STATUS_IN_PREP')): ?>
                            <a href="<?php echo e(env('VENDOR_URL') . '/order/cancel/' . \Crypt::encryptString($orderData->id)); ?>"
                                class="btn btn-danger">Cancel Order</a>
                            <?php if(!empty($assignmentData)): ?>
                                <a href="<?php echo e(env('VENDOR_URL') . '/order/handover/' . \Crypt::encryptString($orderData->id)); ?>"
                                    class="btn btn-primary <?php echo e(@$assignmentData->status == 2 ? '' : 'disabled'); ?>">Handover
                                    to rider</a>

                                <a href="<?php echo e(env('VENDOR_URL') . '/order/re-assign-rider/' . \Crypt::encryptString($orderData->id)); ?>"
                                    class="btn btn-warning <?php echo e(@$assignmentData->status == 2 ? '' : 'disabled'); ?>">Re-Assign
                                    Rider</a>
                            <?php endif; ?>
                        <?php elseif($orderData->order_status_id == config('admin.constants.ORDER_STATUS_ON_THE_WAY')): ?>
                            <?php if(!empty($assignmentData) && $assignmentData->status == 3): ?>
                                <a href="<?php echo e(env('VENDOR_URL') . '/order/re-assign-rider/' . \Crypt::encryptString($orderData->id)); ?>"
                                    class="btn btn-warning <?php echo e(@$assignmentData->status == 3 ? '' : 'disabled'); ?>">Re-Assign
                                    Rider</a>
                            <?php endif; ?>
                        <?php else: ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <ul class="my-order-list">
                <?php $__empty_1 = true; $__currentLoopData = $orderData->orderItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li>
                        <figure>
                            <?php if(!empty($item->itemDetail->image)): ?>
                                <img src="<?php echo e($item->itemDetail->image); ?>" alt="<?php echo e($item->itemDetail->name); ?>"
                                    title="<?php echo e($item->itemDetail->name); ?>">
                            <?php else: ?>
                                <img src="<?php echo e(config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE')); ?>"
                                    alt="<?php echo e($item->itemDetail->name); ?>" title="<?php echo e($item->itemDetail->name); ?>">
                            <?php endif; ?>

                        </figure>
                        <div class="order-description">
                            <div class="order-category">
                                <div class="column">
                                    <span>ITEM NAME</span>
                                    <?php echo e($item->itemDetail->name); ?>

                                </div>
                                <div class="column category">
                                    <span>Category</span>
                                    <?php echo e($item->itemDetail->foodCategory->name); ?>

                                </div>
                                <div class="column price">
                                    <?php echo e($item->item_qty); ?> x
                                    <div class="amount">
                                        <i class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                                        <?php echo e($item->item_price); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="delivery-note">
                                <span>Delivery note</span>
                                <p><?php echo e($orderData->delivery_note); ?></p>
                            </div>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p>No item found</p>
                <?php endif; ?>

            </ul>

            <?php if($orderData->delivery_person_id > 0): ?>
                <div class="customer-details">
                    <div class="address-box">
                        <div class="title">Customer Details</div>
                        <p><strong>NAME</strong> <?php echo e($orderData->firstname . ' ' . $orderData->lastname); ?></p>
                        <p><strong>CONTACT NUMBER</strong> +233 <?php echo e($orderData->phone_number); ?></p>
                        <p><strong>ADDRESS</strong> <?php echo e($orderData->address1); ?><br><?php echo e($orderData->city); ?> ,
                            <?php echo e($orderData->country); ?></p>
                    </div>
                    <?php if(!empty($assignmentData) && $assignmentData->status == 2): ?>
                        <div class="address-box">
                            <div class="title">Rider Details</div>
                            <p><strong>NAME</strong>
                                <?php echo e($deliveryPersonData->user->first_name . ' ' . $deliveryPersonData->user->last_name); ?>

                            </p>
                            <p><strong>Age</strong> <?php echo e($deliveryPersonData->age); ?></p>
                            <p><strong>Contact number</strong> +233 <?php echo e($deliveryPersonData->user->phone_number); ?></p>
                        </div>
                    <?php else: ?>
                        <div class="address-box order-not-accepted">
                            <div class="title">Rider Details</div>
                            <p>The order has been not accepted yet by rider</p>
                        </div>
                    <?php endif; ?>


                </div>
            <?php else: ?>
                <div class="customer-details">
                    <div class="address-box w-100">
                        <div class="title">Customer Details</div>
                        <p><strong>NAME</strong> <?php echo e($orderData->firstname . ' ' . $orderData->lastname); ?></p>
                        <p><strong>CONTACT NUMBER</strong> +233 <?php echo e($orderData->phone_number); ?></p>
                        <p><strong>ADDRESS</strong> <?php echo e($orderData->address1); ?><br><?php echo e($orderData->city); ?> ,
                            <?php echo e($orderData->country); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <div class="total-amount">
                Sub Total:
                <div class="price"><i class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                    <?php echo e($orderData->sub_total); ?></div>

            </div>
            <div class="total-amount">
                BMF Commission:
                <div class="price"><i class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                    <?php echo e($orderData->commission); ?></div>

            </div>
            <div class="total-amount">
                Restaurant Revenue:
                <div class="price"><i class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                    <?php echo e($orderData->sub_total - $orderData->commission); ?></div>

            </div>
        </div><!-- border-box -->
    </div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Vendor.vendorDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/order/show.blade.php ENDPATH**/ ?>