<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(ucwords(config('app.name', 'Laravel'))); ?> | <?php echo e($title); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/jquery.fancybox.css?v=2.1.5')); ?>">


    <!-- load admin css -->
    <?php if(env('APP_ENV') == 'local'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/ionicons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/AdminLTE.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/blue.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/skin-blue.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/css/custom.css')); ?>">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/css/'.env('APP_ENV').'.adminPopup.min.css')); ?>">
    <?php endif; ?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <!-- ./wrapper -->
    <?php if(env('APP_ENV') == 'local'): ?>
    <script defer src="<?php echo e(asset('resources/assets/js/jquery.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/bootstrap.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/fastclick.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/adminlte.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/icheck.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/jquery.confirm.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/ckeditor.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('resources/assets/js/custom.js')); ?>"></script>
    <?php else: ?>
    <script defer src="<?php echo e(asset('public/js/'.env('APP_ENV').'.adminPopup.min.js')); ?>"></script>
    <?php endif; ?>

    <script defer src="<?php echo e(asset('resources/assets/js/jquery.fancybox.pack.js?v=2.1.5')); ?>"></script>
</body>

</html><?php /**PATH /var/www/html/bmf-dev/resources/views/layouts/Admin/adminPopup.blade.php ENDPATH**/ ?>