<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <?php echo $__env->make('Admin.flash_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> <?php echo e($title); ?> </h1>
        <?php echo $__env->make('elements.Admin.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            <?php echo e(Form::open(array('method' => 'get', 'class' => 'form-horizontal'))); ?>

                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    <?php echo e(Form::text('search', app('request')->input('search'), ['placeholder'=>'Name', 'class'=>'form-control'])); ?>

                                </div>
                                <div class="col-sm-2">
                                    <?php echo e(Form::submit('Submit', ['class'=>'btn btn-success'])); ?>

                                    <a href="<?php echo e($url); ?>" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2">
                                    <a href="<?php echo e($url.'/create'); ?>" title="Add Category"
                                        class="btn btn-primary pull-left addButton">+ Add Category</a>
                                </div>
                                
                            </div>
                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                    <div class="box-body">
                        <?php if(count($userList) > 0): ?>
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="5%">Sr.No.</th>
                                        <th width="15%">Category</th>
                                        <th width="15%">Image</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $srNo = $limit*($page -1) + 1;
                                    ?>
                                    <?php $__currentLoopData = $userList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($srNo++); ?></td>
                                       
                                        <td><?php echo e(!empty($user->name) ? $user->name : \config('admin.constants.EmptyNotation')); ?></td>
                                        
                                        <td> 
                                           <?php if(!empty($user->image)): ?>
                                           <div class="ImgPopup productimages" style="cursor: pointer"
                                                href="<?php echo e($user->image); ?>">
                                                <?php echo e(Html::image($user->image, '', array('width' => 50,'height' => 50, 'title' => 'Category Image'))); ?>

                                            </div>
                                            
                                            <?php else: ?>
                                            <div class="ImgPopup productimages" href="<?php echo e($defaultAvatarUrl); ?>">
                                                <?php echo e(Html::image($defaultAvatarUrl, null, array('width' => 50, 'height' => 50))); ?>

                                            </div>
                                            <?php endif; ?>
                                        </td>

                                        <td class="action-btn-permission">
                                            <?php echo $__env->make('elements.Admin.actions-link', ['row' => $user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                        <span style="float:left; margin-left:10px">
                                      <?php if($user->isFav==1): ?> 
                                        <button type="submit" data-status="0" id="fav_<?php echo e($user->id); ?>" onclick="makefav(<?php echo e($user->id); ?>, 0);" class="actions-btn pull-left fa fa-solid fa-heart" title="Make Unfavroite"  style="color:red"></button>   
                                       <?php else: ?>             
                                       
                                        <button type="submit" data-status="1" id="unf_<?php echo e($user->id); ?>" onclick="makefav(<?php echo e($user->id); ?>, 1);" class="actions-btn pull-left
                                        fa fa-regular fa-heart" title="Make Favroite"></button> 
                                        <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    <?php echo e(config('flash_msg.NoRecordFound')); ?></td>
                            </tr>
                        </table>
                        <?php endif; ?>
                    </div>
                    <?php if(count($userList) > 0): ?>
                    <?php echo $__env->make('elements.Admin.pagination-link', ['dataList' => $userList], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";

function makefav(catID, status){
    if(status==0){
    var dstatus = $('#fav_'+catID).attr('data-status');
    }else{
        var dstatus = $('#unf_'+catID).attr('data-status');
    }
   
    console.log(dstatus);
    if(dstatus !=''){
        status = dstatus;
    }
        if(status ==1){
            var text = "Are you sure to make it favroite?";
            
        }else{
            var text = "Are you sure to make it unfavroite?";
 
        }
        var _token = $('meta[name="csrf-token"]').attr("content");

        let adminURL = "<?php echo e(\Config('admin.path.ADMIN_BASE_URL')); ?>";
        if (confirm(text) == true) { 

            $.ajax({
                url: adminURL + "/makeFavroite",
                type: "post",
                data: {
                    status: status,
                    id: catID,
                    _token: _token
                },
                success: function(data) {
                    if(status ==1){ 
                        $('#unf_'+catID).css('color','red');
                      

                        $('#unf_'+catID).attr('data-status',0);
                      
                        }else{
                            $('#fav_'+catID).css('color','');                           
                            $('#fav_'+catID).attr('data-status',1);
                        
                        }  


                        location.reload();
                }
            });

        };
 
       
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Admin.adminDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Admin/category/index.blade.php ENDPATH**/ ?>