<?php $__env->startSection('content'); ?>
    <div class="container my-order">
        <div class="row page-heading">
            <div class="col">
                <h1 class="page-title pb-0">Order Listing</h1>
            </div>
            <?php echo e(Form::open(['url' => $url, 'method' => 'get'])); ?>

            <div class="col search-col">
                <div class="search-box">
                    <i class="icons search-icon"></i>
                    <input type="search" name="search" value="<?php echo e(Request::get('search')); ?>" placeholder="Search">
                    <input type="submit" value="Go">
                </div>
            </div>
            <?php echo e(Form::close()); ?>

        </div><!-- Row end -->
        <div class="mob-tab">
            <ul>
                <li><a href="javascript:void(0)" class="showSingle active" id="first-anchor" rel="div1">New Orders</a></li>
                <li><a href="javascript:void(0)" class="showSingle" rel="div2">Punched Orders</a></li>
            </ul>
        </div>
        <div class="order-list">
            <div class="border-box targetDiv" id="div1">
                <div class="heading">
                    <h2>New Orders <span class="count">(<?php echo e($pendingList->total()); ?>)</span>
                </div>
                <?php $__empty_1 = true; $__currentLoopData = $pendingList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="white-box">
                        <div class="column first">
                            <strong><a
                                    href="<?php echo e(env('VENDOR_URL') . '/order/' . \Crypt::encryptString($order->id)); ?>">#<?php echo e($order->id); ?></a></strong>
                            <?php
                                date_default_timezone_set('Africa/Accra');
                                echo date_format($order->created_at, 'd M, h:i a');
                            ?>
                        </div>
                        <div class="column second">
                            Order Amount
                            <strong class="amount"><i
                                    class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                                <?php echo e($order->sub_total); ?></strong>
                        </div>
                        <div class="column third">
                            <a href="<?php echo e(env('VENDOR_URL') . '/order/approve/' . \Crypt::encryptString($order->id)); ?>"
                                class="order-btn accept"><span>Accept Order</span></a>
                            <a href="<?php echo e(env('VENDOR_URL') . '/order/reject/' . \Crypt::encryptString($order->id)); ?>"
                                class="order-btn reject"><span>Reject Order</span></a>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p>No orders</p>
                <?php endif; ?>

                <!-- paginate -->
                <?php echo e($pendingList->appends(['type' => 'pending'])->links('layouts.Vendor.pagination')); ?>

                <!-- paginate -->
            </div><!-- border-box -->
            <div class="border-box targetDiv" id="div2">
                <div class="heading">
                    <h2>Punched Orders <span class="count">(<?php echo e($punchedList->total()); ?>)</span></h2>
                    <div class="filter">
                        <div class="select-box">
                            <select class="selectpicker order-filter form-control" data-dropup-auto="false"
                                data-url="<?php echo e($url); ?>">
                                <option>Filter</option>
                                <?php $__currentLoopData = $orderStatusList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $os): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value='<?php echo e($os->id); ?>'
                                        <?php echo e($os->id == request()->status ? 'selected' : ''); ?>><?php echo e($os->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>

                <?php $__empty_1 = true; $__currentLoopData = $punchedList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="white-box">
                        <div class="column first">
                            <strong><a
                                    href="<?php echo e(env('VENDOR_URL') . '/order/' . \Crypt::encryptString($order->id)); ?>">#<?php echo e($order->id); ?></a></strong>
                            <?php
                                date_default_timezone_set('Africa/Accra');
                                echo date_format($order->created_at, 'd M, h:i a');
                            ?>
                        </div>
                        <div class="column second">
                            Order Amount
                            <strong class="amount"><i
                                    class=""><?php echo e(config('admin.constants.CURRENCY')); ?></i>
                                <?php echo e($order->sub_total); ?></strong>
                        </div>
                        <div class="column third">
                            <a href="<?php echo e(env('VENDOR_URL') . '/order/' . \Crypt::encryptString($order->id)); ?>"
                                class="order-btn <?php echo e((new \app\Helpers\OrderTypeHelper())->orderStatus($order->orderStatus->id)); ?>">
                                <span><?php echo e($order->orderStatus->name); ?></span>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p>No orders</p>
                <?php endif; ?>
                <?php echo e($punchedList->appends(['type' => 'punched'])->links('layouts.Vendor.pagination')); ?>

                <!-- paginate -->

            </div><!-- border-box -->
        </div><!-- order-list -->
    </div>


    <script type="text/javascript">
        //Tab
        if (screen.width <= 900) {
            jQuery(function() {
                jQuery(".showSingle").click(function() {
                    jQuery(".showSingle").removeClass("active");
                    jQuery(this).addClass("active");
                    jQuery(".targetDiv").hide();
                    var rel = $(this).attr("rel")
                    jQuery("#" + rel).show();
                });
                jQuery("#first-anchor").trigger("click");
            });
        }
        window.onresize = function() {
            location.reload();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.Vendor.vendorDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/order/index.blade.php ENDPATH**/ ?>