<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"> 
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(ucwords(config('app.name', 'Laravel'))); ?> | <?php echo e($title); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('resources/assets/vendor/images/logo.png')); ?>">
    <!-- Custom styling -->
    <link href="<?php echo e(asset('resources/assets/vendor/css/bootstrap.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/plugins/select-box/bootstrap-select.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/web_style.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/responsive.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('resources/assets/vendor/css/fonts.css')); ?>"/>

</head>
<body>
    <main class="wrapper cms-wrapper">
        <header class="cms-header">
            <div class="container">
                <div class="h-left">
                    <a href="<?php echo e(config('admin.path.VENDOR_BASE_URL')); ?>">
                        <img src="<?php echo e(asset('resources/assets/vendor/images/logo.png')); ?>" alt="" title="" class="logo">
                    </a>
                </div>
            </div>
        </header>
           <?php echo $__env->yieldContent('content'); ?>
        <footer class="cms-footer">
            <div class="container">     
                <div class="copyright">
                    <p>Copyright © 2021, All rights reserved.</p> 
                </div>
            </div>
        </footer>
    </main><!-- wrapper End -->

    <script src="<?php echo e(asset('resources/assets/vendor/js/jquery.min.js')); ?>"></script> 
    <script src="<?php echo e(asset('resources/assets/vendor/js/bootstrap.min.js')); ?>"></script> 
    <script src="<?php echo e(asset('resources/assets/vendor/js/custom.js')); ?>"></script> 
</body>
</html><?php /**PATH /var/www/html/bmf-dev/resources/views/layouts/Vendor/webStaticPage.blade.php ENDPATH**/ ?>