<?php $__env->startSection('content'); ?>

<div class="container add-item-page">
    <div class="row page-heading">
        <div class="col">
            <h1 class="page-title">Add an Item</h1>
        </div>
    </div>
    <div class="border-box">
        <?php echo Form::open(['route' => [$controllerUri.'.store'], 'method' => 'POST', 'id'=>
        $formId, 'files' => true , 'class'=>"form-section"]); ?>


        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Choose Item Category<span class="required">*</span></label>
                    <div class="select-box">
                        <select class="selectpicker form-control" data-dropup-auto="false" name="food_category_id"
                            id="food_category_id" value="<?php echo e(old('food_category_id')); ?>" required>
                            <option value="">Select</option>
                            <?php $__currentLoopData = $foodCatList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foodCat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value='<?php echo e($foodCat->id); ?>'
                                <?php echo e(($foodCat->id==old('food_category_id') ? 'selected' : '')); ?>><?php echo e($foodCat->name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if ($errors->has('food_category_id')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('food_category_id'); ?>
                        <div class="error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Item Name<span class="required">*</span></label>
                    <input type="text" name="name" id="name" class="form-control character-counter"
                        value="<?php echo e(old('name')); ?>" placeholder="Enter item name" data-counter-div="name-character"
                        maxlength="80">
                    <p class="character" id="name-character"><?php echo e(strlen(old('name'))); ?>/80 characters</p>
                    <?php if ($errors->has('name')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('name'); ?>
                    <div class="error"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col-lg-6 col-md-12">
                <div class="form-group">
                    <label>Item Photo</label>
                    <div class="browser-box">
                        <div class="uploader">
                            <input type="file" name="image" size="25" value="<?php echo e(old('image')); ?>" accept="image/*">
                            <div class="fakeFile" contenteditable="false" readonly="true">
                                <p class="text">No file chosen</p>
                                <a href="javascript:void(0)" class="uiBtn browse">Choose File</a>
                            </div>
                        </div>
                    </div>
                    <?php if ($errors->has('image')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('image'); ?>
                    <div class="error"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-md-12">
                <div class="row plr-8">
                    <div class="col-lg-7 col-md-6 plr-8">
                        <div class="form-group">
                            <label>Item Prep Time in Minutes<span class="required">*</span></label>
                            <input type="number" name="prep_time" id="prep_time" class="form-control"
                                placeholder="Enter prep time" value="<?php echo e(old('prep_time')); ?>" maxlength=2  oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            <?php if ($errors->has('prep_time')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('prep_time'); ?>
                            <div class="error"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6 plr-8">
                        <div class="form-group">
                            <label>Price<span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-addon"><i class="price-icon"></i></span>
                                <input class="input-field" type="number" placeholder="Enter price" name="price"
                                    id="price" value="<?php echo e(old('price')); ?>">
                                <?php if ($errors->has('price')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('price'); ?>
                                <div class="error"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Allergy Advice<span class="required"></span></label>
                    <textarea class="form-control character-counter" name="allergy_advice" id="allergy_advice"
                        placeholder="Enter allergy advice" data-counter-div="allergy-advice-character"
                        maxlength="100"><?php echo e(old('allergy_advice')); ?></textarea>
                    <p class="character" id="allergy-advice-character"><?php echo e(strlen(old('allergy_advice'))); ?>/100
                        characters</p>
                    <?php if ($errors->has('allergy_advice')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('allergy_advice'); ?>
                    <div class="error"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Item Description<span class="required">*</span></label>
                    <textarea class="form-control character-counter" name="description" id="description"
                        placeholder="Enter item description" data-counter-div="desc-character"
                        maxlength="100"><?php echo e(old('description')); ?></textarea>
                    <p class="character" id="desc-character"><?php echo e(strlen(old('description'))); ?>/100 characters</p>
                    <?php if ($errors->has('description')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('description'); ?>
                    <div class="error"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col">
                <div class="group-btn">
                    <a  href="<?php echo e(env('VENDOR_URL').'/menu'); ?>"   class="btn btn-cancel">Cancel</a>
                    <?php echo e(Form::submit('Submit', array('class'=>'btn btn-primary'))); ?>

                </div>
            </div>
        </div><!-- row end -->
        <?php echo e(Form::close()); ?>

    </div><!-- border-box -->
</div>

<script>
    $(function(){
        $.validator.addMethod('filesize', function (value, element, param) {
            return this.optional(element) || (element.files[0].size <= param)
        }, 'File size must be less than 5 MB');

        $("#createRestaurantMenuItem").validate({
            rules: {
                    food_category_id: {
                    required: true,
                },
                name: {
                    required: true,
                    maxlength: <?php echo e(config('admin.constants.restaurant-menu.name.maxLength')); ?>,
                    minlength: <?php echo e(config('admin.constants.restaurant-menu.name.minLength')); ?>

                },
                prep_time:{
                    required:true,
                    minlength: <?php echo e(config('admin.constants.restaurant-menu.prep_time.minLength')); ?>,
                    maxlength : <?php echo e(config('admin.constants.restaurant-menu.prep_time.maxLength')); ?>

                },
                description : {
                    required : true,
                    minlength: <?php echo e(config('admin.constants.restaurant-menu.description.minLength')); ?>,
                    maxlength : <?php echo e(config('admin.constants.restaurant-menu.description.maxLength')); ?>

                },
                price : {
                    required : true,
                    minlength: <?php echo e(config('admin.constants.restaurant-menu.price.minLength')); ?>,
                },
                image: {
                    filesize: 5242880,
                }
            },
            messages: {
                food_category_id: {
                    required: "Please choose food category",
                },
                name: {
                    required: "<?php echo e(__('admin/validation/restaurant_menu.name.required')); ?>",
                    maxlength: "<?php echo e(__('admin/validation/restaurant_menu.name.max')); ?>",
                    minlength: "<?php echo e(__('admin/validation/restaurant_menu.name.min')); ?>"
                },
                prep_time:{
                    required:" <?php echo e(__('admin/validation/restaurant_menu.prep_time.required')); ?>",
                    minlength: "<?php echo e(__('admin/validation/restaurant_menu.prep_time.min')); ?>",
                    maxlength: "<?php echo e(__('admin/validation/restaurant_menu.prep_time.max')); ?>",
                    
                },
                description : {
                    required : "<?php echo e(__('admin/validation/restaurant_menu.description.required')); ?>",
                    minlength: "<?php echo e(__('admin/validation/restaurant_menu.description.min')); ?>",
                    maxlength : "<?php echo e(__('admin/validation/restaurant_menu.description.max')); ?>",
                },
                price : {
                    required : "<?php echo e(__('admin/validation/restaurant_menu.price.required')); ?>",
                    minlength: "<?php echo e(__('admin/validation/restaurant_menu.price.min')); ?>",
                    maxlength : "<?php echo e(__('admin/validation/restaurant_menu.price.max')); ?>",
                },
                

            },
            errorPlacement:function(error, element){
				
				if(element.attr("name") == "food_category_id" || element.attr("name") == "price")
                    error.insertAfter(element.parent());
                else if(element.attr("name") == "image")
                    error.insertAfter(element.parent().parent());
                else
                    error.insertAfter(element);
			},
            submitHandler: function(form) {
                form.submit();
           
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Vendor.vendorDatagrid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bmf-dev/resources/views/Vendor/menu/create.blade.php ENDPATH**/ ?>