<?php
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/', array(
    'uses' => 'Admin\AdminController@login',
    'as' => 'login',
));
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'logout', array(
    'uses' => 'Admin\AdminController@logout',
    'as' => 'logout',
));
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'dashboard', array(
    'uses' => 'Admin\AdminController@dashboard',
));
Route::match(array('GET'), '/permissions', array(
    'uses' => 'Admin\PermissionsController@index',
));
Route::resource('static-pages', 'Admin\StaticPagesController');
Route::match(array('POST'), '/image-upload', array(
    'uses' => 'Admin\StaticPagesController@uploadEditorImage',
));
Route::resource('global-settings', 'Admin\GlobalSettingsController');
Route::resource('email-templates', 'Admin\EmailTemplatesController');
Route::match(array('POST'), '/email-image-upload', array(
    'uses' => 'Admin\EmailTemplatesController@uploadEditorImage',
));
Route::resource('smtp-settings', 'Admin\SmtpSettingsController');
// Route::resource('contact-us', 'ContactUs\ContactUsController');

// Route::resource('users', 'Admin\UsersController');
Route::resource('admin-users', 'Admin\AdminUsersController');
// Route::resource('facility-users', 'Admin\FacilityUsersController');

Route::resource('delivery-persons', 'Admin\DeliveryPersonController');
/**
 * 23-June-2021 // Jaidev
 */
Route::post('delivery-persons/requestStatusHandler', 'Admin\DeliveryPersonController@requestStatusHandler');
Route::post('delivery-persons/rejectRequestForm', 'Admin\DeliveryPersonController@rejectRequestForm');
/**
 * End Custom Delivery Person Routes
 */

Route::resource('customer', 'Admin\CustomerController');

Route::resource('restaurant', 'Admin\RestaurantController');
Route::get('restaurant-approval', 'Admin\RestaurantController@restaurantApproval');

Route::get('order/reAssignRider/{id}', 'Admin\OrderController@reAssignDeliveryPerson');
Route::get('order/cancelOrder/{id}', 'Admin\OrderController@cancelOrder');
Route::get('order/complete-order/{id}', 'Admin\OrderController@completeOrder');
Route::resource('orders', 'Admin\OrderController');

Route::resource('category', 'Admin\FoodCategoryController'); 

Route::post('makeFavroite', 'Admin\FoodCategoryController@makeFavroite'); 

Route::resource('tax-setting', 'Admin\TaxSettingController');
Route::resource('commission-setting', 'Admin\CommisionSettingController');
Route::resource('delivery-charge-setting', 'Admin\DeliveryChargeSettingController');

Route::resource('public-users', 'Admin\PublicUsersController');
Route::resource('roles', 'Admin\RolesController');

Route::resource('blocked-reasons', 'Admin\BlockedReasonsController');

Route::resource('blocked-users', 'Admin\BlockedUsersController');

Route::match(array('POST'), '/update-permission', array(
    'uses' => 'Admin\PermissionsController@updatePermission',
));

Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/my-profile', array(
    'uses' => 'Admin\AdminController@myProfile',
    'as' => 'myProfile',
));
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/change-password', array(
    'uses' => 'Admin\AdminController@changePassword',
    'as' => 'changePassword',
));

Route::resource('error-logs', 'Admin\ErrorLogsController');

Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/my-profiles', array(
    'uses' => 'Admin\TestImageController@myProfile',
    'as' => 'myProfiles',
));

Route::match(array('POST', 'PUT', 'PATCH'), '/update_status', array(
    'uses' => 'Admin\BaseController@changeStatus',
    'as' => 'updateStatus',
));

Route::resource('contact-supports', 'Admin\ContactSupportController');

Route::resource('contact-title', 'Admin\ContactTitleController');
Route::resource('order', 'Admin\OrderController');
Route::resource('app-version', 'Admin\AppUpdateController');
Route::post('restaurant-transaction/paymentStatusHandler', 'Admin\RestaurantTransactionController@paymentStatusHandler');
Route::resource('restaurant-transaction', 'Admin\RestaurantTransactionController');

Route::post('rider-transaction/paymentStatusHandler', 'Admin\RiderTransactionController@paymentStatusHandler');
Route::resource('rider-transaction', 'Admin\RiderTransactionController');
