<?php

/*
|--------------------------------------------------------------------------
| Vendor Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "vendor" middleware group. Now create something great!
|
 */

Route::middleware(['PreventBackHistory'])->group(function () {
    // routes that require user to be authenticated

    Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'sign-up', array(
        'uses' => 'Vendor\VendorController@signUp',
        'as' => 'signUp',
    ));

    Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'forgot-password', array(
        'uses' => 'Vendor\VendorController@forgotPassword',
        'as' => 'forgotPassword',
    ));

    Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/reset-password/{token?}', array(
        'uses' => 'Vendor\VendorController@restaurantResetPassword',
        'as' => 'RestaurantResetPassword',
    ));

    Route::get('/reset-password-success', array(
        'uses' => 'Vendor\VendorController@restaurantResetPasswordSuccess',
        'as' => 'RestaurantResetPasswordSuccess',
    ));

    Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/verification-code', array(
        'uses' => 'Vendor\VendorController@verificationCode',
        'as' => 'VerificationCode',
    ));

    Route::match(array('GET'), '/send-otp', array(
        'uses' => 'Vendor\VendorController@sendOtp',
        'as' => 'SendOtp',
    ));
});



Route::get('webRegister', 'Vendor\VendorController@webRegister');




Route::group(['middleware' => ['auth.restaurant']], function () {
    $dir = __DIR__ . "/restaurant-route";
    if (is_dir($dir)) {
        if ($dh = opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if (strlen($file) > 5) {
                    include_once('restaurant-route/' . $file);
                }
            }
            closedir($dh);
        }
    }
});

Route::resource('terms-of-services', 'Web\TermsofservicesController');
Route::get('privacy-policy', 'Web\TermsofservicesController@privacyPolicy');

//Route::get('mailbox', 'Admin\MailboxController');

// Route::get('/foo', function () {
//     $exitCode = Artisan::call('email:send', [
//         'emailSlug' => 'broadcast_email',
//     ]);
// });
// Route::resource('mailbox', 'Admin\MailboxController');
// Route::match(array('GET', 'POST', 'PUT', 'PATCH', 'AJAX'), 'mailboxsend', array(
//     'uses' => 'Admin\MailboxController@store',
//     'as' => 'mailboxsend',
// ));
// Route::match(array('POST'), '/mailbox-image-upload', array(
//     'uses' => 'Admin\MailboxController@uploadEditorImage',
// ));
